/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.publisher.eclipse;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.pde.internal.publishing.Activator;

public class ExecutablesDescriptor {
    private File location;
    private Set<File> files;
    private String executableName;
    private boolean temporary = false;
    private final String os;
    private File iniFile;

    public static File findExecutable(String os, File root, String baseName) {
        if ("macosx".equals(os)) {
            return new File(root, baseName + ".app/Contents/MacOS/" + baseName);
        }
        if (!"win32".equals(os)) {
            return new File(root, baseName);
        }
        return new File(root, baseName + ".exe");
    }

    public static ExecutablesDescriptor createExecutablesFromFeature(File executablesFeatureLocation, String configSpec) {
        if (executablesFeatureLocation == null || !executablesFeatureLocation.exists()) {
            return null;
        }
        String[] config = AbstractPublisherAction.parseConfigSpec((String)configSpec);
        File result = new File(executablesFeatureLocation, "bin/" + config[0] + "/" + config[1] + "/" + config[2]);
        if (!result.exists()) {
            return null;
        }
        return new ExecutablesDescriptor(config[1], "launcher", result, new File[]{result});
    }

    public static ExecutablesDescriptor createDescriptor(String os, String executable, File location) {
        if ("macosx".equals(os)) {
            return ExecutablesDescriptor.createMacDescriptor(os, executable, location);
        }
        if (!"win32".equals(os)) {
            return ExecutablesDescriptor.createUnixDescriptor(os, executable, location);
        }
        return ExecutablesDescriptor.createWindowsDescriptor(os, executable, location);
    }

    private static ExecutablesDescriptor createWindowsDescriptor(String os, String executable, File location) {
        ExecutablesDescriptor result = new ExecutablesDescriptor(os, executable, location, null);
        File file = new File(location, executable + ".exe");
        if (file.isFile()) {
            result.addFile(file);
            result.iniFile = new File(location, executable + ".ini");
        }
        if ((file = new File(location, "eclipsec.exe")).isFile()) {
            result.addFile(file);
        }
        return result;
    }

    private static ExecutablesDescriptor createUnixDescriptor(String os, String executable, File location) {
        ExecutablesDescriptor result = new ExecutablesDescriptor(os, executable, location, null);
        File[] files = location.listFiles();
        int i = 0;
        while (files != null && i < files.length) {
            String extension = IPath.fromOSString((String)files[i].getName()).getFileExtension();
            if (files[i].isFile() && (extension == null || extension.equals("so"))) {
                result.addFile(files[i]);
            }
            ++i;
        }
        result.iniFile = new File(location, executable + ".ini");
        return result;
    }

    private static ExecutablesDescriptor createMacDescriptor(String os, String executable, File location) {
        File[] files = location.listFiles((dir, name) -> {
            int length = name.length();
            return length > 3 && name.substring(length - 4, length).equalsIgnoreCase(".app");
        });
        ExecutablesDescriptor result = new ExecutablesDescriptor(os, executable, location, files);
        result.iniFile = new File(location, executable + ".ini");
        return result;
    }

    public ExecutablesDescriptor(String os, String executable, File location, File[] files) {
        this.os = os;
        this.executableName = executable;
        this.location = location;
        if (files == null) {
            this.files = new HashSet<File>(11);
        } else {
            this.files = new HashSet<File>(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.addAllFiles(file);
                ++n2;
            }
        }
    }

    public ExecutablesDescriptor(ExecutablesDescriptor descriptor) {
        this.os = descriptor.os;
        this.location = descriptor.location;
        this.executableName = descriptor.executableName;
        this.temporary = descriptor.temporary;
        this.files = new HashSet<File>(descriptor.files);
    }

    public void addAllFiles(File file) {
        if (file.isFile()) {
            this.files.add(this.relativize(file));
        } else {
            File[] list;
            File absolute = file.isAbsolute() ? file : new File(this.location, file.getPath());
            File[] fileArray = list = absolute.listFiles();
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                File list1 = fileArray[n2];
                this.addAllFiles(list1);
                ++n2;
            }
        }
    }

    public void addFile(File file) {
        this.files.add(this.relativize(file));
    }

    private File relativize(File file) {
        if (!file.isAbsolute()) {
            return file;
        }
        String path = file.getPath();
        if (!path.startsWith(this.location.getPath())) {
            throw new IllegalArgumentException(file.toString() + " must be related to " + String.valueOf(this.location));
        }
        if ((path = path.substring(this.location.getPath().length())).startsWith("/") || path.startsWith("\\")) {
            path = path.substring(1);
        }
        return new File(path);
    }

    public void removeFile(File file) {
        this.files.remove(this.relativize(file));
    }

    public void replace(File oldFile, File newFile) {
        this.removeFile(oldFile);
        this.addFile(newFile);
    }

    public File[] getFiles() {
        File[] result = this.files.toArray(new File[this.files.size()]);
        int i = 0;
        while (i < result.length) {
            result[i] = new File(this.location, result[i].getPath());
            ++i;
        }
        return result;
    }

    public String getExecutableName() {
        return this.executableName;
    }

    public File getExecutable() {
        return ExecutablesDescriptor.findExecutable(this.os, this.location, this.executableName);
    }

    public File getIniLocation() {
        return this.iniFile;
    }

    public File getLocation() {
        return this.location;
    }

    public void setLocation(File value) {
        this.location = value;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setExecutableName(String value, boolean updateFiles) {
        if (updateFiles) {
            this.updateExecutableName(value);
        }
        this.executableName = value;
    }

    public void makeTemporaryCopy() {
        if (this.isTemporary()) {
            return;
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("p2.brandingIron", "");
            tempFile.delete();
            for (File file : this.files) {
                FileUtils.copy((File)this.location, (File)tempFile, (File)file, (boolean)true);
            }
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, Activator.ID, "Error publishing artifacts", (Throwable)e));
        }
        this.location = tempFile;
        this.temporary = true;
    }

    private void updateExecutableName(String newName) {
        if (newName.equalsIgnoreCase(this.executableName)) {
            return;
        }
        HashSet<File> filesCopy = new HashSet<File>(this.files);
        for (File file : filesCopy) {
            Object base = file.getParent();
            Object object = base = base == null ? "" : (String)base + "/";
            if ("macosx".equals(this.os) && ((String)base).startsWith(this.executableName + ".app")) {
                base = newName + ".app" + ((String)base).substring(this.executableName.length() + 4);
            }
            if (file.getName().equalsIgnoreCase(this.executableName)) {
                this.replace(file, new File((String)base + newName));
                continue;
            }
            if (file.getName().equalsIgnoreCase(this.executableName + ".exe")) {
                this.replace(file, new File((String)base + newName + ".exe"));
                continue;
            }
            if (file.getName().equalsIgnoreCase(this.executableName + "c.exe")) {
                this.replace(file, new File((String)base + newName + "c.exe"));
                continue;
            }
            if (file.getName().equalsIgnoreCase(this.executableName + ".ini")) {
                this.replace(file, new File((String)base + newName + ".ini"));
                continue;
            }
            if (!"macosx".equals(this.os)) continue;
            this.replace(file, new File((String)base + file.getName()));
        }
    }
}

