/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureVerifier;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.Strings;

public class PGPSignatureVerifierBuilder {
    private final PGPContentVerifierBuilderProvider verifierBuilderProvider;
    private final PGPPublicKey verificationKey;

    public PGPSignatureVerifierBuilder(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, PGPPublicKey pGPPublicKey) {
        this.verifierBuilderProvider = pGPContentVerifierBuilderProvider;
        this.verificationKey = pGPPublicKey;
    }

    public PGPSignatureVerifier buildDirectKeyVerifier(PGPSignature pGPSignature, PGPPublicKey pGPPublicKey) throws PGPException {
        if (pGPSignature.getSignatureType() != 31) {
            throw new PGPException("signature is not a direct key signature");
        }
        return this.doBuildKeyCertificationVerifier(pGPSignature, pGPPublicKey);
    }

    public PGPSignatureVerifier buildKeyRevocationVerifier(PGPSignature pGPSignature, PGPPublicKey pGPPublicKey) throws PGPException {
        if (pGPSignature.getSignatureType() != 32) {
            throw new PGPException("signature is not a key revocation signature");
        }
        return this.doBuildKeyCertificationVerifier(pGPSignature, pGPPublicKey);
    }

    public PGPSignatureVerifier buildPrimaryKeyBindingVerifier(PGPSignature pGPSignature, PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        if (pGPSignature.getSignatureType() != 25) {
            throw new PGPException("signature is not a primary key binding signature");
        }
        return this.doBuildKeyBindingVerifier(pGPSignature, pGPPublicKey, pGPPublicKey2);
    }

    public PGPSignatureVerifier buildSubKeyBindingVerifier(PGPSignature pGPSignature, PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        if (pGPSignature.getSignatureType() != 24) {
            throw new PGPException("signature is not a subkey binding signature");
        }
        return this.doBuildKeyBindingVerifier(pGPSignature, pGPPublicKey, pGPPublicKey2);
    }

    public PGPSignatureVerifier buildSubKeyRevocationVerifier(PGPSignature pGPSignature, PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        if (pGPSignature.getSignatureType() != 40) {
            throw new PGPException("signature is not a primary key binding signature");
        }
        return this.doBuildKeyBindingVerifier(pGPSignature, pGPPublicKey, pGPPublicKey2);
    }

    public PGPSignatureVerifier buildCertificationVerifier(PGPSignature pGPSignature, String string, PGPPublicKey pGPPublicKey) throws PGPException {
        return this.buildCertificationVerifier(pGPSignature, Strings.toUTF8ByteArray((String)string), pGPPublicKey);
    }

    public PGPSignatureVerifier buildCertificationVerifier(PGPSignature pGPSignature, byte[] byArray, PGPPublicKey pGPPublicKey) throws PGPException {
        int n = pGPSignature.getSignatureType();
        if (!PGPSignature.isCertification(n) && 48 != n) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation");
        }
        return this.doBuildCertificationVerifier(pGPSignature, byArray, pGPPublicKey);
    }

    public PGPSignatureVerifier buildCertificationVerifier(PGPSignature pGPSignature, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        int n = pGPSignature.getSignatureType();
        if (!PGPSignature.isCertification(n) && 48 != n) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation");
        }
        return this.doBuildCertificationVerifier(pGPSignature, pGPUserAttributeSubpacketVector, pGPPublicKey);
    }

    private PGPSignatureVerifier doBuildCertificationVerifier(PGPSignature pGPSignature, final byte[] byArray, final PGPPublicKey pGPPublicKey) throws PGPException {
        final PGPSignature pGPSignature2 = this.createLocalSig(pGPSignature);
        return new PGPSignatureVerifier(){
            final /* synthetic */ PGPSignatureVerifierBuilder this$0;
            {
                this.this$0 = pGPSignatureVerifierBuilder;
            }

            @Override
            public int getSignatureType() {
                return pGPSignature2.getSignatureType();
            }

            @Override
            public boolean isVerified() throws PGPException {
                return pGPSignature2.doVerifyCertification(byArray, pGPPublicKey);
            }
        };
    }

    private PGPSignature createLocalSig(PGPSignature pGPSignature) throws PGPException {
        PGPSignature pGPSignature2 = new PGPSignature(pGPSignature);
        pGPSignature2.init(pGPSignature2.createVerifierProvider(this.verifierBuilderProvider).build(this.verificationKey));
        return pGPSignature2;
    }

    private PGPSignatureVerifier doBuildCertificationVerifier(PGPSignature pGPSignature, final PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, final PGPPublicKey pGPPublicKey) throws PGPException {
        final PGPSignature pGPSignature2 = this.createLocalSig(pGPSignature);
        return new PGPSignatureVerifier(){
            final /* synthetic */ PGPSignatureVerifierBuilder this$0;
            {
                this.this$0 = pGPSignatureVerifierBuilder;
            }

            @Override
            public int getSignatureType() {
                return pGPSignature2.getSignatureType();
            }

            @Override
            public boolean isVerified() throws PGPException {
                return pGPSignature2.doVerifyCertification(pGPUserAttributeSubpacketVector, pGPPublicKey);
            }
        };
    }

    private PGPSignatureVerifier doBuildKeyCertificationVerifier(PGPSignature pGPSignature, final PGPPublicKey pGPPublicKey) throws PGPException {
        final PGPSignature pGPSignature2 = this.createLocalSig(pGPSignature);
        return new PGPSignatureVerifier(){
            final /* synthetic */ PGPSignatureVerifierBuilder this$0;
            {
                this.this$0 = pGPSignatureVerifierBuilder;
            }

            @Override
            public int getSignatureType() {
                return pGPSignature2.getSignatureType();
            }

            @Override
            public boolean isVerified() throws PGPException {
                return pGPSignature2.doVerifyCertification(pGPPublicKey);
            }
        };
    }

    private PGPSignatureVerifier doBuildKeyBindingVerifier(PGPSignature pGPSignature, final PGPPublicKey pGPPublicKey, final PGPPublicKey pGPPublicKey2) throws PGPException {
        final PGPSignature pGPSignature2 = this.createLocalSig(pGPSignature);
        return new PGPSignatureVerifier(){
            final /* synthetic */ PGPSignatureVerifierBuilder this$0;
            {
                this.this$0 = pGPSignatureVerifierBuilder;
            }

            @Override
            public int getSignatureType() {
                return pGPSignature2.getSignatureType();
            }

            @Override
            public boolean isVerified() throws PGPException {
                return pGPSignature2.doVerifyCertification(pGPPublicKey, pGPPublicKey2);
            }
        };
    }
}

