/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.tests;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class AbstractTest
extends CoreMatchers {
    private static final String[] FILTERS = new String[]{"org.eclipse.jdt.internal.junit.runner.", "org.eclipse.jdt.internal.junit.ui.", "org.eclipse.jdt.internal.junit4.runner.", "org.junit.", "sun.reflect.", "java.lang.reflect.Method.invoke(", "junit.framework.Assert", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestResult$1", "junit.framework.TestSuite"};
    private static final PrintStream LOG = System.out;
    public static final IProgressMonitor LOGGER = new IProgressMonitor(){
        private String message = "";

        public void beginTask(String name, int totalWork) {
            this.filter(name);
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
            this.filter(name);
        }

        public void subTask(String name) {
            this.filter(name);
        }

        public void worked(int work) {
        }

        private void filter(String message) {
            if (message == null) {
                message = "";
            }
            if (!message.equals(this.message)) {
                AbstractTest.log(message);
            }
            this.message = message;
        }
    };
    @Rule
    public final TestWatcher failurePrinter = new FailurePrinter();
    @Rule
    public final TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        AbstractTest.log("=========================================================================================================================\n" + this.testName.getMethodName() + "\n" + "=========================================================================================================================");
    }

    @After
    public void tearDown() throws Exception {
        AbstractTest.log();
        LOGGER.setTaskName(null);
    }

    public static void log() {
        LOG.println();
    }

    public static void log(Object object) {
        if (object instanceof Throwable) {
            Throwable ex = (Throwable)object;
            AbstractTest.printStackTrace(ex);
        } else {
            LOG.println(object);
        }
    }

    public static void printStackTrace(Throwable ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtil.streamUTF((byte[])baos.toByteArray())));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            block2: while ((line = reader.readLine()) != null) {
                int i = 0;
                while (i < FILTERS.length) {
                    String filter = FILTERS[i];
                    if (line.trim().startsWith("at " + filter)) continue block2;
                    ++i;
                }
                builder.append(line);
                builder.append('\n');
            }
        }
        catch (IOException iOException) {}
        System.err.println(builder);
    }

    public static void fail(String message) throws AssertionError {
        throw new AssertionError((Object)message);
    }

    public static Matcher<Object> isNull() {
        return IsNull.nullValue();
    }

    public static Matcher<Object> isNotNull() {
        return IsNull.notNullValue();
    }

    private static final class FailurePrinter
    extends TestWatcher {
        private FailurePrinter() {
        }

        protected void failed(Throwable ex, Description description) {
            AbstractTest.printStackTrace(ex);
        }
    }
}

