/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.userguidance.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.tcp.TCPUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.om.OMPlatform;

public class CdoConnection {
    private CDOSession currentSession;
    private final String repositoryName;
    private final String protocol;
    private final String host;
    private Map<String, CDOTransaction> transactions;
    private Map<String, CDOView> views;

    public CdoConnection() {
        if (!OMPlatform.INSTANCE.isOSGiRunning()) {
            Net4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
            TCPUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
            CDONet4jUtil.prepareContainer((IManagedContainer)IPluginContainer.INSTANCE);
        }
        this.repositoryName = PreferenceConstants.getRepositoryName();
        this.protocol = PreferenceConstants.getProtocol();
        this.host = PreferenceConstants.getServerName();
        this.views = new HashMap<String, CDOView>();
        this.transactions = new HashMap<String, CDOTransaction>();
    }

    public CDOSession getSession() {
        if (this.currentSession == null || this.currentSession.isClosed()) {
            this.currentSession = this.openSession();
        }
        return this.currentSession;
    }

    private CDOSession openSession() {
        this.currentSession = (CDOSession)IPluginContainer.INSTANCE.getElement("org.eclipse.emf.cdo.sessions", "cdo", String.valueOf(this.protocol) + "://" + this.host + "?repositoryName=" + this.repositoryName);
        return this.currentSession;
    }

    public CDOTransaction getTransaction(String id) {
        if (id == null) {
            return null;
        }
        CDOTransaction result = this.transactions.get(id);
        if (result == null || result.isClosed()) {
            this.transactions.remove(id);
            result = null;
        }
        if (result == null) {
            CDOSession session = this.getSession();
            result = session.openTransaction();
            this.transactions.put(id, result);
        }
        return result;
    }

    public CDOView getView(String id) {
        if (id == null) {
            return null;
        }
        CDOView result = this.views.get(id);
        if (result == null || result.isClosed()) {
            this.views.remove(id);
            result = null;
        }
        if (result == null) {
            CDOSession session = this.getSession();
            result = session.openView();
            this.views.put(id, result);
        }
        return result;
    }

    public void dispose() {
        for (CDOView view : this.views.values()) {
            if (view == null || view.isClosed()) continue;
            view.close();
        }
        this.views.clear();
        for (CDOTransaction transaction : this.transactions.values()) {
            if (transaction == null || transaction.isClosed()) continue;
            transaction.close();
        }
        this.transactions.clear();
    }
}

