/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.builderState;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.BinaryResourceImpl;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.builderState.PersistedStateProvider;
import org.eclipse.xtext.builder.impl.BuildScheduler;
import org.eclipse.xtext.builder.impl.IBuildFlag;
import org.eclipse.xtext.builder.internal.Activator;
import org.eclipse.xtext.resource.IResourceDescription;

public class EMFBasedPersister
implements PersistedStateProvider {
    private static final Logger log = Logger.getLogger(EMFBasedPersister.class);
    @Inject
    private IWorkspace workspace;
    @Inject
    private IBuilderState builderState;
    @Inject
    private BuildScheduler buildManager;
    private Resource.Factory factory;
    private IPath cachedPath;

    /*
     * Unable to fully structure code
     */
    @Override
    public Iterable<IResourceDescription> load() {
        block24: {
            block23: {
                location = this.getBuilderStateLocation();
                if (location == null || !location.exists()) ** GOTO lbl39
                resource = this.createResource();
                if (resource == null) break block23;
                try {
                    resource.load(null);
                }
                catch (IOException exception) {
                    if (exception.getMessage().contains("Invalid signature")) {
                        resource.unload();
                        resource.load(Collections.singletonMap("BINARY", Boolean.FALSE));
                    }
                    throw exception;
                }
                var5_5 = this.loadFromResource(resource);
                location.delete();
                try {
                    if (this.workspace != null) {
                        this.addSaveParticipant();
                    }
                }
                catch (CoreException e) {
                    EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
                }
                return var5_5;
            }
            try {
                try {
                    if (this.workspace == null || !this.workspace.isAutoBuilding()) break block24;
                    this.scheduleRecoveryBuild();
                    break block24;
                    {
                        catch (Throwable var4_10) {
                            throw var4_10;
                        }
                    }
                    finally {
                        location.delete();
                    }
lbl39:
                    // 1 sources

                    if (this.workspace == null || !this.workspace.isAutoBuilding()) break block24;
                    this.scheduleRecoveryBuild();
                }
                catch (Exception e) {
                    EMFBasedPersister.log.warn((Object)("Error while loading persistable builder state from '" + location + "'. This could happen after an upgrade or if the persisted index state got corrupted. Triggering a full build. Problem was : " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")"));
                    this.scheduleRecoveryBuild();
                    try {
                        if (this.workspace == null) ** GOTO lbl67
                        this.addSaveParticipant();
                    }
                    catch (CoreException e) {
                        EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
                    }
                }
            }
            catch (Throwable var6_11) {
                try {
                    if (this.workspace != null) {
                        this.addSaveParticipant();
                    }
                }
                catch (CoreException e) {
                    EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
                }
                throw var6_11;
            }
        }
        try {
            if (this.workspace != null) {
                this.addSaveParticipant();
            }
        }
        catch (CoreException e) {
            EMFBasedPersister.log.error((Object)"Error adding builder state save participant", (Throwable)e);
        }
lbl67:
        // 5 sources

        return Collections.emptySet();
    }

    protected void addSaveParticipant() throws CoreException {
        this.workspace.addSaveParticipant((Plugin)Activator.getDefault(), new ISaveParticipant(){

            public void saving(ISaveContext context) throws CoreException {
                if (context.getKind() == 1) {
                    EMFBasedPersister.this.save(EMFBasedPersister.this.builderState.getAllResourceDescriptions());
                }
            }

            public void rollback(ISaveContext context) {
            }

            public void prepareToSave(ISaveContext context) throws CoreException {
            }

            public void doneSaving(ISaveContext context) {
            }
        });
    }

    public Iterable<IResourceDescription> loadFromResource(Resource resource) {
        ArrayList result = Lists.newArrayList((Iterable)Iterables.filter((Iterable)resource.getContents(), IResourceDescription.class));
        resource.getContents().clear();
        return result;
    }

    public void save(Iterable<IResourceDescription> descriptions) {
        Resource res = this.createResource();
        if (res != null) {
            this.saveToResource(res, descriptions);
            try {
                res.save(null);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
        }
    }

    public Resource createResource() {
        URI fileURI = this.getBuilderStateURI();
        if (fileURI == null) {
            return null;
        }
        Resource res = this.getFactory().createResource(fileURI);
        return res;
    }

    public void saveToResource(Resource res, Iterable<IResourceDescription> descriptions) {
        Iterables.addAll((Collection)res.getContents(), (Iterable)Iterables.filter(descriptions, EObject.class));
    }

    public URI getBuilderStateURI() {
        File location = this.getBuilderStateLocation();
        if (location == null) {
            return null;
        }
        URI fileURI = URI.createFileURI((String)location.getAbsolutePath());
        return fileURI;
    }

    protected File getBuilderStateLocation() {
        IPath path;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            if (this.cachedPath != null) {
                return this.cachedPath.toFile();
            }
            return null;
        }
        this.cachedPath = path = activator.getStateLocation().append("builder.state");
        return path.toFile();
    }

    public void setFactory(Resource.Factory factory) {
        this.factory = factory;
    }

    public Resource.Factory getFactory() {
        if (this.factory == null) {
            this.factory = new XMIResourceFactoryImpl(){

                public Resource createResource(URI uri) {
                    ResourceDescriptionResource resourceDescriptionResource = new ResourceDescriptionResource(uri);
                    NoOpURIHandler uriHandler = new NoOpURIHandler();
                    resourceDescriptionResource.getDefaultSaveOptions().put("BINARY", Boolean.TRUE);
                    resourceDescriptionResource.getDefaultSaveOptions().put("VERSION", BinaryResourceImpl.BinaryIO.Version.VERSION_1_1);
                    resourceDescriptionResource.getDefaultSaveOptions().put("INTERNAL_BUFFER_CAPACITY", 10000);
                    resourceDescriptionResource.getDefaultSaveOptions().put("DATA_CONVERTER", Boolean.TRUE);
                    resourceDescriptionResource.getDefaultSaveOptions().put("URI_HANDLER", uriHandler);
                    resourceDescriptionResource.getDefaultLoadOptions().put("BINARY", Boolean.TRUE);
                    resourceDescriptionResource.getDefaultLoadOptions().put("INTERNAL_BUFFER_CAPACITY", 10000);
                    resourceDescriptionResource.getDefaultLoadOptions().put("EAGER_PROXY_RESOLUTION", Boolean.TRUE);
                    resourceDescriptionResource.getDefaultLoadOptions().put("URI_HANDLER", uriHandler);
                    return resourceDescriptionResource;
                }
            };
        }
        return this.factory;
    }

    protected void scheduleRecoveryBuild() {
        ArrayList projects = Lists.newArrayList((Object[])this.workspace.getRoot().getProjects());
        this.buildManager.scheduleBuildIfNecessary(projects, IBuildFlag.RECOVERY_BUILD);
    }

    private static class NoOpURIHandler
    implements XMLResource.URIHandler {
        private NoOpURIHandler() {
        }

        public void setBaseURI(URI uri) {
        }

        public URI resolve(URI uri) {
            return uri;
        }

        public URI deresolve(URI uri) {
            return uri;
        }
    }

    private static class ResourceDescriptionResource
    extends XMIResourceImpl {
        public ResourceDescriptionResource(URI uri) {
            super(uri);
        }

        public void attached(EObject eObject) {
        }

        public void detached(EObject eObject) {
        }

        protected boolean useIDs() {
            return false;
        }
    }
}

