/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.id.CDOIDReference;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.common.util.CDOQueryInfo;
import org.eclipse.emf.cdo.internal.common.CDOQueryInfoImpl;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.server.InternalQueryManager;
import org.eclipse.emf.cdo.spi.server.InternalQueryResult;
import org.eclipse.emf.cdo.spi.server.InternalView;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class QueryIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, QueryIndication.class);
    private boolean xrefs;
    private boolean disableResponseFlushing;
    private InternalQueryResult queryResult;

    public QueryIndication(CDOServerProtocol protocol) {
        super(protocol, (short)17);
    }

    protected void indicating(CDODataInput in) throws IOException {
        int viewID = in.readInt();
        InternalView view = this.getView(viewID);
        CDOQueryInfoImpl queryInfo = new CDOQueryInfoImpl(in);
        this.xrefs = queryInfo.getQueryLanguage().equals("xrefs");
        Object param = queryInfo.getParameters().get("disable.response.flushing");
        this.disableResponseFlushing = this.xrefs || Boolean.TRUE.equals(param);
        InternalQueryManager queryManager = this.getRepository().getQueryManager();
        this.queryResult = queryManager.execute(view, (CDOQueryInfo)queryInfo);
    }

    /*
     * Unable to fully structure code
     */
    protected void responding(CDODataOutput out) throws IOException {
        out.writeInt(this.queryResult.getQueryID());
        this.flushUnlessDisabled();
        numberOfResults = 0;
        while (true) lbl-1000:
        // 4 sources

        {
            try {
                if (!this.queryResult.hasNext()) ** break;
                object = this.queryResult.next();
            }
            catch (Throwable ex) {
                object = ex;
            }
            out.writeBoolean(true);
            if (this.xrefs) {
                idReference = (CDOIDReference)object;
                out.writeCDOIDReference(idReference);
            } else {
                out.writeCDORevisionOrPrimitive(object);
                if (object instanceof Throwable) ** break;
            }
            ++numberOfResults;
            try {
                if (this.queryResult.peek() != null) ** GOTO lbl-1000
                this.flushUnlessDisabled();
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Throwable var4_7) {
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        if (QueryIndication.TRACER.isEnabled()) {
            QueryIndication.TRACER.trace("Query returned " + numberOfResults + " results");
        }
        out.writeBoolean(false);
    }

    private void flushUnlessDisabled() throws IOException {
        if (!this.disableResponseFlushing) {
            this.flush();
        }
    }
}

