/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserOptions;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.LabelDirectEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.NonResizableEditPolicyEx;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.gef.ui.internal.parts.TextCellEditorEx;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IAdvancedEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IDirectEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.configuration.IPopupEditorConfiguration;
import org.eclipse.papyrus.extensionpoints.editors.ui.ExtendedDirectEditionDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.ILabelEditorDialog;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.extensionpoints.editors.utils.DirectEditorsUtil;
import org.eclipse.papyrus.infra.emf.commands.CreateEAnnotationCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.PapyrusWrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ILabelFigure;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusNodeUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.sequence.Activator;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.InteractionOperandEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.UMLTextSelectionEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.locator.TextCellEditorLocator;
import org.eclipse.papyrus.uml.diagram.sequence.parsers.MessageFormatParser;
import org.eclipse.papyrus.uml.diagram.sequence.util.ElementIconUtil;
import org.eclipse.papyrus.uml.diagram.sequence.util.LoopOperatorUtil;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InteractionConstraint;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionOperatorKind;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public class InteractionOperandGuardEditPart
extends ShapeEditPart
implements ITextAwareEditPart {
    public static final String GUARD_TYPE = "InteractionOperand_Guard";
    private DirectEditManager manager;
    private IParser parser;
    private List<?> parserElements;
    private String defaultText;
    protected int directEditionMode = 0;
    protected IDirectEditorConfiguration configuration;

    public InteractionOperandGuardEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new LabelDirectEditPolicy());
        this.installEditPolicy("PrimaryDrag Policy", this.createPrimaryDragEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SemanticEditPolicy(){

            protected org.eclipse.gef.commands.Command getSemanticCommand(IEditCommandRequest request) {
                if (request instanceof DestroyElementRequest) {
                    return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
                }
                return super.getSemanticCommand(request);
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ComponentEditPolicy(){

            protected boolean shouldDeleteSemantic() {
                return false;
            }

            protected org.eclipse.gef.commands.Command createDeleteViewCommand(GroupRequest deleteRequest) {
                View source = ((InteractionOperandEditPart)InteractionOperandGuardEditPart.this.getParent()).getNotationView();
                CreateEAnnotationCommand command = new CreateEAnnotationCommand(InteractionOperandGuardEditPart.this.getEditingDomain(), (EModelElement)source, "guard.visibility"){

                    protected void doExecute() {
                        EAnnotation annotation = this.createEAnnotation();
                        this.replaceEannotation(annotation, this.getObject());
                        this.replaceEntry(annotation, "guard.visibility", Boolean.FALSE.toString());
                    }
                };
                return new EMFtoGEFCommandWrapper((Command)command);
            }
        });
    }

    protected EditPolicy createPrimaryDragEditPolicy() {
        return new NonResizableEditPolicyEx(){

            protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
                IFigure feedback = this.getDragSourceFeedbackFigure();
                PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
                this.getHostFigure().translateToAbsolute((Translatable)rect);
                Rectangle initialAbsBounds = rect.getCopy();
                rect.translate(request.getMoveDelta());
                rect.resize(request.getSizeDelta());
                IFigure f = this.getHostFigure();
                Dimension min = f.getMinimumSize().getCopy();
                Dimension max = f.getMaximumSize().getCopy();
                IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
                min.height = mmode.LPtoDP(min.height);
                min.width = mmode.LPtoDP(min.width);
                max.height = mmode.LPtoDP(max.height);
                max.width = mmode.LPtoDP(max.width);
                if (min.width > rect.width) {
                    rect.width = min.width;
                } else if (max.width < rect.width) {
                    rect.width = max.width;
                }
                if (min.height > rect.height) {
                    rect.height = min.height;
                } else if (max.height < rect.height) {
                    rect.height = max.height;
                }
                IFigure parentFigure = ((GraphicalEditPart)InteractionOperandGuardEditPart.this.getParent()).getFigure();
                Rectangle parentBounds = parentFigure.getBounds().getCopy();
                parentFigure.translateToAbsolute((Translatable)parentBounds);
                if (rect.x < parentBounds.x) {
                    rect.x = parentBounds.x;
                }
                if (rect.right() > parentBounds.right()) {
                    rect.x = parentBounds.right() - rect.width;
                }
                if (rect.y < parentBounds.y) {
                    rect.y = parentBounds.y;
                }
                if (rect.bottom() > parentBounds.bottom()) {
                    rect.y = parentBounds.bottom() - rect.height;
                }
                feedback.translateToRelative((Translatable)rect);
                feedback.setBounds(rect.getCopy());
                feedback.translateToAbsolute((Translatable)rect);
                request.setMoveDelta(new Point(rect.x - initialAbsBounds.x, rect.y - initialAbsBounds.y));
            }
        };
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getText();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getText();
        }
        return ((Label)figure).getText();
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setText(text);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setText(text);
        } else {
            ((Label)figure).setText(text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof WrappingLabel) {
            return ((WrappingLabel)figure).getIcon();
        }
        if (figure instanceof ILabelFigure) {
            return ((ILabelFigure)figure).getIcon();
        }
        return ((Label)figure).getIcon();
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof WrappingLabel) {
            ((WrappingLabel)figure).setIcon(icon);
        } else if (figure instanceof ILabelFigure) {
            ((ILabelFigure)figure).setIcon(icon);
        } else {
            ((Label)figure).setIcon(icon);
        }
    }

    public void setLabel(WrappingLabel figure) {
        this.unregisterVisuals();
        this.setFigure((IFigure)figure);
        this.defaultText = this.getLabelTextHelper((IFigure)figure);
        this.registerVisuals();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        return Collections.EMPTY_LIST;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        return null;
    }

    protected EObject getParserElement() {
        return InteractionOperandGuardEditPart.getInteractionOperand(this.resolveSemanticElement());
    }

    protected Image getLabelIcon() {
        return ElementIconUtil.getLabelIcon((org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)this.getParent());
    }

    protected String getLabelText() {
        String text = null;
        EObject parserElement = this.getParserElement();
        if (parserElement != null && this.getParser() != null) {
            text = this.getParser().getPrintString((IAdaptable)new EObjectAdapter(parserElement), this.getParserOptions().intValue());
        }
        if (text == null || text.length() == 0) {
            text = this.defaultText;
        }
        return text;
    }

    public void setLabelText(String text) {
        EditPolicy sfEditPolicy;
        this.setLabelTextHelper(this.getFigure(), text);
        EditPolicy pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy");
        if (pdEditPolicy instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
    }

    public String getEditText() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return "";
        }
        return this.getParser().getEditString((IAdaptable)new EObjectAdapter(this.getParserElement()), this.getParserOptions().intValue());
    }

    protected boolean isEditable() {
        return this.getParser() != null;
    }

    public ICellEditorValidator getEditTextValidator() {
        return new ICellEditorValidator(){

            public String isValid(final Object value) {
                if (value instanceof String) {
                    final EObject element = InteractionOperandGuardEditPart.this.getParserElement();
                    final IParser parser = InteractionOperandGuardEditPart.this.getParser();
                    try {
                        IParserEditStatus valid = (IParserEditStatus)InteractionOperandGuardEditPart.this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                            public void run() {
                                this.setResult(parser.isValidEditString((IAdaptable)new EObjectAdapter(element), (String)value));
                            }
                        });
                        return valid.getCode() == 0 ? null : valid.getMessage();
                    }
                    catch (InterruptedException ie) {
                        ie.printStackTrace();
                    }
                }
                return null;
            }
        };
    }

    public IContentAssistProcessor getCompletionProcessor() {
        if (this.getParserElement() == null || this.getParser() == null) {
            return null;
        }
        return this.getParser().getCompletionProcessor((IAdaptable)new EObjectAdapter(this.getParserElement()));
    }

    public ParserOptions getParserOptions() {
        return ParserOptions.NONE;
    }

    public IParser getParser() {
        if (this.parser == null) {
            this.parser = new GuardConditionParser();
        }
        return this.parser;
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            WrappingLabel primaryLabel = this.getPrimaryFigure().getPrimaryLabel();
            TextCellEditorLocator locator = new TextCellEditorLocator(primaryLabel);
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, TextCellEditorEx.class, (CellEditorLocator)locator));
        }
        return this.manager;
    }

    public GuardFigure getPrimaryFigure() {
        return (GuardFigure)this.getFigure();
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }

    protected void performDirectEdit() {
        this.getManager().show();
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(eventLocation.getSWTPoint());
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        if (this.getManager() instanceof TextDirectEditManager) {
            ((TextDirectEditManager)this.getManager()).show(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        final Request theRequest = request;
        if (this.directEditionMode == 0) {
            this.directEditionMode = this.getDirectEditionType();
        }
        switch (this.directEditionMode) {
            case 8: {
                return;
            }
            case 4: {
                this.updateExtendedEditorConfiguration();
                if (this.configuration == null || this.configuration.getLanguage() == null) {
                    this.performDefaultDirectEditorEdit(theRequest);
                    break;
                }
                this.configuration.preEditAction((Object)this.resolveSemanticElement());
                Dialog dialog = null;
                if (this.configuration instanceof IPopupEditorConfiguration) {
                    IPopupEditorHelper helper = ((IPopupEditorConfiguration)this.configuration).createPopupEditorHelper((Object)this);
                    helper.showEditor();
                    return;
                }
                if (this.configuration instanceof IAdvancedEditorConfiguration) {
                    dialog = ((IAdvancedEditorConfiguration)this.configuration).createDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()));
                } else if (this.configuration instanceof IDirectEditorConfiguration) {
                    dialog = new ExtendedDirectEditionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.resolveSemanticElement(), this.configuration.getTextToEdit((Object)this.resolveSemanticElement()), this.configuration);
                } else {
                    return;
                }
                final Dialog finalDialog = dialog;
                if (dialog.open() != 0) break;
                TransactionalEditingDomain domain = this.getEditingDomain();
                RecordingCommand command = new RecordingCommand(domain, "Edit Label"){

                    protected void doExecute() {
                        InteractionOperandGuardEditPart.this.configuration.postEditAction((Object)InteractionOperandGuardEditPart.this.resolveSemanticElement(), ((ILabelEditorDialog)finalDialog).getValue());
                    }
                };
                domain.getCommandStack().execute((Command)command);
                break;
            }
            case 2: {
                try {
                    this.getEditingDomain().runExclusive(new Runnable(){

                        @Override
                        public void run() {
                            if (InteractionOperandGuardEditPart.this.isActive() && InteractionOperandGuardEditPart.this.isEditable()) {
                                if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                                    Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                                    InteractionOperandGuardEditPart.this.performDirectEdit(initialChar.charValue());
                                } else if (theRequest instanceof DirectEditRequest && InteractionOperandGuardEditPart.this.getEditText().equals(InteractionOperandGuardEditPart.this.getLabelText())) {
                                    DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                                    InteractionOperandGuardEditPart.this.performDirectEdit(editRequest.getLocation());
                                } else {
                                    InteractionOperandGuardEditPart.this.performDirectEdit();
                                }
                            }
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshLabel();
        this.refreshFont();
        this.refreshFontColor();
        this.refreshUnderline();
        this.refreshStrikeThrough();
    }

    public void refreshBounds() {
        int width = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        Dimension size = new Dimension(width, height);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.figure, (Object)new Rectangle(loc, size));
    }

    protected void refreshLabel() {
        EditPolicy sfEditPolicy;
        EditPolicy pdEditPolicy;
        EditPolicy maskLabelPolicy = this.getEditPolicy("MaskManagedLabelPolicy");
        if (maskLabelPolicy == null) {
            this.setLabelTextHelper(this.getFigure(), this.getLabelText());
            this.setLabelIconHelper(this.getFigure(), this.getLabelIcon());
        }
        if ((pdEditPolicy = this.getEditPolicy("PrimaryDrag Policy")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)pdEditPolicy).refreshFeedback();
        }
        if ((sfEditPolicy = this.getEditPolicy("Selection Feedback")) instanceof UMLTextSelectionEditPolicy) {
            ((UMLTextSelectionEditPolicy)sfEditPolicy).refreshFeedback();
        }
        this.refreshBounds();
    }

    protected void refreshUnderline() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextUnderline(style.isUnderline());
        }
        if (this.resolveSemanticElement() instanceof Feature) {
            if (((Feature)this.resolveSemanticElement()).isStatic()) {
                ((WrappingLabel)this.getFigure()).setTextUnderline(true);
            } else {
                ((WrappingLabel)this.getFigure()).setTextUnderline(false);
            }
        }
    }

    protected void refreshStrikeThrough() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null && this.getFigure() instanceof WrappingLabel) {
            ((WrappingLabel)this.getFigure()).setTextStrikeThrough(style.isStrikeThrough());
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getFontStyleOwnerView().getStyle(NotationPackage.eINSTANCE.getFontStyle());
        if (style != null) {
            FontData fontData = new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0));
            this.setFont(fontData);
        }
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void addSemanticListeners() {
        if (this.getParser() instanceof ISemanticParser) {
            EObject element = this.resolveSemanticElement();
            this.parserElements = ((ISemanticParser)this.getParser()).getSemanticElementsBeingParsed(element);
            int i = 0;
            while (i < this.parserElements.size()) {
                this.addListenerFilter("SemanticModel" + i, (NotificationListener)this, (EObject)this.parserElements.get(i));
                ++i;
            }
        } else {
            super.addSemanticListeners();
        }
    }

    protected void removeSemanticListeners() {
        if (this.parserElements != null) {
            int i = 0;
            while (i < this.parserElements.size()) {
                this.removeListenerFilter("SemanticModel" + i);
                ++i;
            }
        } else {
            super.removeSemanticListeners();
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart((AbstractGraphicalEditPart)this){

                public void getName(AccessibleEvent e) {
                    e.result = InteractionOperandGuardEditPart.this.getLabelTextHelper(InteractionOperandGuardEditPart.this.getFigure());
                }
            };
        }
        return this.accessibleEP;
    }

    private View getFontStyleOwnerView() {
        return (View)this.getModel();
    }

    public int getDirectEditionType() {
        if (this.checkExtendedEditor()) {
            this.initExtendedEditorConfiguration();
            return 4;
        }
        if (this.checkDefaultEdition()) {
            return 2;
        }
        return 8;
    }

    protected boolean checkExtendedEditor() {
        if (this.resolveSemanticElement() != null) {
            return DirectEditorsUtil.hasSpecificEditorConfiguration((String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
        return false;
    }

    protected boolean checkDefaultEdition() {
        return this.getParser() != null;
    }

    protected void initExtendedEditorConfiguration() {
        if (this.configuration == null) {
            String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
            this.configuration = languagePreferred != null && !languagePreferred.equals("") ? DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName()) : DirectEditorsUtil.findEditorConfiguration((String)"Papyrus UML", (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        }
    }

    protected void updateExtendedEditorConfiguration() {
        String languagePreferred = Activator.getDefault().getPreferenceStore().getString("papyrus.directeditor." + this.resolveSemanticElement().eClass().getInstanceClassName());
        if (languagePreferred != null && !languagePreferred.equals("") && languagePreferred != this.configuration.getLanguage()) {
            this.configuration = DirectEditorsUtil.findEditorConfiguration((String)languagePreferred, (String)this.resolveSemanticElement().eClass().getInstanceClassName());
        } else if ("Simple Direct Editor".equals(languagePreferred)) {
            this.configuration = null;
        }
    }

    protected void performDefaultDirectEditorEdit(final Request theRequest) {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (InteractionOperandGuardEditPart.this.isActive() && InteractionOperandGuardEditPart.this.isEditable()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            InteractionOperandGuardEditPart.this.performDirectEdit(initialChar.charValue());
                        } else if (theRequest instanceof DirectEditRequest && InteractionOperandGuardEditPart.this.getEditText().equals(InteractionOperandGuardEditPart.this.getLabelText())) {
                            DirectEditRequest editRequest = (DirectEditRequest)theRequest;
                            InteractionOperandGuardEditPart.this.performDirectEdit(editRequest.getLocation());
                        } else {
                            InteractionOperandGuardEditPart.this.performDirectEdit();
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void handleNotificationEvent(Notification event) {
        Object feature = event.getFeature();
        if (NotationPackage.eINSTANCE.getFontStyle_FontColor().equals(feature)) {
            Integer c = (Integer)event.getNewValue();
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle_Underline().equals(feature)) {
            this.refreshUnderline();
        } else if (NotationPackage.eINSTANCE.getFontStyle_StrikeThrough().equals(feature)) {
            this.refreshStrikeThrough();
        } else if (NotationPackage.eINSTANCE.getFontStyle_FontHeight().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_FontName().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Bold().equals(feature) || NotationPackage.eINSTANCE.getFontStyle_Italic().equals(feature)) {
            this.refreshFont();
        } else if (ElementIconUtil.isIconNotification(event)) {
            this.refreshLabel();
        } else {
            this.refreshLabel();
        }
        super.handleNotificationEvent(event);
    }

    protected IFigure createFigure() {
        GuardFigure label = new GuardFigure();
        this.defaultText = this.getLabelTextHelper((IFigure)label);
        return label;
    }

    private static String getGuardLabelText(InteractionOperand interactionOperand, boolean edit) {
        String condition;
        ValueSpecification specification;
        if (interactionOperand == null) {
            return "";
        }
        Element owner = interactionOperand.getOwner();
        while (owner != null && !(owner instanceof CombinedFragment)) {
            owner = owner.getOwner();
        }
        CombinedFragment enclosingCF = (CombinedFragment)owner;
        if (enclosingCF == null) {
            return "";
        }
        InteractionOperatorKind cfOperator = enclosingCF.getInteractionOperator();
        InteractionConstraint guard = interactionOperand.getGuard();
        String specValue = null;
        if (guard != null && (specification = guard.getSpecification()) != null) {
            try {
                specValue = specification.stringValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder("");
        if (InteractionOperatorKind.LOOP_LITERAL.equals((Object)cfOperator) && (condition = LoopOperatorUtil.getLoopCondition(guard)) != null) {
            sb.append(condition);
        }
        if (specValue == null) {
            EList operands = enclosingCF.getOperands();
            if (InteractionOperatorKind.ALT_LITERAL.equals((Object)cfOperator) && interactionOperand.equals(operands.get(operands.size() - 1))) {
                specValue = "else";
            }
        }
        if (specValue != null) {
            if (!edit) {
                sb.append('[');
            }
            sb.append(specValue);
            if (!edit) {
                sb.append(']');
            }
        }
        String text = sb.toString();
        return text;
    }

    protected static InteractionOperand getInteractionOperand(Object element) {
        InteractionOperand operand = null;
        if (element instanceof InteractionConstraint) {
            EObject owner = ((InteractionConstraint)element).eContainer();
            if (owner instanceof InteractionOperand) {
                operand = (InteractionOperand)owner;
            }
        } else if (element instanceof InteractionOperand) {
            operand = (InteractionOperand)element;
        }
        return operand;
    }

    private static class GuardConditionParser
    extends MessageFormatParser
    implements ISemanticParser {
        public GuardConditionParser() {
            super(new EAttribute[]{UMLPackage.eINSTANCE.getLiteralInteger_Value(), UMLPackage.eINSTANCE.getLiteralString_Value()});
        }

        public List getSemanticElementsBeingParsed(EObject element) {
            ArrayList<Object> semanticElementsBeingParsed = new ArrayList<Object>();
            if (element instanceof InteractionOperand) {
                InteractionOperand op = (InteractionOperand)element;
                semanticElementsBeingParsed.add(op);
                semanticElementsBeingParsed.add(op.getGuard());
            }
            return semanticElementsBeingParsed;
        }

        public boolean areSemanticElementsAffected(EObject listener, Object notification) {
            EStructuralFeature feature = this.getEStructuralFeature(notification);
            return this.isValidFeature(feature);
        }

        public boolean isAffectingEvent(Object event, int flags) {
            EStructuralFeature feature = this.getEStructuralFeature(event);
            return this.isValidFeature(feature);
        }

        @Override
        public String getPrintString(IAdaptable element, int flags) {
            Object adapter = element.getAdapter(EObject.class);
            InteractionOperand operand = InteractionOperandGuardEditPart.getInteractionOperand(adapter);
            return InteractionOperandGuardEditPart.getGuardLabelText(operand, false);
        }

        @Override
        public IParserEditStatus isValidEditString(IAdaptable adapter, String editString) {
            return ParserEditStatus.EDITABLE_STATUS;
        }

        @Override
        public ICommand getParseCommand(IAdaptable adapter, String newString, int flags) {
            InteractionOperand element = InteractionOperandGuardEditPart.getInteractionOperand(adapter.getAdapter(EObject.class));
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)element);
            if (editingDomain == null || !(element instanceof InteractionOperand)) {
                return UnexecutableCommand.INSTANCE;
            }
            InteractionOperand interactionOperand = element;
            InteractionConstraint guard = interactionOperand.getGuard();
            CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, "Set Values");
            command.compose((IUndoableOperation)new UpdateGuardConditionCommand(editingDomain, interactionOperand, guard, newString));
            return command;
        }

        @Override
        public String getEditString(IAdaptable element, int flags) {
            InteractionOperand operand = InteractionOperandGuardEditPart.getInteractionOperand(element.getAdapter(Element.class));
            return InteractionOperandGuardEditPart.getGuardLabelText(operand, true);
        }

        protected EStructuralFeature getEStructuralFeature(Object notification) {
            Object feature;
            EStructuralFeature featureImpl = null;
            if (notification instanceof Notification && (feature = ((Notification)notification).getFeature()) instanceof EStructuralFeature) {
                featureImpl = (EStructuralFeature)feature;
            }
            return featureImpl;
        }

        private boolean isValidFeature(EStructuralFeature feature) {
            return UMLPackage.eINSTANCE.getInteractionConstraint_Maxint().equals(feature) || UMLPackage.eINSTANCE.getInteractionConstraint_Minint().equals(feature) || UMLPackage.eINSTANCE.getConstraint_Specification().equals(feature);
        }
    }

    public class GuardFigure
    extends Figure
    implements ILabelFigure,
    IPapyrusNodeUMLElementFigure {
        private WrappingLabel primaryLabel;
        private PapyrusWrappingLabel stereotypeLabel;
        private WrappingLabel stereotypePropertiesInBraceContent;

        public GuardFigure() {
            ToolbarLayout layout = new ToolbarLayout(false);
            layout.setStretchMinorAxis(true);
            this.setLayoutManager((LayoutManager)layout);
            this.primaryLabel = new WrappingLabel();
            this.primaryLabel.setTextWrap(true);
            this.primaryLabel.setAlignment(2);
            this.add((IFigure)this.primaryLabel);
        }

        public WrappingLabel getPrimaryLabel() {
            return this.primaryLabel;
        }

        public void setStereotypeDisplay(String stereotypes, Image image) {
            if ((stereotypes == null || stereotypes.trim().equals("")) && image == null) {
                if (this.stereotypeLabel != null) {
                    this.remove((IFigure)this.stereotypeLabel);
                }
                this.stereotypeLabel = null;
            } else {
                if (this.stereotypeLabel == null) {
                    this.stereotypeLabel = new PapyrusWrappingLabel();
                    this.add((IFigure)this.stereotypeLabel, 0);
                }
                this.stereotypeLabel.setText(stereotypes);
                this.stereotypeLabel.setIcon(image);
            }
        }

        public void setStereotypePropertiesInBrace(String stereotypeProperties) {
            if (stereotypeProperties == null || stereotypeProperties.trim().equals("")) {
                if (this.stereotypePropertiesInBraceContent != null) {
                    this.remove((IFigure)this.stereotypePropertiesInBraceContent);
                }
                this.stereotypePropertiesInBraceContent = null;
            } else {
                if (this.stereotypePropertiesInBraceContent == null) {
                    this.stereotypePropertiesInBraceContent = new WrappingLabel();
                    this.stereotypePropertiesInBraceContent.setOpaque(false);
                    int index = this.getChildren().indexOf(this.stereotypeLabel);
                    this.add((IFigure)this.stereotypePropertiesInBraceContent, index + 1);
                }
                this.stereotypePropertiesInBraceContent.setText("{" + stereotypeProperties + "}");
            }
        }

        public void setStereotypePropertiesInCompartment(String stereotypeProperties) {
        }

        public PapyrusWrappingLabel getStereotypesLabel() {
            return this.stereotypeLabel;
        }

        public void setText(String text) {
            this.primaryLabel.setText(text);
        }

        public String getText() {
            return this.primaryLabel.getText();
        }

        public void setIcon(Image icon) {
            this.primaryLabel.setIcon(icon);
        }

        public Image getIcon() {
            return this.primaryLabel.getIcon();
        }
    }

    private static class UpdateGuardConditionCommand
    extends AbstractTransactionalCommand {
        private InteractionConstraint guard;
        private String text;
        private InteractionOperand interactionOperand;

        public UpdateGuardConditionCommand(TransactionalEditingDomain domain, InteractionOperand interactionOperand, InteractionConstraint guard, String text) {
            super(domain, null, null);
            this.interactionOperand = interactionOperand;
            this.guard = guard;
            this.text = text;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            CombinedFragment enclosingCF = (CombinedFragment)this.interactionOperand.getOwner();
            InteractionOperatorKind cfOperator = enclosingCF.getInteractionOperator();
            if (InteractionOperatorKind.LOOP_LITERAL.equals((Object)cfOperator)) {
                if (this.text.contains("]") && this.text.contains("[")) {
                    String[] parts = this.text.split("]");
                    String[] nums = parts[0].replaceAll("\\[", "").split(",");
                    int min = 0;
                    int max = -1;
                    min = this.parseInt(nums[0], 0);
                    int n = max = nums.length > 1 ? this.parseInt(nums[1], -1) : min;
                    if (this.guard.getMinint() != null) {
                        this.setIntValue(this.guard.getMinint(), min);
                    } else {
                        this.guard.setMinint((ValueSpecification)this.createLiteralInteger(min));
                    }
                    if (this.guard.getMaxint() != null) {
                        this.setIntValue(this.guard.getMaxint(), max);
                    } else {
                        this.guard.setMaxint((ValueSpecification)this.createLiteralInteger(max));
                    }
                    this.text = parts.length > 1 ? (parts[1] == null ? "" : parts[1].trim()) : "";
                } else {
                    this.guard.setMinint(null);
                    this.guard.setMaxint(null);
                }
            }
            if (this.guard.getSpecification() != null || this.text.length() > 0) {
                LiteralString literalString = UMLFactory.eINSTANCE.createLiteralString();
                literalString.setValue(this.text);
                this.guard.setSpecification((ValueSpecification)literalString);
            }
            return CommandResult.newOKCommandResult();
        }

        private LiteralInteger createLiteralInteger(int val) {
            LiteralInteger li = UMLFactory.eINSTANCE.createLiteralInteger();
            li.setValue(val);
            return li;
        }

        private void setIntValue(ValueSpecification spec, int val) {
            if (spec instanceof LiteralInteger) {
                ((LiteralInteger)spec).setValue(val);
            }
        }

        private int parseInt(String string, int defaultInt) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return defaultInt;
            }
        }
    }
}

