/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLAbstractNavigatorItem;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorGroup;
import org.eclipse.papyrus.uml.diagram.sequence.navigator.UMLNavigatorItem;
import org.eclipse.papyrus.uml.diagram.sequence.part.Messages;
import org.eclipse.papyrus.uml.diagram.sequence.part.UMLVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class UMLNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public UMLNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        HashMap<Resource, Boolean> map = new HashMap<Resource, Boolean>(){

            @Override
            public Boolean get(Object key) {
                if (!this.containsKey(key) && key instanceof Resource) {
                    this.put((Resource)key, Boolean.TRUE);
                }
                return (Boolean)super.get(key);
            }
        };
        this.myEditingDomain.setResourceToReadOnlyMap((Map)map);
        this.myViewerRefreshRunnable = new Runnable(){

            @Override
            public void run() {
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : UMLNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (UMLNavigatorContentProvider.this.myViewer != null) {
                    UMLNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(UMLNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    private Object[] getViewChildrenForPackageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup links = new UMLNavigatorGroup(Messages.NavigatorGroupName_Package_SequenceDiagram_links, "icons/linksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        connectedViews = this.getDiagramLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("GeneralOrdering_Edge"));
        links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
        if (!links.isEmpty()) {
            result.add(links);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInteractionEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interaction_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Interaction_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("Lifeline_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("Constraint_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("Comment_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForLifelineEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Lifeline_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Lifeline_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForActionExecutionSpecificationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionExecutionSpecification_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ActionExecutionSpecification_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForBehaviorExecutionSpecificationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_BehaviorExecutionSpecification_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_BehaviorExecutionSpecification_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForStateInvariantEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_StateInvariant_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_StateInvariant_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCombinedFragment2EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_CoRegionShape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_CoRegionShape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForTimeConstraintEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeConstraint_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeConstraint_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationObservationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationObservation_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationObservation_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForTimeObservationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeObservation_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_TimeObservation_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationConstraintEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInteractionUseEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionUse_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionUse_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCombinedFragmentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_CombinedFragment_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_SubfragmentCompartment"));
        connectedViews = this.getChildrenByType(connectedViews, UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForInteractionOperandEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionOperand_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_InteractionOperand_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getChildrenByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForContinuationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Continuation_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Continuation_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDurationConstraintInMessageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_Shape_CN_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DurationConstraint_Shape_CN_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConsiderIgnoreFragmentEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConsiderIgnoreFragment_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_ConsiderIgnoreFragment_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessageEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_SynchEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_SynchEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_SynchEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_SynchEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage2EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_AsynchEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_AsynchEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_AsynchEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_AsynchEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage3EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_ReplyEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_ReplyEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_ReplyEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_ReplyEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage4EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_CreateEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_CreateEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_CreateEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_CreateEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage5EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_DeleteEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_DeleteEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_DeleteEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_DeleteEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage6EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_LostEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_LostEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_LostEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_LostEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForMessage7EditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_FoundEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_FoundEdge_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_FoundEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_Message_FoundEdge_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForCommentAnnotatedElementEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_AnnotatedElementEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Comment_AnnotatedElementEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForDestructionOccurrenceSpecificationEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup incominglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DestructionOccurrenceSpecification_Shape_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup outgoinglinks = new UMLNavigatorGroup(Messages.NavigatorGroupName_DestructionOccurrenceSpecification_Shape_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_SynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_AsynchEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_ReplyEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_CreateEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_DeleteEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_LostEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Message_FoundEdge"));
        outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_AnnotatedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        connectedViews = this.getIncomingLinksByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_ConstrainedElementEdge"));
        incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
        if (!incominglinks.isEmpty()) {
            result.add(incominglinks);
        }
        if (!outgoinglinks.isEmpty()) {
            result.add(outgoinglinks);
        }
        return result.toArray();
    }

    private Object[] getViewChildrenForConstraintConstrainedElementEditPart(View view, Object parentElement) {
        ArrayList<UMLNavigatorGroup> result = new ArrayList<UMLNavigatorGroup>();
        UMLNavigatorGroup target = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_ConstrainedElementEdge_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
        UMLNavigatorGroup source = new UMLNavigatorGroup(Messages.NavigatorGroupName_Constraint_ConstrainedElementEdge_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
        Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Interaction_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ConsiderIgnoreFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionOperand_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("InteractionUse_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Continuation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Lifeline_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("ActionExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("BehaviorExecutionSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("StateInvariant_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("CombinedFragment_CoRegionShape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DestructionOccurrenceSpecification_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Comment_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksTargetByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationObservation_Shape"));
        target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("TimeConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("Constraint_Shape"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        connectedViews = this.getLinksSourceByType(Collections.singleton(view), UMLVisualIDRegistry.getType("DurationConstraint_Shape_CN"));
        source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
        if (!target.isEmpty()) {
            result.add(target);
        }
        if (!source.isEmpty()) {
            result.add(source);
        }
        return result.toArray();
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    void unloadAllResources() {
        for (Resource nextResource : this.myEditingDomain.getResourceSet().getResources()) {
            nextResource.unload();
        }
    }

    void asyncRefresh() {
        if (this.myViewer != null && !this.myViewer.getControl().isDisposed()) {
            this.myViewer.getControl().getDisplay().asyncExec(this.myViewerRefreshRunnable);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            ArrayList<View> topViews = new ArrayList<View>(resource.getContents().size());
            for (EObject o : resource.getContents()) {
                if (!(o instanceof View)) continue;
                topViews.add((View)o);
            }
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "PapyrusUMLSequenceDiagram"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof UMLNavigatorGroup) {
            UMLNavigatorGroup group = (UMLNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof UMLNavigatorItem) {
            UMLNavigatorItem navigatorItem = (UMLNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        block91: {
            String vid = UMLVisualIDRegistry.getVisualID(view);
            if (vid == null) break block91;
            switch (vid) {
                case "Package_SequenceDiagram": {
                    return this.getViewChildrenForPackageEditPart(view, parentElement);
                }
                case "Interaction_Shape": {
                    return this.getViewChildrenForInteractionEditPart(view, parentElement);
                }
                case "Lifeline_Shape": {
                    return this.getViewChildrenForLifelineEditPart(view, parentElement);
                }
                case "InteractionUse_Shape": {
                    return this.getViewChildrenForInteractionUseEditPart(view, parentElement);
                }
                case "BehaviorExecutionSpecification_Shape": {
                    return this.getViewChildrenForBehaviorExecutionSpecificationEditPart(view, parentElement);
                }
                case "CombinedFragment_Shape": {
                    return this.getViewChildrenForCombinedFragmentEditPart(view, parentElement);
                }
                case "InteractionOperand_Shape": {
                    return this.getViewChildrenForInteractionOperandEditPart(view, parentElement);
                }
                case "ActionExecutionSpecification_Shape": {
                    return this.getViewChildrenForActionExecutionSpecificationEditPart(view, parentElement);
                }
                case "ConsiderIgnoreFragment_Shape": {
                    return this.getViewChildrenForConsiderIgnoreFragmentEditPart(view, parentElement);
                }
                case "Constraint_Shape": {
                    return this.getViewChildrenForConstraintEditPart(view, parentElement);
                }
                case "Comment_Shape": {
                    return this.getViewChildrenForCommentEditPart(view, parentElement);
                }
                case "Continuation_Shape": {
                    return this.getViewChildrenForContinuationEditPart(view, parentElement);
                }
                case "StateInvariant_Shape": {
                    return this.getViewChildrenForStateInvariantEditPart(view, parentElement);
                }
                case "CombinedFragment_CoRegionShape": {
                    return this.getViewChildrenForCombinedFragment2EditPart(view, parentElement);
                }
                case "TimeConstraint_Shape": {
                    return this.getViewChildrenForTimeConstraintEditPart(view, parentElement);
                }
                case "TimeObservation_Shape": {
                    return this.getViewChildrenForTimeObservationEditPart(view, parentElement);
                }
                case "DurationConstraint_Shape": {
                    return this.getViewChildrenForDurationConstraintEditPart(view, parentElement);
                }
                case "DestructionOccurrenceSpecification_Shape": {
                    return this.getViewChildrenForDestructionOccurrenceSpecificationEditPart(view, parentElement);
                }
                case "DurationConstraint_Shape_CN": {
                    return this.getViewChildrenForDurationConstraintInMessageEditPart(view, parentElement);
                }
                case "DurationObservation_Shape": {
                    return this.getViewChildrenForDurationObservationEditPart(view, parentElement);
                }
                case "Message_SynchEdge": {
                    return this.getViewChildrenForMessageEditPart(view, parentElement);
                }
                case "Message_AsynchEdge": {
                    return this.getViewChildrenForMessage2EditPart(view, parentElement);
                }
                case "Message_ReplyEdge": {
                    return this.getViewChildrenForMessage3EditPart(view, parentElement);
                }
                case "Message_CreateEdge": {
                    return this.getViewChildrenForMessage4EditPart(view, parentElement);
                }
                case "Message_DeleteEdge": {
                    return this.getViewChildrenForMessage5EditPart(view, parentElement);
                }
                case "Message_LostEdge": {
                    return this.getViewChildrenForMessage6EditPart(view, parentElement);
                }
                case "Message_FoundEdge": {
                    return this.getViewChildrenForMessage7EditPart(view, parentElement);
                }
                case "Comment_AnnotatedElementEdge": {
                    return this.getViewChildrenForCommentAnnotatedElementEditPart(view, parentElement);
                }
                case "Constraint_ConstrainedElementEdge": {
                    return this.getViewChildrenForConstraintConstrainedElementEditPart(view, parentElement);
                }
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, String type) {
        ArrayList result = new ArrayList();
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, String type) {
        ArrayList result = new ArrayList();
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "PapyrusUMLSequenceDiagram".equals(UMLVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<UMLNavigatorItem> result = new ArrayList<UMLNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new UMLNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof UMLAbstractNavigatorItem) {
            UMLAbstractNavigatorItem abstractNavigatorItem = (UMLAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

