/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.part;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.transaction.DawnDiagramEditingDomainFactory;
import org.eclipse.emf.cdo.dawn.ui.DawnEditorInput;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.util.DiagramIOUtil;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResourceFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.Messages;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDocumentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class DawnRefframeworkDocumentProvider
extends RefframeworkDocumentProvider {
    protected IDocument createEmptyDocument() {
        DiagramDocument document = new DiagramDocument();
        document.setEditingDomain(this.createEditingDomain());
        return document;
    }

    private TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain editingDomain = DawnDiagramEditingDomainFactory.getInstance().createEditingDomain();
        editingDomain.setID("org.eclipse.opencert.pkm.refframework.diagram.EditingDomain");
        final NotificationFilter diagramResourceModifiedFilter = NotificationFilter.createNotifierFilter((Object)editingDomain.getResourceSet()).and(NotificationFilter.createEventTypeFilter((int)3)).and(NotificationFilter.createFeatureFilter(ResourceSet.class, (int)0));
        editingDomain.getResourceSet().eAdapters().add((Object)new Adapter(){
            private Notifier myTarger;

            public Notifier getTarget() {
                return this.myTarger;
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }

            public void notifyChanged(Notification notification) {
                Object value;
                if (diagramResourceModifiedFilter.matches(notification) && (value = notification.getNewValue()) instanceof Resource) {
                    ((Resource)value).setTrackingModification(true);
                }
            }

            public void setTarget(Notifier newTarget) {
                this.myTarger = newTarget;
            }
        });
        return editingDomain;
    }

    protected void setDocumentContent(IDocument document, IEditorInput element) throws CoreException {
        IDiagramDocument diagramDocument = (IDiagramDocument)document;
        TransactionalEditingDomain domain = diagramDocument.getEditingDomain();
        if (!(element instanceof FileEditorInput)) {
            if (element instanceof URIEditorInput) {
                URIEditorInput editorInput = (URIEditorInput)element;
                URI uri = editorInput.getURI();
                Resource resource = null;
                try {
                    URI dawnURI = URI.createURI((String)uri.toString().replace("cdo", "dawn"));
                    resource = domain.getResourceSet().getResource(dawnURI, false);
                    if (resource == null) {
                        resource = domain.getResourceSet().getResource(dawnURI, true);
                    }
                    if (editorInput instanceof DawnEditorInput) {
                        ((DawnEditorInput)editorInput).setResource((CDOResource)resource);
                    }
                    if (!resource.isLoaded()) {
                        try {
                            HashMap options = new HashMap(GMFResourceFactory.getDefaultLoadOptions());
                            resource.load(options);
                        }
                        catch (IOException e) {
                            resource.unload();
                            throw e;
                        }
                    }
                    if (uri.fragment() != null) {
                        EObject rootElement = resource.getEObject(uri.fragment());
                        if (rootElement instanceof Diagram) {
                            Diagram diagram = (Diagram)rootElement;
                            DawnDiagramUpdater.initializeElement((Diagram)diagram);
                            document.setContent((Object)diagram);
                            return;
                        }
                    } else {
                        for (Object rootElement : resource.getContents()) {
                            if (!(rootElement instanceof Diagram)) continue;
                            Diagram diagram = (Diagram)rootElement;
                            DawnDiagramUpdater.initializeElement((Diagram)diagram);
                            document.setContent((Object)diagram);
                            return;
                        }
                    }
                    throw new RuntimeException(Messages.RefframeworkDocumentProvider_NoDiagramInResourceError);
                }
                catch (Exception e) {
                    String msg;
                    CoreException thrownExcp = null;
                    thrownExcp = e instanceof CoreException ? (CoreException)((Object)e) : new CoreException((IStatus)new Status(4, "org.eclipse.opencert.pkm.refframework.diagram", 0, (msg = e.getLocalizedMessage()) != null ? msg : Messages.RefframeworkDocumentProvider_DiagramLoadingError, (Throwable)e));
                    throw thrownExcp;
                }
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.opencert.pkm.refframework.diagram", 0, NLS.bind((String)Messages.RefframeworkDocumentProvider_IncorrectInputError, (Object[])new Object[]{element, "org.eclipse.ui.part.FileEditorInput", "org.eclipse.emf.common.ui.URIEditorInput"}), null));
        }
        IStorage storage = ((FileEditorInput)element).getStorage();
        Diagram diagram = DiagramIOUtil.load((TransactionalEditingDomain)domain, (IStorage)storage, (boolean)true, (IProgressMonitor)this.getProgressMonitor());
        document.setContent((Object)diagram);
    }

    public void changed(Object element) {
        if (element instanceof IEditorInput) {
            this.fireElementDirtyStateChanged(element, true);
        }
    }
}

