/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import java.util.Collection;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.tools.utils.PropertyUtil;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalUtil {
    public static String getCustomLabel(Signal signal, Collection<String> maskValues) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if (maskValues.contains("visibility")) {
            buffer.append(NamedElementUtil.getVisibilityAsSign((NamedElement)signal));
        }
        if (maskValues.contains("name")) {
            buffer.append(" ");
            buffer.append(signal.getName());
        }
        buffer.append("(");
        buffer.append(SignalUtil.getPropertiesAsString(signal, maskValues));
        buffer.append(")");
        return buffer.toString();
    }

    private static String getPropertiesAsString(Signal signal, Collection<String> maskValues) {
        StringBuffer propertiesString = new StringBuffer();
        boolean firstProperty = true;
        for (Property property : signal.getOwnedAttributes()) {
            String propertyString = PropertyUtil.getCustomLabel(property, maskValues);
            if (propertyString.trim().equals("")) continue;
            if (!firstProperty) {
                propertiesString.append(", ");
            }
            propertiesString.append(propertyString);
            firstProperty = false;
        }
        return propertiesString.toString();
    }
}

