/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.diagram.common.figure;

import java.util.ArrayList;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.papyrus.uml.diagram.common.draw2d.InteractionFigure;
import org.eclipse.papyrus.uml.diagram.common.draw2d.LeftToolbarLayout;
import org.eclipse.papyrus.uml.diagram.common.figure.node.AutomaticCompartmentLayoutManager;
import org.eclipse.papyrus.uml.diagram.common.figure.node.NodeNamedElementFigure;

public class SysMLDiagramFrameFigure
extends NodeNamedElementFigure {
    private WrappingLabel stereotypeLabel;
    private WrappingLabel frameLabel;
    private RectangleFigure frameLabelContainerFigure;
    private InteractionFigure interactionFigure;
    private int structureOffset;

    public SysMLDiagramFrameFigure() {
        this.createContents();
    }

    protected void createContents() {
        this.add((IFigure)this.createFigureHeader());
        this.setLayoutManager((LayoutManager)new SysMLLayoutLayoutManager());
    }

    protected RectangleFigure createFigureHeader() {
        if (this.stereotypeLabel == null) {
            this.stereotypeLabel = new WrappingLabel(){

                public Dimension getPreferredSize(int wHint, int hHint) {
                    Dimension preferredSize = super.getPreferredSize(wHint, hHint);
                    if (preferredSize.width == 0) {
                        return preferredSize;
                    }
                    return new Dimension(preferredSize.width + 2, preferredSize.height);
                }
            };
        }
        this.stereotypeLabel.setAlignment(0);
        if (this.frameLabel == null) {
            this.frameLabel = new WrappingLabel(){

                public Dimension getPreferredSize(int wHint, int hHint) {
                    Dimension preferredSize = super.getPreferredSize(wHint, hHint);
                    if (preferredSize.width == 0) {
                        return preferredSize;
                    }
                    return new Dimension(preferredSize.width + 9, preferredSize.height);
                }
            };
        }
        this.interactionFigure = new InteractionFigure();
        this.interactionFigure.setBorder((Border)new MarginBorder(3, 3, 6, 3));
        this.interactionFigure.setLayoutManager((LayoutManager)new LeftToolbarLayout());
        this.interactionFigure.add((IFigure)this.frameLabel);
        this.frameLabelContainerFigure = new RectangleFigure();
        this.frameLabelContainerFigure.setOutline(false);
        this.frameLabelContainerFigure.setFill(false);
        this.frameLabelContainerFigure.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        this.frameLabelContainerFigure.add((IFigure)this.interactionFigure, 0);
        return this.frameLabelContainerFigure;
    }

    public WrappingLabel getNameLabel() {
        if (this.frameLabel == null) {
            this.createFigureHeader();
        }
        return this.frameLabel;
    }

    public RectangleFigure getLabelContainer() {
        return this.frameLabelContainerFigure;
    }

    public void setStereotypeLabel(String stereotypeText) {
        this.interactionFigure.remove((IFigure)this.frameLabel);
        if (this.interactionFigure.getChildren().contains(this.stereotypeLabel)) {
            this.interactionFigure.remove((IFigure)this.stereotypeLabel);
        }
        if (stereotypeText != null && !stereotypeText.isEmpty()) {
            this.stereotypeLabel.setText(String.valueOf(String.valueOf("\u00ab")) + stereotypeText + String.valueOf("\u00bb"));
            this.interactionFigure.add((IFigure)this.stereotypeLabel);
            this.structureOffset = 41;
        } else {
            this.structureOffset = 26;
        }
        this.interactionFigure.add((IFigure)this.frameLabel);
    }

    private class SysMLLayoutLayoutManager
    extends AutomaticCompartmentLayoutManager {
        private SysMLLayoutLayoutManager() {
        }

        public void layout(IFigure container) {
            ArrayList<IFigure> figuresToRemove = new ArrayList<IFigure>();
            int i = 0;
            while (i < container.getChildren().size()) {
                IFigure currentCompartment = (IFigure)container.getChildren().get(i);
                if (currentCompartment instanceof ShapeCompartmentFigure) {
                    Rectangle bound = new Rectangle(currentCompartment.getBounds());
                    currentCompartment.invalidate();
                    Dimension pref = currentCompartment.getPreferredSize();
                    currentCompartment.invalidate();
                    Dimension prefConstraint = currentCompartment.getPreferredSize(container.getBounds().width - 40, -1);
                    if (pref.width < prefConstraint.width) {
                        bound.setSize(pref);
                    } else {
                        bound.setSize(prefConstraint);
                    }
                    bound.x = container.getBounds().x + 10;
                    bound.y = container.getBounds().y + SysMLDiagramFrameFigure.this.structureOffset;
                    bound.width = container.getBounds().width - 20;
                    bound.height = container.getBounds().height - SysMLDiagramFrameFigure.this.structureOffset - 10;
                    currentCompartment.setBounds(bound);
                } else if (currentCompartment == SysMLDiagramFrameFigure.this.frameLabelContainerFigure) {
                    Rectangle boundLabel = new Rectangle(SysMLDiagramFrameFigure.this.frameLabelContainerFigure.getBounds());
                    Dimension frameLabelDimension = SysMLDiagramFrameFigure.this.frameLabelContainerFigure.getPreferredSize();
                    boundLabel.setSize(frameLabelDimension);
                    SysMLDiagramFrameFigure.this.frameLabelContainerFigure.setBounds(boundLabel);
                } else {
                    figuresToRemove.add(currentCompartment);
                }
                ++i;
            }
            for (IFigure iFigure : figuresToRemove) {
                container.getChildren().remove(iFigure);
            }
        }
    }
}

