/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.importsources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.editors.IElementSelector;
import org.eclipse.papyrus.infra.widgets.editors.MultipleValueSelectorDialog;
import org.eclipse.papyrus.infra.widgets.selectors.ReferenceSelector;
import org.eclipse.papyrus.uml.extensionpoints.utils.Util;
import org.eclipse.papyrus.uml.tools.importsources.CompositePackageImportSource;
import org.eclipse.papyrus.uml.tools.importsources.IPackageImportSource;
import org.eclipse.papyrus.uml.tools.importsources.PackageImportSourceRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IEvaluationService;
import org.eclipse.ui.statushandlers.IStatusAdapterConstants;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class PackageImportSourceDialog
extends MultipleValueSelectorDialog {
    private IPackageImportSource source;
    private ResourceSet resourceSet;
    private List<Package> selectedPackages;
    protected Map<String, String> extensionFilters;

    public PackageImportSourceDialog(Shell parentShell, String title) {
        super(parentShell, (IElementSelector)new MyReferenceSelector(), title, true, true);
        this.setTitle(title);
    }

    public static Collection<Package> open(Shell parentShell, String title, IStructuredSelection selection) {
        return PackageImportSourceDialog.open(parentShell, title, selection.toList());
    }

    public static Collection<Package> open(Shell parentShell, String title, Collection<?> selection) {
        return PackageImportSourceDialog.open(parentShell, title, selection, null);
    }

    public static Collection<Package> open(Shell parentShell, String title, Collection<?> selection, Map<String, String> extensionFilters) {
        PackageImportSourceDialog dlg = new PackageImportSourceDialog(parentShell, title);
        dlg.setExtensionFilters(extensionFilters);
        dlg.initialize(selection);
        dlg.open();
        return dlg.getSelectedPackages();
    }

    protected void setExtensionFilters(Map<String, String> extensionFilters) {
        this.extensionFilters = extensionFilters;
    }

    public void initialize(Collection<?> selection) {
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        this.source = new PackageImportSourceRegistry(evaluationService).createImportSourceFor(selection);
        this.source.initialize(selection);
        MyReferenceSelector selector = (MyReferenceSelector)this.selector;
        ILabelProvider labelProvider = this.source.getModelHierarchyLabelProvider();
        selector.setLabelProvider(labelProvider);
        selector.setContentProvider(this.source.getModelHierarchyContentProvider(this.extensionFilters));
        selector.setImportSource(this.source);
        this.setLabelProvider(labelProvider);
        this.resourceSet = Util.createTemporaryResourceSet();
    }

    public Collection<Package> getSelectedPackages() {
        return this.selectedPackages;
    }

    public boolean close() {
        boolean result = super.close();
        if (result) {
            this.computePackages();
            this.dispose();
        }
        return result;
    }

    public void dispose() {
        if (this.source != null) {
            this.source.dispose();
            this.source = null;
        }
        if (this.resourceSet != null) {
            EMFHelper.unload((ResourceSet)this.resourceSet);
            this.resourceSet = null;
        }
    }

    private void computePackages() {
        Object[] dlgResult = this.getResult();
        if (dlgResult != null) {
            this.selectedPackages = new ArrayList<Package>(dlgResult.length);
            Object[] objectArray = dlgResult;
            int n = dlgResult.length;
            int n2 = 0;
            while (n2 < n) {
                Object selectedElement = objectArray[n2];
                try {
                    this.selectedPackages.addAll(this.source.getPackages(this.resourceSet, selectedElement));
                }
                catch (CoreException e) {
                    StatusAdapter adapter = new StatusAdapter(e.getStatus());
                    adapter.setProperty(IStatusAdapterConstants.TITLE_PROPERTY, (Object)"Invalid Model(s) Selected");
                    adapter.setProperty(IStatusAdapterConstants.EXPLANATION_PROPERTY, (Object)"One or more of the models selected could not provide packages to import.");
                    StatusManager.getManager().handle(adapter, 2);
                }
                ++n2;
            }
        }
    }

    private static class MyReferenceSelector
    extends ReferenceSelector {
        private IPackageImportSource source;

        private MyReferenceSelector() {
        }

        void setImportSource(IPackageImportSource source) {
            this.source = source;
        }

        public void createControls(Composite parent) {
            super.createControls(parent);
            if (this.source instanceof CompositePackageImportSource) {
                this.treeViewer.expandToLevel(2);
            }
        }
    }
}

