/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.managers;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.DynamicEObjectImpl;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Shape;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageList;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.polarsys.chess.core.notifications.ResourceNotification;
import org.polarsys.chess.core.resourcelistener.ResourceSetListenerExtra;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.NotificationManager;
import org.polarsys.chess.core.views.DiagramStatus;
import org.polarsys.chess.service.utils.CHESSEditorUtils;
import org.polarsys.chess.validator.managers.ModelManager;
import org.polarsys.chess.validator.managers.ModelParser;
import org.polarsys.chess.validator.managers.ViewManager;

public class ResourceListener
extends ResourceSetListenerExtra {
    private StringBuffer s = new StringBuffer();
    private ViewManager viewmgr = ViewManager.loadViewManager();
    private ModelManager automatedActionManager = ModelManager.loadModelManager();
    private ModelParser modelparser = new ModelParser();
    private static Class[] allowedNotifierTypes = new Class[]{Element.class, DynamicEObjectImpl.class, Diagram.class, PageList.class, Shape.class, EAnnotation.class, EObject.class};

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        List list = event.getNotifications();
        CompoundCommand command = new CompoundCommand();
        DiagramStatus ds = CHESSEditorUtils.getDiagramStatus((ServicesRegistry)this.sr);
        if (ds == null) {
            return command;
        }
        boolean executeModelParser = true;
        if (!ds.isUserAction()) {
            System.out.println("SUPER USER ACTIONS");
            executeModelParser = false;
        }
        int i = 0;
        for (Notification notif : list) {
            ++i;
            if (notif instanceof ENotificationImpl) {
                ENotificationImpl notification = (ENotificationImpl)notif;
                Object notifier = notification.getNotifier();
                if (this.isNotationElement(notifier)) continue;
                System.out.println("ACTION " + i + " OF " + list.size() + ": " + notif);
                System.out.println("TYPE: " + NotificationManager.printEventType((Notification)notification));
                System.out.println("NOTIFIER: " + notifier);
                System.out.println("FEATURE: " + notification.getFeature());
                if (notification.getEventType() == 4) {
                    System.out.println("OLDVALUE: " + notification.getOldValue());
                } else if (notification.getEventType() == 3) {
                    System.out.println("NEWVALUE: " + notification.getNewValue());
                } else {
                    System.out.println("OLDVALUE: " + notification.getOldValue());
                    System.out.println("NEWVALUE: " + notification.getNewValue());
                }
                System.out.println("SUPERUSER: " + !executeModelParser);
                if (!this.allowedNotifier(notifier)) continue;
                this.s.delete(0, this.s.length());
                this.s.append("R.");
                this.s.append(NotificationManager.printEventType((Notification)notification));
                try {
                    if (executeModelParser) {
                        this.modelparser.check((Notification)notification, notifier, ds.getCurrentView(), ds.isSuperuser());
                    }
                }
                catch (RollbackException e) {
                    ResourceNotification.showInfo((String)e.getStatus().getMessage());
                    throw e;
                }
                if (notifier instanceof Element || notifier instanceof DynamicEObjectImpl || this.canBeStaticStereotype(notifier)) {
                    try {
                        Command comm = this.automatedActionManager.check(list, (Notification)notification, notifier, this.s, ds, event.getEditingDomain());
                        if (comm == null) continue;
                        ds.setUserAction(false);
                        command.append(comm);
                        System.out.println("COMMAND: " + comm.getLabel());
                        System.out.println("SUPERUSER set to true");
                        continue;
                    }
                    catch (RollbackException e) {
                        this.s.delete(0, this.s.length());
                        this.s.append(e.getStatus().getMessage());
                        ResourceNotification.showInfo((String)e.getStatus().getMessage());
                        throw e;
                    }
                }
                if (notifier instanceof Shape) {
                    Shape shape = (Shape)notifier;
                    this.s.append(" shape modified: ");
                    this.s.append(" for the element: ");
                    this.s.append(shape.getElement());
                    if (shape.getElement() != null) {
                        this.s.append(" that belong to the view: ");
                        this.s.append(shape.getElement().eContainer());
                    }
                    if (shape.getDiagram() != null) {
                        this.s.append(" in the diagram: ");
                        this.s.append(shape.getDiagram().getName());
                        this.s.append(" in the view: ");
                        this.s.append(shape.getDiagram().getElement());
                    }
                    if (notification.getNewValue() instanceof EObject) continue;
                    continue;
                }
                if (notifier instanceof EAnnotation) {
                    EAnnotation annotation = (EAnnotation)notifier;
                    System.out.println("ANN: " + annotation);
                    EMap details = annotation.getDetails();
                    for (Map.Entry entry : details) {
                        if (((String)entry.getValue()).indexOf("DeploymentView") <= 0 && ((String)entry.getValue()).indexOf("ComponentView") <= 0 && ((String)entry.getValue()).indexOf("AnalysisView") <= 0 && ((String)entry.getValue()).indexOf("DependabilityAnalysisView") <= 0 && ((String)entry.getValue()).indexOf("RTAnalysisView") <= 0 && ((String)entry.getValue()).indexOf("TimingDataFlowView") <= 0) continue;
                        this.s.delete(0, this.s.length());
                        this.s.append("Can't apply view stereotype!");
                        CHESSProjectSupport.printlnToCHESSConsole((String)this.s.toString());
                        ResourceNotification.showError((String)this.s.toString());
                        throw new RollbackException((IStatus)new Status(4, "org.polarsys.chess.validator", this.s.toString()));
                    }
                    continue;
                }
                if (!(notifier instanceof PageList)) continue;
                try {
                    this.viewmgr.check(notification.getNewValue(), this.s, ds.getCurrentView(), event.getEditingDomain());
                    continue;
                }
                catch (RollbackException e) {
                    ResourceNotification.showInfo((String)e.getStatus().getMessage());
                    throw e;
                }
            }
            Object newz = notif.getNewValue();
            if (!(newz instanceof Diagram)) continue;
            try {
                this.viewmgr.check((Diagram)newz, this.s, ds.getCurrentView(), event.getEditingDomain());
            }
            catch (RollbackException e) {
                ResourceNotification.showInfo((String)e.getStatus().getMessage());
                throw e;
            }
        }
        return command.getCommandList().isEmpty() ? super.transactionAboutToCommit(event) : command;
    }

    private void printList(List<Notification> list) {
        System.out.println("----------------------------------");
        int j = 0;
        for (Notification notif1 : list) {
            ENotificationImpl notification;
            Object notifier;
            ++j;
            if (!(notif1 instanceof ENotificationImpl) || this.isNotationElement(notifier = (notification = (ENotificationImpl)notif1).getNotifier())) continue;
            System.out.println("ACTION " + j + " OF " + list.size());
            System.out.println("TYPE: " + NotificationManager.printEventType((Notification)notification));
            System.out.println("NOTIFIER: " + notifier);
            System.out.println("FEATURE: " + notification.getFeature());
            if (notification.getEventType() == 4) {
                System.out.println("OLDVALUE: " + notification.getOldValue());
                continue;
            }
            if (notification.getEventType() == 3) {
                System.out.println("NEWVALUE: " + notification.getNewValue());
                continue;
            }
            System.out.println("OLDVALUE: " + notification.getOldValue());
            System.out.println("NEWVALUE: " + notification.getNewValue());
        }
        System.out.println("----------------------------------");
    }

    private boolean isNotationElement(Object notifier) {
        String pkgName;
        return notifier instanceof EObject && (pkgName = notifier.getClass().getPackage().getName()).startsWith("org.eclipse.gmf.runtime.notation");
    }

    private boolean canBeStaticStereotype(Object notifier) {
        if (notifier instanceof EObject) {
            String pkgName = notifier.getClass().getPackage().getName();
            if (pkgName.startsWith("org.eclipse.papyrus.MARTE") || pkgName.startsWith("org.polarsys.chess.chessmlprofile")) {
                return true;
            }
            return !(notifier instanceof EAnnotation) && !(notifier instanceof Shape);
        }
        return false;
    }

    private boolean allowedNotifier(Object notifier) {
        Class[] classArray = allowedNotifierTypes;
        int n = allowedNotifierTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class allowedType = classArray[n2];
            if (allowedType.isInstance(notifier)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isInstanceSpecification(ENotificationImpl notif) {
        if (notif.getEventType() == 1) {
            Object notifer = notif.getNotifier();
            return notifer instanceof Element && this.isContainedInInstanceSpecification((Element)notifer);
        }
        if (notif.getEventType() == 4) {
            Object notifer = notif.getOldValue();
            return notifer instanceof Element && this.isContainedInInstanceSpecification((Element)notifer);
        }
        return false;
    }

    private boolean isContainedInInstanceSpecification(Element notifier) {
        if (notifier == null) {
            return false;
        }
        if (notifier instanceof InstanceSpecification) {
            return true;
        }
        EObject cont = notifier.eContainer();
        if (cont instanceof Element) {
            return this.isContainedInInstanceSpecification((Element)cont);
        }
        return false;
    }
}

