/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.core.internal.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.polarsys.chess.core.natures.CHESSNature;
import org.polarsys.chess.core.util.CHESSProjectSupport;

public class InternalCHESSProjectSupport {
    public static void addNature(IProject project) throws CoreException {
        if (!project.hasNature(CHESSNature.NATURE_ID)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = CHESSNature.NATURE_ID;
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
        }
    }

    public static IProject createBaseProject(String projectName, URI location) {
        IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!newProject.exists()) {
            URI projectLocation = location;
            IProjectDescription desc = newProject.getWorkspace().newProjectDescription(newProject.getName());
            if (location != null && ResourcesPlugin.getWorkspace().getRoot().getLocationURI().equals(location)) {
                projectLocation = null;
            }
            desc.setLocationURI(projectLocation);
            try {
                newProject.create(desc, null);
                if (!newProject.isOpen()) {
                    newProject.open(null);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return newProject;
    }

    private static void addToProjectStructure(IProject newProject, String[] paths) throws CoreException {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            IFolder etcFolder = newProject.getFolder(path);
            CHESSProjectSupport.createFolder(etcFolder);
            ++n2;
        }
    }

    public static IPath toPath(URI uri) {
        if (uri == null) {
            return null;
        }
        String scheme = uri.getScheme();
        if (scheme == null || "file".equals(scheme)) {
            return new Path(uri.getSchemeSpecificPart());
        }
        return null;
    }

    public static String getPluginInstallLocation(String pluginId) throws Exception {
        Bundle bundle = Platform.getBundle((String)pluginId);
        URL locationUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("/"), null);
        URL fileUrl = FileLocator.toFileURL((URL)locationUrl);
        return fileUrl.getFile();
    }

    public static String getNameWithoutExtension(IFile inputFile) {
        String inputName = inputFile.getName();
        int extensionIndex = inputName.lastIndexOf(46);
        if (extensionIndex != -1) {
            inputName = inputName.substring(0, extensionIndex);
        }
        return inputName;
    }

    public static void fileCopy(InputStream in, FileOutputStream out) throws IOException {
        int length;
        byte[] buf = new byte[8192];
        while ((length = in.read(buf)) >= 0) {
            out.write(buf, 0, length);
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        try {
            out.close();
        }
        catch (IOException iOException) {}
    }

    public static void getBundleContents(Plugin activator, String path, List<String> collectedPaths) {
        Enumeration enums = activator.getBundle().getEntryPaths(path);
        while (enums.hasMoreElements()) {
            Object object = enums.nextElement();
            Enumeration tmpEnum = activator.getBundle().getEntryPaths(object.toString());
            if (tmpEnum != null) {
                InternalCHESSProjectSupport.getBundleContents(activator, object.toString(), collectedPaths);
                continue;
            }
            collectedPaths.add(object.toString());
        }
    }

    public static IFile getIFileFromAbsolutePath(String path) {
        IPath location = Path.fromOSString((String)path);
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(location);
    }
}

