/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.handlers;

import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.AnomalyUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;

public class CloneAnomalyHandler
extends AbstractHandler {
    private static final String COMMAND_MESSAGE = "Cloning Anomaly...";

    public Object execute(final ExecutionEvent event) {
        final IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        final IEditorInput input = editorPart != null ? editorPart.getEditorInput() : null;
        Job job = new Job(COMMAND_MESSAGE){
            public String familyName;
            {
                super($anonymous0);
                this.familyName = R4EUIConstants.R4E_UI_JOB_FAMILY;
            }

            public boolean belongsTo(Object family) {
                return this.familyName.equals(family);
            }

            public IStatus run(IProgressMonitor monitor) {
                ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
                R4EUIModelController.setJobInProgress(true);
                if (selection instanceof ITextSelection) {
                    monitor.beginTask(CloneAnomalyHandler.COMMAND_MESSAGE, -1);
                    AnomalyUtils.addAnomalyFromText((ITextSelection)selection, input, true);
                } else if (selection instanceof ITreeSelection) {
                    if (editorPart != null && editorPart instanceof ITextEditor) {
                        ((ITextEditor)editorPart).getSelectionProvider().setSelection(null);
                    }
                    monitor.beginTask(CloneAnomalyHandler.COMMAND_MESSAGE, ((IStructuredSelection)selection).size());
                    Iterator iterator = ((ITreeSelection)selection).iterator();
                    while (iterator.hasNext()) {
                        AnomalyUtils.addAnomalyFromTree(iterator.next(), monitor, true);
                        if (!monitor.isCanceled()) continue;
                        R4EUIModelController.setJobInProgress(false);
                        return Status.CANCEL_STATUS;
                    }
                } else if ((selection == null || selection.isEmpty()) && editorPart != null && editorPart instanceof ITextEditor) {
                    IRegion region = ((ITextEditor)editorPart).getHighlightRange();
                    final TextSelection selectedText = new TextSelection(((ITextEditor)editorPart).getDocumentProvider().getDocument((Object)editorPart.getEditorInput()), region.getOffset(), region.getLength());
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            ((ITextEditor)editorPart).getSelectionProvider().setSelection((ISelection)selectedText);
                        }
                    });
                    AnomalyUtils.addAnomalyFromText((ITextSelection)selectedText, input, true);
                }
                R4EUIModelController.setJobInProgress(false);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
        return null;
    }
}

