/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.commands.testers;

import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class NewReviewItemPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Iterator iterator;
        R4EUIReviewBasic activeReview = R4EUIModelController.getActiveReview();
        if (activeReview == null) {
            return false;
        }
        if (activeReview.isReadOnly()) {
            return false;
        }
        R4EReviewPhase phase = ((R4EReviewState)activeReview.getReview().getState()).getState();
        if (phase.equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED)) {
            return false;
        }
        if (receiver instanceof AbstractSet && (iterator = ((AbstractSet)receiver).iterator()).next() instanceof TextSelection && !this.isR4EEditorInputAvailable()) {
            return false;
        }
        if (receiver instanceof AbstractList) {
            iterator = ((AbstractList)receiver).iterator();
            if (!iterator.hasNext()) {
                if (!this.isR4EEditorInputAvailable()) {
                    return false;
                }
            } else {
                Object obj = iterator.next();
                if ((R4EUIPlugin.isJDTAvailable() && obj instanceof org.eclipse.jdt.core.ISourceReference || R4EUIPlugin.isCDTAvailable() && obj instanceof ISourceReference) && !this.isR4EEditorInputAvailable()) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isR4EEditorInputAvailable() {
        IWorkbenchPage page;
        IEditorInput editorInput = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && page.getActiveEditor() != null) {
            editorInput = page.getActiveEditor().getEditorInput();
            if (editorInput instanceof R4EFileRevisionEditorInput) {
                if (((R4EFileRevisionEditorInput)editorInput).getFileVersion().getRepositoryPath() == null) {
                    return false;
                }
            } else if (editorInput instanceof R4ECompareEditorInput) {
                ITypedElement targetElement = ((R4ECompareEditorInput)editorInput).getLeftElement();
                if (targetElement == null) {
                    return false;
                }
                ITypedElement element = ((R4ECompareEditorInput)editorInput).getLeftElement();
                if (!(element instanceof R4EFileRevisionTypedElement) && !(element instanceof R4EFileTypedElement)) {
                    return false;
                }
            }
        }
        return true;
    }
}

