/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed;

import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhase;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewState;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.properties.tabbed.ModelElementTabPropertySection;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.UIUtils;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class CommentTabPropertySection
extends ModelElementTabPropertySection {
    private Text fAuthorText = null;
    private Text fCreationDateText = null;
    protected Text fDescriptionText = null;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory widgetFactory = aTabbedPropertySheetPage.getWidgetFactory();
        Composite composite = widgetFactory.createFlatFormComposite(parent);
        FormData data = null;
        widgetFactory.setBorderStyle(0);
        this.fAuthorText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        this.fAuthorText.setEditable(false);
        this.fAuthorText.setToolTipText("The Participant that Adds this Comment");
        this.fAuthorText.setLayoutData((Object)data);
        CLabel authorLabel = widgetFactory.createCLabel(composite, "Added By: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fAuthorText, -5);
        data.top = new FormAttachment((Control)this.fAuthorText, 0, 0x1000000);
        authorLabel.setToolTipText("The Participant that Adds this Comment");
        authorLabel.setLayoutData((Object)data);
        this.fCreationDateText = widgetFactory.createText(composite, "", 0);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fAuthorText, 4);
        this.fCreationDateText.setEditable(false);
        this.fCreationDateText.setToolTipText("The Creation Time of this Comment");
        this.fCreationDateText.setLayoutData((Object)data);
        CLabel creationDateLabel = widgetFactory.createCLabel(composite, "Creation Date: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fCreationDateText, -5);
        data.top = new FormAttachment((Control)this.fCreationDateText, 0, 0x1000000);
        creationDateLabel.setToolTipText("The Creation Time of this Comment");
        creationDateLabel.setLayoutData((Object)data);
        this.fDescriptionText = widgetFactory.createText(composite, "", 2);
        data = new FormData();
        data.left = new FormAttachment(0, 150);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.fCreationDateText, 4);
        this.fDescriptionText.setEditable(false);
        this.fDescriptionText.setToolTipText("The Comment Description");
        this.fDescriptionText.setLayoutData((Object)data);
        CLabel descriptionLabel = widgetFactory.createCLabel(composite, "Description: ");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.fDescriptionText, -5);
        data.top = new FormAttachment((Control)this.fDescriptionText, 0, 0x1000000);
        descriptionLabel.setToolTipText("The Comment Description");
        descriptionLabel.setLayoutData((Object)data);
        widgetFactory.setBorderStyle(2048);
    }

    public void refresh() {
        this.fRefreshInProgress = true;
        R4EComment modelComment = ((R4EUIComment)this.fProperties.getElement()).getComment();
        this.fAuthorText.setText(modelComment.getUser().getId());
        this.fCreationDateText.setText(modelComment.getCreatedOn().toString());
        this.fDescriptionText.setText(modelComment.getDescription());
        this.fDescriptionText.getParent().layout();
        this.setEnabledFields();
        this.fRefreshInProgress = false;
    }

    protected void setEnabledFields() {
        if (R4EUIModelController.isJobInProgress() || this.fProperties.getElement().isReadOnly() || R4EUIModelController.getActiveReview() == null || ((R4EReviewState)R4EUIModelController.getActiveReview().getReview().getState()).getState().equals((Object)R4EReviewPhase.R4E_REVIEW_PHASE_COMPLETED) || !this.fProperties.getElement().isEnabled()) {
            this.fAuthorText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fCreationDateText.setForeground(UIUtils.DISABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.DISABLED_FONT_COLOR);
        } else {
            this.fAuthorText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fCreationDateText.setForeground(UIUtils.ENABLED_FONT_COLOR);
            this.fDescriptionText.setForeground(UIUtils.ENABLED_FONT_COLOR);
        }
    }
}

