/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.ui.internal.utils;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.reviews.notifications.core.IMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EDelta;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileContext;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFileVersion;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EParticipant;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewComponent;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4ETextPosition;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUserRole;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.OutOfSyncException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.ui.R4EUIPlugin;
import org.eclipse.mylyn.reviews.r4e.ui.internal.dialogs.R4EUIDialogFactory;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4ECompareEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionEditorInput;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileRevisionTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.editors.R4EFileTypedElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.IR4EUIModelElement;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIAnomalyBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIComment;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIContent;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIFileContext;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIModelController;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIPostponedAnomaly;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewBasic;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUIReviewItem;
import org.eclipse.mylyn.reviews.r4e.ui.internal.model.R4EUITextPosition;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.CommandUtils;
import org.eclipse.mylyn.reviews.r4e.ui.internal.utils.R4EUIConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailServicesProxy {
    private static final String LINE_FEED_MSG_PART = R4EUIConstants.LINE_FEED;
    private static final String TAB_MSG_PART = "\t";
    private static final String SUBJECT_MSG_HEADER = " Review ";
    private static final String INTRO_MSG_BODY = "Hi,";
    private static final String OUTRO_MSG_BODY = "Best Regards,";
    private static final String ITEMS_READY_MSG_BODY = "The following Review Item(s) and Files are Ready for you to Review";
    private static final String MEETING_REQUEST_MSG_BODY = "This invitation is for the decision phase." + LINE_FEED_MSG_PART + "Please review the included items prior to the meeting.";
    private static final String ADDED_ELEMENTS_MSG_BODY = "The following Review Element(s) have been Added." + LINE_FEED_MSG_PART + "Please Refresh your Review if it is currently Open";
    private static final String REMOVED_ELEMENTS_MSG_BODY = "The following Element(s) have been Removed." + LINE_FEED_MSG_PART + "Please Refresh your Review if it is currently Open";
    private static final String PROGRESS_MESSAGE = "Progress Update: " + LINE_FEED_MSG_PART;
    private static final String COMPLETION_MESSAGE = "I have Completed this Review, see Details below: " + LINE_FEED_MSG_PART;
    private static final String QUESTION_MSG_BODY = "I have a Question concerning the Following Elements: " + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART;
    private static final Integer DEFAULT_MEETING_DURATION = new Integer(60);

    public static void sendItemsReadyNotification() throws CoreException, ResourceHandlingException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            String[] messageDestinations = MailServicesProxy.createItemsUpdatedDestinations();
            String messageSubject = String.valueOf(MailServicesProxy.createSubject()) + " - Items Ready for Review";
            String messageBody = MailServicesProxy.createItemsReadyNotificationMessage(false);
            MailServicesProxy.sendMessage(messageDestinations, messageSubject, messageBody);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static void sendItemsAddedNotification(List<R4EReviewComponent> aAddedElements) throws CoreException, ResourceHandlingException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            String[] messageDestinations = MailServicesProxy.createItemsUpdatedDestinations();
            String messageSubject = String.valueOf(MailServicesProxy.createSubject()) + " - Items Added for Review";
            String messageBody = MailServicesProxy.createUpdatedItemsNotificationMessage(aAddedElements, true);
            MailServicesProxy.sendMessage(messageDestinations, messageSubject, messageBody);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static void sendItemsRemovedNotification(List<R4EReviewComponent> aRemovedElements) throws CoreException, ResourceHandlingException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            String[] messageDestinations = MailServicesProxy.createItemsUpdatedDestinations();
            String messageSubject = String.valueOf(MailServicesProxy.createSubject()) + " - Items Removed from Review";
            String messageBody = MailServicesProxy.createUpdatedItemsNotificationMessage(aRemovedElements, false);
            MailServicesProxy.sendMessage(messageDestinations, messageSubject, messageBody);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static void sendProgressNotification() throws CoreException, ResourceHandlingException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            String[] messageDestinations = MailServicesProxy.createProgressDestinations();
            String messageSubject = String.valueOf(MailServicesProxy.createSubject()) + " - Participant Progress";
            String messageBody = MailServicesProxy.createProgressNotification(PROGRESS_MESSAGE);
            MailServicesProxy.sendMessage(messageDestinations, messageSubject, messageBody);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static void sendCompletionNotification() throws CoreException, ResourceHandlingException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            String[] messageDestinations = MailServicesProxy.createProgressDestinations();
            String messageSubject = String.valueOf(MailServicesProxy.createSubject()) + " - Participant Progress (Completed)";
            String messageBody = MailServicesProxy.createProgressNotification(COMPLETION_MESSAGE);
            MailServicesProxy.sendMessage(messageDestinations, messageSubject, messageBody);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static void sendQuestion(ISelection aSource) throws CoreException, ResourceHandlingException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            String[] messageDestinations = null;
            messageDestinations = MailServicesProxy.createQuestionDestinations();
            String messageSubject = String.valueOf(MailServicesProxy.createSubject()) + " - Question regarding review ";
            String messageBody = MailServicesProxy.createQuestionMessage(aSource);
            MailServicesProxy.sendMessage(messageDestinations, messageSubject, messageBody);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static void sendMessage(String[] aDestinations, String aSubject, String aBody) throws CoreException, ResourceHandlingException {
        R4EParticipant user = R4EUIModelController.getActiveReview().getParticipant(R4EUIModelController.getReviewer(), false);
        String originatorEmail = null;
        if (user != null) {
            originatorEmail = user.getEmail();
        } else {
            IPreferenceStore store = R4EUIPlugin.getDefault().getPreferenceStore();
            originatorEmail = store.getString("userEmailPreference");
        }
        R4EUIDialogFactory.getInstance().getMailConnector().sendEmailGraphical(originatorEmail, aDestinations, aSubject, aBody, null, null);
    }

    private static String createSubject() {
        StringBuilder subject = new StringBuilder();
        subject.append("[r4e-mail] ");
        subject.append(SUBJECT_MSG_HEADER);
        subject.append(R4EUIModelController.getActiveReview().getName());
        return subject.toString();
    }

    private static boolean isEmailValid(R4EParticipant aParticipant) {
        String emailStr;
        return aParticipant.isEnabled() && !R4EUIModelController.getReviewer().equals(aParticipant.getId()) && (emailStr = aParticipant.getEmail()) != null && !"".equals(emailStr);
    }

    private static String[] createItemsUpdatedDestinations() {
        ArrayList<String> destinations = new ArrayList<String>();
        List<R4EParticipant> participants = R4EUIModelController.getActiveReview().getParticipants();
        for (R4EParticipant participant : participants) {
            if (!MailServicesProxy.isEmailValid(participant)) continue;
            destinations.add(participant.getEmail());
        }
        return destinations.toArray(new String[destinations.size()]);
    }

    private static String[] createProgressDestinations() {
        ArrayList<String> destinations = new ArrayList<String>();
        List<R4EParticipant> participants = R4EUIModelController.getActiveReview().getParticipants();
        for (R4EParticipant participant : participants) {
            if (!MailServicesProxy.isEmailValid(participant)) continue;
            if (!R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                destinations.add(participant.getEmail());
                continue;
            }
            if (!participant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_LEAD) && !participant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_ORGANIZER) && !participant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_AUTHOR)) continue;
            destinations.add(participant.getEmail());
        }
        return destinations.toArray(new String[destinations.size()]);
    }

    private static String[] createQuestionDestinations() {
        ArrayList<String> destinations = new ArrayList<String>();
        List<R4EParticipant> participants = R4EUIModelController.getActiveReview().getParticipants();
        for (R4EParticipant participant : participants) {
            if (!MailServicesProxy.isEmailValid(participant)) continue;
            if (!R4EUIModelController.getActiveReview().getReview().getType().equals((Object)R4EReviewType.R4E_REVIEW_TYPE_FORMAL)) {
                destinations.add(participant.getEmail());
                continue;
            }
            if (!participant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_LEAD) && !participant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_ORGANIZER) && !participant.getRoles().contains((Object)R4EUserRole.R4E_ROLE_AUTHOR)) continue;
            destinations.add(participant.getEmail());
        }
        return destinations.toArray(new String[destinations.size()]);
    }

    private static String createItemsReadyNotificationMessage(boolean aMeetingRequestIncluded) {
        StringBuilder msgBody = new StringBuilder();
        msgBody.append(MailServicesProxy.createIntroPart());
        if (aMeetingRequestIncluded) {
            msgBody.append(String.valueOf(MEETING_REQUEST_MSG_BODY) + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
        } else {
            msgBody.append(ITEMS_READY_MSG_BODY + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
        }
        List<R4EUIReviewItem> items = R4EUIModelController.getActiveReview().getReviewItems();
        for (R4EUIReviewItem item : items) {
            R4EUIFileContext[] contexts;
            if (!item.isEnabled()) continue;
            if (item.getItem().getDescription() != null) {
                msgBody.append("Review Item -> " + item.getItem().getDescription() + LINE_FEED_MSG_PART);
            } else {
                msgBody.append("Review Item -> " + item.getChildren()[0].getName() + " (Resource)" + LINE_FEED_MSG_PART);
            }
            msgBody.append("Eclipse Project: File Path (Repository | Project)[: Line range]" + LINE_FEED_MSG_PART);
            R4EUIFileContext[] r4EUIFileContextArray = contexts = (R4EUIFileContext[])item.getChildren();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                R4EUIFileContext context = r4EUIFileContextArray[n2];
                R4EFileVersion fileVersion = context.getTargetFileVersion();
                if (fileVersion == null) {
                    fileVersion = context.getBaseFileVersion();
                }
                if (context.isEnabled() && fileVersion != null) {
                    String path;
                    IResource resource = fileVersion.getResource();
                    msgBody.append(TAB_MSG_PART);
                    if (resource != null) {
                        msgBody.append(resource.getProject());
                    }
                    if ((path = fileVersion.getRepositoryPath()) != null && !path.equals("")) {
                        msgBody.append(": " + path + " (Repository)");
                    } else if (resource != null) {
                        msgBody.append(": " + resource.getProjectRelativePath() + " (Project)");
                    }
                    R4EUIContent[] contents = (R4EUIContent[])context.getContentsContainerElement().getChildren();
                    msgBody.append(": ");
                    R4EUIContent[] r4EUIContentArray = contents;
                    int n3 = contents.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        R4EUIContent content = r4EUIContentArray[n4];
                        msgBody.append(String.valueOf(content.getPosition().toString()) + ", ");
                        ++n4;
                    }
                    msgBody.append(LINE_FEED_MSG_PART);
                }
                ++n2;
            }
            msgBody.append(LINE_FEED_MSG_PART);
        }
        msgBody.append(MailServicesProxy.createReviewInfoPart());
        msgBody.append(MailServicesProxy.createOutroPart());
        return msgBody.toString();
    }

    private static String createUpdatedItemsNotificationMessage(List<R4EReviewComponent> aElements, boolean aIsAdded) {
        StringBuilder msgBody = new StringBuilder();
        msgBody.append(MailServicesProxy.createIntroPart());
        if (aIsAdded) {
            msgBody.append(String.valueOf(ADDED_ELEMENTS_MSG_BODY) + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
        } else {
            msgBody.append(String.valueOf(REMOVED_ELEMENTS_MSG_BODY) + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
        }
        boolean legendAppended = false;
        for (R4EReviewComponent component : aElements) {
            if (component instanceof R4EItem) {
                if (((R4EItem)component).getDescription() != null) {
                    msgBody.append("Review Item -> " + ((R4EItem)component).getDescription() + LINE_FEED_MSG_PART);
                }
                msgBody.append("Eclipse Project: File Path (Repository | Project)[: Line range]" + LINE_FEED_MSG_PART);
                EList contexts = ((R4EItem)component).getFileContextList();
                for (R4EFileContext context : contexts) {
                    R4EFileVersion fileVersion = context.getTarget();
                    if (fileVersion != null) {
                        String path;
                        IResource resource = fileVersion.getResource();
                        msgBody.append(TAB_MSG_PART);
                        if (resource != null) {
                            msgBody.append(resource.getProject());
                        }
                        if ((path = fileVersion.getRepositoryPath()) != null && !path.equals("")) {
                            msgBody.append(": " + path + " (Repository)");
                        } else if (resource != null) {
                            msgBody.append(": " + resource.getProjectRelativePath() + " (Project)");
                        }
                        if (context.getDeltas().size() > 0) {
                            msgBody.append(": ");
                            EList deltas = context.getDeltas();
                            for (R4EDelta delta : deltas) {
                                msgBody.append(String.valueOf(MailServicesProxy.buildLineTag(delta)) + ", ");
                            }
                        }
                    }
                    msgBody.append(LINE_FEED_MSG_PART);
                }
                msgBody.append(LINE_FEED_MSG_PART);
            } else if (component instanceof R4EDelta) {
                R4EFileContext context;
                R4EFileVersion fileVersion;
                if (!legendAppended) {
                    msgBody.append("Eclipse Project: File Path (Repository | Project)[: Line range]" + LINE_FEED_MSG_PART);
                    legendAppended = true;
                }
                if ((fileVersion = (context = (R4EFileContext)((R4EDelta)component).eContainer()).getTarget()) != null) {
                    String path;
                    IResource resource = fileVersion.getResource();
                    msgBody.append(TAB_MSG_PART);
                    if (resource != null) {
                        msgBody.append(resource.getProject());
                    }
                    if ((path = fileVersion.getRepositoryPath()) != null && !path.equals("")) {
                        msgBody.append(": " + path + " (Repository)");
                    } else if (resource != null) {
                        msgBody.append(": " + resource.getProjectRelativePath() + " (Project)");
                    }
                    msgBody.append(": " + MailServicesProxy.buildLineTag((R4EDelta)component) + ", ");
                }
            }
            msgBody.append(LINE_FEED_MSG_PART);
        }
        msgBody.append(MailServicesProxy.createReviewInfoPart());
        msgBody.append(MailServicesProxy.createOutroPart());
        return msgBody.toString();
    }

    private static String createProgressNotification(String aHeader) {
        R4EUIAnomalyBasic[] globalAnomalies;
        StringBuilder msgBody = new StringBuilder();
        msgBody.append(MailServicesProxy.createIntroPart());
        msgBody.append(String.valueOf(aHeader) + LINE_FEED_MSG_PART);
        int numReviewedFiles = 0;
        int numTotalFiles = 0;
        int numTotalAnomalies = 0;
        List<R4EUIReviewItem> items = R4EUIModelController.getActiveReview().getReviewItems();
        for (R4EUIReviewItem item : items) {
            R4EUIFileContext[] contexts;
            R4EUIFileContext[] r4EUIFileContextArray = contexts = (R4EUIFileContext[])item.getChildren();
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                R4EUIAnomalyBasic[] anomalies;
                R4EUIFileContext context = r4EUIFileContextArray[n2];
                if (context.isUserReviewed()) {
                    ++numReviewedFiles;
                }
                ++numTotalFiles;
                R4EUIAnomalyBasic[] r4EUIAnomalyBasicArray = anomalies = (R4EUIAnomalyBasic[])context.getAnomalyContainerElement().getChildren();
                int n3 = anomalies.length;
                int n4 = 0;
                while (n4 < n3) {
                    R4EUIAnomalyBasic anomaly = r4EUIAnomalyBasicArray[n4];
                    if (anomaly.getAnomaly().getUser().getId().equals(R4EUIModelController.getReviewer())) {
                        ++numTotalAnomalies;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        R4EUIAnomalyBasic[] r4EUIAnomalyBasicArray = globalAnomalies = (R4EUIAnomalyBasic[])R4EUIModelController.getActiveReview().getAnomalyContainer().getChildren();
        int context = globalAnomalies.length;
        int n = 0;
        while (n < context) {
            R4EUIAnomalyBasic anomaly = r4EUIAnomalyBasicArray[n];
            if (anomaly.getAnomaly().getUser().getId().equals(R4EUIModelController.getReviewer())) {
                ++numTotalAnomalies;
            }
            ++n;
        }
        msgBody.append("Files Reviewed: " + numReviewedFiles + TAB_MSG_PART);
        msgBody.append("Files Total: " + numTotalFiles + TAB_MSG_PART);
        double progress = (double)numReviewedFiles / new Integer(numTotalFiles).doubleValue() * 100.0;
        DecimalFormat fmt = new DecimalFormat("#");
        msgBody.append("Progress: " + fmt.format(progress) + "%");
        msgBody.append(LINE_FEED_MSG_PART);
        msgBody.append("Anomalies Created by: " + R4EUIModelController.getReviewer() + LINE_FEED_MSG_PART);
        msgBody.append("Count: " + numTotalAnomalies + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
        for (R4EUIReviewItem item : items) {
            R4EUIFileContext[] contexts = (R4EUIFileContext[])item.getChildren();
            int i = 0;
            while (i < contexts.length) {
                R4EUIFileContext context2 = contexts[i];
                if (i == 0) {
                    msgBody.append("FileContext: \tEclipse Project: File Path (Repository | Project)" + LINE_FEED_MSG_PART);
                }
                if (context2.getAnomalyContainerElement() != null) {
                    R4EUIAnomalyBasic[] anomalies = (R4EUIAnomalyBasic[])context2.getAnomalyContainerElement().getChildren();
                    R4EFileVersion fileVersion = context2.getTargetFileVersion();
                    if (fileVersion == null) {
                        fileVersion = context2.getBaseFileVersion();
                    }
                    if (context2.isEnabled() && fileVersion != null) {
                        String path;
                        IResource resource = fileVersion.getResource();
                        msgBody.append(TAB_MSG_PART);
                        if (resource != null) {
                            msgBody.append(resource.getProject());
                        }
                        if ((path = fileVersion.getRepositoryPath()) != null && !path.equals("")) {
                            msgBody.append(": " + path + " (Repository)");
                        } else if (resource != null) {
                            msgBody.append(": " + resource.getProjectRelativePath() + " (Project)");
                        }
                        msgBody.append(LINE_FEED_MSG_PART);
                    }
                    int j = 0;
                    while (j < anomalies.length) {
                        R4EUIAnomalyBasic anomaly = anomalies[j];
                        if (j == 0) {
                            msgBody.append("\tAnomaly: Line Range: Title: Description" + LINE_FEED_MSG_PART);
                        }
                        if (anomaly.getAnomaly().getUser().getId().equals(R4EUIModelController.getReviewer())) {
                            R4EUIComment[] comments;
                            msgBody.append("\t\t   " + anomaly.getPosition().toString() + ": " + anomaly.getAnomaly().getTitle() + ": " + anomaly.getAnomaly().getDescription() + LINE_FEED_MSG_PART);
                            R4EUIComment[] r4EUICommentArray = comments = (R4EUIComment[])anomaly.getChildren();
                            int n5 = comments.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                R4EUIComment comment = r4EUICommentArray[n6];
                                msgBody.append("\t\t\tComment: " + comment.getComment().getDescription() + LINE_FEED_MSG_PART);
                                ++n6;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        msgBody.append(LINE_FEED_MSG_PART);
        if (globalAnomalies.length > 0) {
            msgBody.append("Global Anomalies: " + LINE_FEED_MSG_PART);
        }
        R4EUIAnomalyBasic[] r4EUIAnomalyBasicArray2 = globalAnomalies;
        int n7 = globalAnomalies.length;
        int n8 = 0;
        while (n8 < n7) {
            R4EUIAnomalyBasic globalAnomaly = r4EUIAnomalyBasicArray2[n8];
            if (globalAnomaly.getAnomaly().getUser().getId().equals(R4EUIModelController.getReviewer())) {
                R4EUIComment[] globalComments;
                msgBody.append(String.valueOf(globalAnomaly.getAnomaly().getTitle()) + ": " + globalAnomaly.getAnomaly().getDescription() + LINE_FEED_MSG_PART);
                R4EUIComment[] r4EUICommentArray = globalComments = (R4EUIComment[])globalAnomaly.getChildren();
                int n9 = globalComments.length;
                int n10 = 0;
                while (n10 < n9) {
                    R4EUIComment globalComment = r4EUICommentArray[n10];
                    msgBody.append("\tComment: " + globalComment.getComment().getDescription() + LINE_FEED_MSG_PART);
                    ++n10;
                }
            }
            ++n8;
        }
        msgBody.append(MailServicesProxy.createReviewInfoPart());
        msgBody.append(MailServicesProxy.createOutroPart());
        return msgBody.toString();
    }

    private static String createQuestionMessage(ISelection aSource) throws CoreException {
        StringBuilder msgBody = new StringBuilder();
        msgBody.append(MailServicesProxy.createIntroPart());
        msgBody.append(QUESTION_MSG_BODY);
        if (aSource instanceof ITextSelection) {
            MailServicesProxy.addElementInfo(msgBody, aSource);
        } else if (aSource instanceof IStructuredSelection) {
            Iterator iterator = ((IStructuredSelection)aSource).iterator();
            while (iterator.hasNext()) {
                MailServicesProxy.addElementInfo(msgBody, iterator.next());
                msgBody.append(LINE_FEED_MSG_PART);
            }
        }
        msgBody.append(LINE_FEED_MSG_PART);
        msgBody.append(MailServicesProxy.createReviewInfoPart());
        msgBody.append(MailServicesProxy.createOutroPart());
        return msgBody.toString();
    }

    private static void addElementInfo(StringBuilder aMsgBody, Object aSource) throws CoreException {
        if (aSource instanceof R4EUIPostponedAnomaly) {
            R4EFileVersion file = ((R4EUIFileContext)((R4EUIPostponedAnomaly)aSource).getParent()).getTargetFileVersion();
            if (file == null) {
                file = ((R4EUIFileContext)((R4EUIPostponedAnomaly)aSource).getParent()).getBaseFileVersion();
            }
            if (file != null) {
                String path = file.getRepositoryPath();
                if (path != null && !path.equals("")) {
                    aMsgBody.append("Postponed File Path (Repository): " + path + LINE_FEED_MSG_PART);
                } else if (file.getResource() != null) {
                    aMsgBody.append("Postponed File Path (Project): " + file.getResource().getProject() + "/" + file.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                }
                aMsgBody.append("Postponed File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
            } else {
                aMsgBody.append("Postponed File (Local): " + ((R4EUIFileContext)((R4EUIPostponedAnomaly)aSource).getParent()).getName() + LINE_FEED_MSG_PART);
            }
            aMsgBody.append("Postponed Anomaly Line(s): " + ((R4EUIPostponedAnomaly)aSource).getPosition().toString() + LINE_FEED_MSG_PART);
            aMsgBody.append("Postponed Anomaly Title: " + ((R4EUIPostponedAnomaly)aSource).getAnomaly().getTitle() + LINE_FEED_MSG_PART);
            aMsgBody.append("Postponed Anomaly Description: " + ((R4EUIPostponedAnomaly)aSource).getAnomaly().getDescription() + LINE_FEED_MSG_PART);
        } else if (aSource instanceof R4EUIAnomalyBasic) {
            IR4EUIModelElement parent = ((R4EUIAnomalyBasic)aSource).getParent().getParent();
            if (parent instanceof R4EUIFileContext) {
                R4EFileVersion file = ((R4EUIFileContext)parent).getTargetFileVersion();
                if (file == null) {
                    file = ((R4EUIFileContext)parent).getBaseFileVersion();
                }
                if (file != null) {
                    String path = file.getRepositoryPath();
                    if (path != null && !path.equals("")) {
                        aMsgBody.append("File Path (Repository): " + path + LINE_FEED_MSG_PART);
                    } else if (file.getResource() != null) {
                        aMsgBody.append("File Path (Project): " + file.getResource().getProject() + "/" + file.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                    }
                    aMsgBody.append("File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
                } else {
                    aMsgBody.append("File (Local): " + ((R4EUIFileContext)((R4EUIAnomalyBasic)aSource).getParent().getParent()).getName() + LINE_FEED_MSG_PART);
                }
                aMsgBody.append("Anomaly Line(s): " + ((R4EUIAnomalyBasic)aSource).getPosition().toString() + LINE_FEED_MSG_PART);
            }
            aMsgBody.append("Anomaly Title: " + ((R4EUIAnomalyBasic)aSource).getAnomaly().getTitle() + LINE_FEED_MSG_PART);
            aMsgBody.append("Anomaly Description: " + ((R4EUIAnomalyBasic)aSource).getAnomaly().getDescription() + LINE_FEED_MSG_PART);
        } else if (aSource instanceof R4EUIComment) {
            IR4EUIModelElement parent = ((R4EUIComment)aSource).getParent().getParent().getParent();
            if (parent instanceof R4EUIFileContext) {
                R4EFileVersion file = ((R4EUIFileContext)parent).getTargetFileVersion();
                if (file == null) {
                    file = ((R4EUIFileContext)parent).getBaseFileVersion();
                }
                if (file != null) {
                    String path = file.getRepositoryPath();
                    if (path != null && !path.equals("")) {
                        aMsgBody.append("File Path (Repository): " + path + LINE_FEED_MSG_PART);
                    } else if (file.getResource() != null) {
                        aMsgBody.append("File Path (Project): " + file.getResource().getProject() + "/" + file.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                    }
                    aMsgBody.append("File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
                } else {
                    aMsgBody.append("File (Local): " + ((R4EUIFileContext)((R4EUIComment)aSource).getParent().getParent().getParent()).getName() + LINE_FEED_MSG_PART);
                }
                aMsgBody.append("Anomaly Line(s): " + ((R4EUIAnomalyBasic)((R4EUIComment)aSource).getParent()).getPosition().toString() + LINE_FEED_MSG_PART);
            }
            aMsgBody.append("Anomaly Title: " + ((R4EUIAnomalyBasic)((R4EUIComment)aSource).getParent()).getAnomaly().getTitle() + LINE_FEED_MSG_PART);
            aMsgBody.append("Anomaly Description: " + ((R4EUIAnomalyBasic)((R4EUIComment)aSource).getParent()).getAnomaly().getDescription() + LINE_FEED_MSG_PART);
            aMsgBody.append("Anomaly Comment: " + ((R4EUIComment)aSource).getComment().getDescription() + LINE_FEED_MSG_PART);
        } else if (aSource instanceof R4EUIReviewBasic) {
            aMsgBody.append("Review: " + ((R4EUIReviewBasic)aSource).getReview().getName() + LINE_FEED_MSG_PART);
        } else if (aSource instanceof R4EUIReviewItem) {
            String description = ((R4EUIReviewItem)aSource).getItem().getDescription();
            if (description != null) {
                aMsgBody.append("Review Item Description: " + description + LINE_FEED_MSG_PART);
            } else {
                aMsgBody.append("Review Item Resource: " + ((R4EUIReviewItem)aSource).getFileContexts().get(0).getName() + LINE_FEED_MSG_PART);
            }
        } else if (aSource instanceof R4EUIFileContext) {
            R4EFileVersion file = ((R4EUIFileContext)aSource).getTargetFileVersion();
            if (file != null) {
                String path = file.getRepositoryPath();
                if (path != null && !path.equals("")) {
                    aMsgBody.append("Target File Path (Repository): " + path + LINE_FEED_MSG_PART);
                } else if (file.getResource() != null) {
                    aMsgBody.append("Target File Path (Project): " + file.getResource().getProject() + "/" + file.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                }
                aMsgBody.append("Target File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
            } else {
                aMsgBody.append("Target File (Local): " + ((R4EUIFileContext)aSource).getName() + LINE_FEED_MSG_PART);
                aMsgBody.append("Target File Version: None" + LINE_FEED_MSG_PART);
            }
            R4EFileVersion baseFile = ((R4EUIFileContext)aSource).getBaseFileVersion();
            if (baseFile != null) {
                String path = baseFile.getRepositoryPath();
                if (path != null && !path.equals("")) {
                    aMsgBody.append("Base File Path (Repository): " + path + LINE_FEED_MSG_PART);
                } else if (baseFile.getResource() != null) {
                    aMsgBody.append("Base File Path (Project): " + baseFile.getResource().getProject() + "/" + baseFile.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                }
                aMsgBody.append("Base File Version: " + baseFile.getVersionID() + LINE_FEED_MSG_PART);
            } else {
                aMsgBody.append("Base File (Local): " + ((R4EUIFileContext)aSource).getName() + LINE_FEED_MSG_PART);
                aMsgBody.append("Base File Version: None" + LINE_FEED_MSG_PART);
            }
        } else if (aSource instanceof R4EUIContent) {
            R4EFileVersion file = ((R4EUIFileContext)((R4EUIContent)aSource).getParent().getParent()).getTargetFileVersion();
            if (file == null) {
                file = ((R4EUIFileContext)((R4EUIContent)aSource).getParent().getParent()).getBaseFileVersion();
            }
            if (file != null) {
                String path = file.getRepositoryPath();
                if (path != null && !path.equals("")) {
                    aMsgBody.append("File Path (Repository): " + path + LINE_FEED_MSG_PART);
                } else if (file.getResource() != null) {
                    aMsgBody.append("File Path (Project): " + file.getResource().getProject() + "/" + file.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                }
                aMsgBody.append("File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
            } else {
                aMsgBody.append("File (Local): " + ((R4EUIFileContext)((R4EUIContent)aSource).getParent().getParent()).getName() + LINE_FEED_MSG_PART);
            }
            aMsgBody.append("Content Line(s): " + ((R4EUIContent)aSource).getPosition().toString() + LINE_FEED_MSG_PART);
        } else if (aSource instanceof IFile) {
            aMsgBody.append("File: " + ((IFile)aSource).getProject().getName() + "/" + ((IFile)aSource).getProjectRelativePath().toPortableString() + LINE_FEED_MSG_PART);
            aMsgBody.append(LINE_FEED_MSG_PART);
            aMsgBody.append("Position in File: " + CommandUtils.getPosition((IFile)aSource).toString() + LINE_FEED_MSG_PART);
        } else if (aSource instanceof TextSelection) {
            R4EFileVersion file;
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            IEditorInput input = editorPart.getEditorInput();
            if (input instanceof R4ECompareEditorInput) {
                ITypedElement element = ((R4ECompareEditorInput)input).getLeftElement();
                if (element instanceof R4EFileTypedElement) {
                    R4EFileVersion file2 = ((R4EFileTypedElement)element).getFileVersion();
                    aMsgBody.append("File: " + file2.getResource().getProject() + "/" + file2.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                    aMsgBody.append("File Version: " + file2.getVersionID() + LINE_FEED_MSG_PART);
                } else if (element instanceof R4EFileRevisionTypedElement) {
                    R4EFileVersion file3 = ((R4EFileRevisionTypedElement)element).getFileVersion();
                    aMsgBody.append("File Path: " + file3.getRepositoryPath() + LINE_FEED_MSG_PART);
                    aMsgBody.append("File Version: " + file3.getVersionID() + LINE_FEED_MSG_PART);
                }
            } else if (input instanceof R4EFileRevisionEditorInput) {
                file = ((R4EFileRevisionEditorInput)input).getFileVersion();
                aMsgBody.append("File Path: " + file.getRepositoryPath() + LINE_FEED_MSG_PART);
                aMsgBody.append("File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
            } else if (input instanceof R4EFileEditorInput) {
                file = ((R4EFileEditorInput)input).getFileVersion();
                aMsgBody.append("File: " + file.getResource().getProject() + "/" + file.getResource().getProjectRelativePath() + LINE_FEED_MSG_PART);
                aMsgBody.append("File Version: " + file.getVersionID() + LINE_FEED_MSG_PART);
            } else if (input instanceof FileEditorInput) {
                file = ((FileEditorInput)input).getFile();
                aMsgBody.append("File: " + file.getProject() + "/" + file.getProjectRelativePath() + LINE_FEED_MSG_PART);
                aMsgBody.append("File Version: (None available)" + LINE_FEED_MSG_PART);
            }
            TextSelection selectedText = (TextSelection)aSource;
            aMsgBody.append(LINE_FEED_MSG_PART);
            aMsgBody.append("Position in File: " + CommandUtils.getPosition((ITextSelection)selectedText).toString() + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
            aMsgBody.append("Contents: " + LINE_FEED_MSG_PART);
            aMsgBody.append(selectedText.getText());
        } else if (R4EUIPlugin.isJDTAvailable() && aSource instanceof org.eclipse.jdt.core.ISourceReference) {
            IFile file = (IFile)((IJavaElement)aSource).getResource();
            aMsgBody.append("File: " + file.getProject() + "/" + file.getProjectRelativePath() + LINE_FEED_MSG_PART);
            aMsgBody.append("File Version: (None available)" + LINE_FEED_MSG_PART);
            try {
                R4EUITextPosition position = CommandUtils.getPosition((org.eclipse.jdt.core.ISourceReference)aSource, file);
                aMsgBody.append("Position in File: " + position.toString() + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
            }
            catch (CoreException coreException) {}
        } else if (R4EUIPlugin.isCDTAvailable() && aSource instanceof ISourceReference) {
            IFile file = null;
            if (aSource instanceof ITranslationUnit) {
                file = (IFile)((ICElement)aSource).getResource();
            } else if (aSource instanceof ICElement) {
                file = (IFile)((ICElement)aSource).getParent().getResource();
            }
            if (file != null) {
                aMsgBody.append("File: " + file.getProject() + "/" + file.getProjectRelativePath() + LINE_FEED_MSG_PART);
                aMsgBody.append("File Version: (None available)" + LINE_FEED_MSG_PART);
                try {
                    R4EUITextPosition position = CommandUtils.getPosition((ISourceReference)aSource, file);
                    aMsgBody.append("Position in File: " + position.toString() + LINE_FEED_MSG_PART + LINE_FEED_MSG_PART);
                }
                catch (CoreException coreException) {}
            }
        }
    }

    private static String createReviewInfoPart() {
        StringBuilder msgReviewInfo = new StringBuilder();
        msgReviewInfo.append(LINE_FEED_MSG_PART);
        msgReviewInfo.append("Review Information");
        msgReviewInfo.append(LINE_FEED_MSG_PART);
        msgReviewInfo.append("Group: \t\t" + R4EUIModelController.getActiveReview().getParent().getName() + LINE_FEED_MSG_PART);
        msgReviewInfo.append("Review: \t" + R4EUIModelController.getActiveReview().getReview().getName() + LINE_FEED_MSG_PART);
        msgReviewInfo.append("Components: \t");
        EList components = R4EUIModelController.getActiveReview().getReview().getComponents();
        for (String component : components) {
            msgReviewInfo.append(String.valueOf(component) + ", ");
        }
        msgReviewInfo.append(LINE_FEED_MSG_PART);
        msgReviewInfo.append("Project: \t" + R4EUIModelController.getActiveReview().getReview().getProject() + LINE_FEED_MSG_PART);
        msgReviewInfo.append("Participants: \t");
        List<String> participants = R4EUIModelController.getActiveReview().getParticipantIDs();
        for (String participant : participants) {
            msgReviewInfo.append(String.valueOf(participant) + ", ");
        }
        msgReviewInfo.append(LINE_FEED_MSG_PART);
        msgReviewInfo.append(LINE_FEED_MSG_PART);
        return msgReviewInfo.toString();
    }

    private static String createIntroPart() {
        StringBuilder msgIntro = new StringBuilder();
        msgIntro.append(LINE_FEED_MSG_PART);
        msgIntro.append(INTRO_MSG_BODY);
        msgIntro.append(LINE_FEED_MSG_PART);
        msgIntro.append(LINE_FEED_MSG_PART);
        return msgIntro.toString();
    }

    private static String createOutroPart() {
        StringBuilder msgOutro = new StringBuilder();
        msgOutro.append(OUTRO_MSG_BODY + LINE_FEED_MSG_PART);
        msgOutro.append(R4EUIModelController.getReviewer());
        return msgOutro.toString();
    }

    public static void sendMeetingRequest() throws ResourceHandlingException, OutOfSyncException {
        if (R4EUIDialogFactory.getInstance().getMailConnector() != null) {
            boolean meetingInfoFound = false;
            R4EMeetingData r4eMeetingData = R4EUIModelController.getActiveReview().getReview().getActiveMeeting();
            IMeetingData meetingData = null;
            if (r4eMeetingData != null && (meetingData = R4EUIDialogFactory.getInstance().getMailConnector().openAndUpdateMeeting(MailServicesProxy.createMeetingData(r4eMeetingData), R4EUIModelController.getActiveReview().getReview().getStartDate())) != null) {
                meetingInfoFound = true;
            }
            if (!meetingInfoFound) {
                String[] messageDestinations = MailServicesProxy.createItemsUpdatedDestinations();
                if (messageDestinations.length == 0) {
                    final ErrorDialog dialog = new ErrorDialog(null, "R4E Error", "Cannot Send Meeting Request", (IStatus)new Status(4, "org.eclipse.mylyn.reviews.r4e.ui", "No valid destinations for participants defined", null), 4);
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            dialog.open();
                        }
                    });
                    return;
                }
                String messageSubject = null;
                messageSubject = R4EUIModelController.getActiveReview().getReview().getActiveMeeting() != null ? String.valueOf(MailServicesProxy.createSubject()) + " - Decision Meeting Request Updated" : String.valueOf(MailServicesProxy.createSubject()) + " - Items Ready for Review & Decision Meeting Request";
                String messageBody = MailServicesProxy.createItemsReadyNotificationMessage(true);
                try {
                    meetingData = R4EUIDialogFactory.getInstance().getMailConnector().createMeetingRequest(messageSubject, messageBody, messageDestinations, MailServicesProxy.getDefaultStartTime(), DEFAULT_MEETING_DURATION);
                }
                catch (CoreException e) {
                    R4EUIPlugin.Ftracer.traceWarning("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                    R4EUIPlugin.getDefault().logWarning("Exception: " + e.toString(), (Exception)((Object)e));
                    return;
                }
            }
            R4EUIModelController.getActiveReview().setMeetingData(meetingData);
        } else {
            MailServicesProxy.showNoEmailConnectorDialog();
        }
    }

    public static Long getDefaultStartTime() {
        GregorianCalendar meetingDate = new GregorianCalendar();
        switch (meetingDate.get(7)) {
            case 3: {
                meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + 518400000L);
                break;
            }
            case 4: {
                meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + 691200000L);
                break;
            }
            case 5: {
                meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + 604800000L);
                break;
            }
            case 6: {
                meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + 518400000L);
                break;
            }
            case 7: {
                meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + 432000000L);
                break;
            }
            default: {
                meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + 345600000L);
            }
        }
        meetingDate.set(11, 10);
        meetingDate.set(12, 0);
        meetingDate.set(13, 0);
        meetingDate.setTimeInMillis(meetingDate.getTimeInMillis() + (long)TimeZone.getDefault().getOffset(System.currentTimeMillis()));
        return meetingDate.getTimeInMillis();
    }

    private static void showNoEmailConnectorDialog() {
        final ErrorDialog dialog = new ErrorDialog(null, "R4E Warning", "No Email connector detectedTake note that no Automatic Email can be sent because no Mail Services Connector is Present", (IStatus)new Status(2, "org.eclipse.mylyn.reviews.r4e.ui", 0, null, null), 2);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
    }

    private static String buildLineTag(R4EDelta aDelta) {
        if (aDelta.getTarget() != null && aDelta.getTarget().getLocation() != null) {
            int startLine = ((R4ETextPosition)aDelta.getTarget().getLocation()).getStartLine();
            int endLineLine = ((R4ETextPosition)aDelta.getTarget().getLocation()).getEndLine();
            StringBuilder buffer = new StringBuilder(28);
            if (startLine == endLineLine) {
                buffer.append("Line " + startLine);
            } else {
                buffer.append("Lines " + startLine + "-" + endLineLine);
            }
            return buffer.toString();
        }
        return "";
    }

    private static IMeetingData createMeetingData(final R4EMeetingData aR4EMeetingData) {
        final Persistence.ResourceUpdater resUpdater = R4EUIModelController.FResourceUpdater;
        return new IMeetingData(){

            public int getSentCounter() {
                return aR4EMeetingData.getSentCount();
            }

            public void incrementSentCounter() {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setSentCount(aR4EMeetingData.getSentCount() + 1);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public void clearSentCounter() {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setSentCount(0);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getCustomID() {
                return aR4EMeetingData.getId();
            }

            public void setCustomID(String aId) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setId(aId);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getSubject() {
                return aR4EMeetingData.getSubject();
            }

            public void setSubject(String aSubject) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setSubject(aSubject);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getBody() {
                return aR4EMeetingData.getBody();
            }

            public void setBody(String aBody) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setBody(aBody);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getLocation() {
                return aR4EMeetingData.getLocation();
            }

            public void setLocation(String aLocation) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setLocation(aLocation);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public Long getStartTime() {
                return aR4EMeetingData.getStartTime();
            }

            public void setStartTime(Long aStartTime) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setStartTime(aStartTime.longValue());
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public Integer getDuration() {
                return aR4EMeetingData.getDuration();
            }

            public void setDuration(Integer aDuration) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setDuration(aDuration.intValue());
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String getSender() {
                return aR4EMeetingData.getSender();
            }

            public void setSender(String aSender) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.setSender(aSender);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public String[] getReceivers() {
                EList recieversL = aR4EMeetingData.getReceivers();
                String[] receivers = (String[])recieversL.toArray((Object[])new String[recieversL.size()]);
                return receivers;
            }

            public void clearReceivers() {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.getReceivers().clear();
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public void addReceiver(String aReceiver) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.getReceivers().add((Object)aReceiver);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }

            public void removeReceiver(String aReceiver) {
                try {
                    Long bookNum = resUpdater.checkOut((EObject)aR4EMeetingData, R4EUIModelController.getReviewer());
                    aR4EMeetingData.getReceivers().remove((Object)aReceiver);
                    resUpdater.checkIn(bookNum);
                }
                catch (ResourceHandlingException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
                catch (OutOfSyncException e) {
                    R4EUIPlugin.Ftracer.traceError("Exception: " + e.toString() + " (" + e.getMessage() + ")");
                }
            }
        };
    }
}

