/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.r4e.internal.transform.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mylyn.reviews.frame.core.model.Review;
import org.eclipse.mylyn.reviews.frame.core.model.ReviewState;
import org.eclipse.mylyn.reviews.frame.core.model.TaskReference;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomaly;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EAnomalyType;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EComment;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EFormalReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EItem;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EMeetingData;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReview;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewDecision;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewGroup;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EReviewPhaseInfo;
import org.eclipse.mylyn.reviews.r4e.core.model.R4EUser;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelReader;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IModelWriter;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.IRWUserBasedRes;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.Persistence;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.CompatibilityException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.ResourceHandlingException;
import org.eclipse.mylyn.reviews.r4e.core.model.serial.impl.SerializeFactory;
import org.eclipse.mylyn.reviews.r4e.internal.transform.Activator;
import org.eclipse.mylyn.reviews.r4e.internal.transform.ModelTransform;
import org.eclipse.mylyn.reviews.r4e.internal.transform.resources.ReviewGroupRes;
import org.eclipse.mylyn.reviews.r4e.internal.transform.resources.ReviewRes;
import org.eclipse.mylyn.reviews.r4e.internal.transform.resources.TransResFactory;
import org.eclipse.mylyn.reviews.r4e.internal.transform.serial.impl.TResSerializeFactory;

public class ModelTransformImpl
implements ModelTransform {
    IModelWriter fWriter = TResSerializeFactory.getWriter();
    IModelReader fReader = TResSerializeFactory.getReader();
    Persistence.RModelFactoryExt fModelFactory = SerializeFactory.getModelExtension();
    TransResFactory fModelResFactory = TransResFactory.eINSTANCE;

    public ReviewGroupRes createReviewGroupRes(URI aFolderPath, String aGroupName, String aFilePrefix) throws ResourceHandlingException {
        URI fileGroupURI = this.fWriter.createResourceURI(aFilePrefix, aFolderPath, IRWUserBasedRes.ResourceType.GROUP);
        Resource resource = this.fWriter.createResourceSetWithResource(fileGroupURI);
        ReviewGroupRes group = TransResFactory.eINSTANCE.createReviewGroupRes();
        resource.getContents().add((Object)group);
        URI uri = group.eResource().getURI().trimSegments(1);
        group.setName(aGroupName);
        group.setFilesPrefix(aFilePrefix);
        group.setFolder(URI.decode((String)uri.devicePath().toString()));
        this.fWriter.saveResource(resource);
        return group;
    }

    public ReviewGroupRes openReviewGroupRes(URI aResourcePath) throws ResourceHandlingException {
        ReviewGroupRes group = (ReviewGroupRes)this.fReader.deserializeTopElement(aResourcePath, ReviewGroupRes.class);
        EList anomTypes = group.getAvailableAnomalyTypes();
        for (R4EAnomalyType r4eAnomalyType : anomTypes) {
            group.getAnomalyTypeKeyToReference().put((Object)r4eAnomalyType.getType(), (Object)r4eAnomalyType);
        }
        URI resUri = group.eResource().getURI().trimSegments(1);
        group.setFolder(URI.decode((String)resUri.devicePath().toString()));
        return group;
    }

    public String closeReviewGroupRes(ReviewGroupRes aReviewGroup) {
        StringBuilder sb = new StringBuilder();
        Resource resource = aReviewGroup.eResource();
        if (resource == null) {
            sb.append("Attempting to close a review group with no associated resource");
            Activator.fTracer.traceDebug(sb.toString());
            return sb.toString();
        }
        ResourceSet resSet = resource.getResourceSet();
        if (resSet == null) {
            sb.append("Attempting to close a review group with no associated resource set");
            Activator.fTracer.traceDebug(sb.toString());
            return sb.toString();
        }
        EList resList = resSet.getResources();
        for (Resource res : resList) {
            res.unload();
        }
        return null;
    }

    public ReviewRes transformReview(URI aOigReviewGroup, URI aDstReviewGroup, String aOigReviewName) throws ResourceHandlingException, CompatibilityException {
        R4EReviewGroup origGroup = Persistence.RModelFactoryExt.eINSTANCE.openR4EReviewGroup(aOigReviewGroup);
        R4EReview origReview = Persistence.RModelFactoryExt.eINSTANCE.openR4EReview(origGroup, aOigReviewName);
        ReviewGroupRes destGroup = this.openReviewGroupRes(aDstReviewGroup);
        ResourceSet destResSet = destGroup.eResource().getResourceSet();
        String filePrefix = destGroup.getFilesPrefix();
        EList<ReviewRes> existingReviews = destGroup.getReviewsRes();
        for (Object element : existingReviews) {
            ReviewRes reviewRes = (ReviewRes)element;
            if (!reviewRes.getName().equals(aOigReviewName)) continue;
            StringBuilder sb = new StringBuilder("A review with this name already exists in destination Group: " + aOigReviewName);
            throw new ResourceHandlingException(sb.toString());
        }
        ReviewRes destReview = this.fModelResFactory.createReviewRes();
        Resource destReviewResource = null;
        if (existingReviews == null || existingReviews.size() == 0) {
            URI containerPath = destGroup.eResource().getURI().trimSegments(1);
            URI destReviewURI = this.fWriter.createResourceURI(filePrefix, containerPath, IRWUserBasedRes.ResourceType.REVIEW);
            destReviewResource = destResSet.createResource(destReviewURI);
        } else {
            destReviewResource = ((ReviewRes)existingReviews.get(0)).eResource();
        }
        destGroup.getReviewsRes().add((Object)destReview);
        destReviewResource.getContents().add((Object)destReview);
        this.adaptReview(origReview, destReview, destGroup);
        this.fWriter.saveResources(destGroup.eResource().getResourceSet());
        return destReview;
    }

    private void adaptReview(R4EReview origReview, ReviewRes destReview, ReviewGroupRes destGroup) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection origUsersList = origReview.getUsersMap().values();
        this.copyReviewData(origReview, destReview, copier);
        Resource destResource = destReview.eResource();
        R4EUser createdBy = origReview.getCreatedBy();
        EList<R4EUser> users = destReview.getUsersRes();
        for (R4EUser oUser : origUsersList) {
            R4EUser dUser = (R4EUser)this.copyToResource(destResource, (EObject)oUser, copier);
            users.add((Object)dUser);
            destResource.getContents().add((Object)dUser);
            if (oUser != createdBy) continue;
            destReview.setCreatedBy(dUser);
        }
        copier.copyReferences();
        EList<R4EUser> destUsers = destReview.getUsersRes();
        for (R4EUser user : destUsers) {
            user.setReviewInstance((R4EReview)destReview);
            EList comments = user.getAddedComments();
            for (R4EComment comment : comments) {
                if (!(comment instanceof R4EAnomaly)) continue;
                R4EAnomaly anomaly = (R4EAnomaly)comment;
                anomaly.setReview((Review)destReview);
            }
            EList items = user.getAddedItems();
            for (R4EItem item : items) {
                item.setReview((Review)destReview);
            }
        }
    }

    private void associateToResource(Resource destResource, EObject eObject) {
        destResource.getContents().add((Object)eObject);
        TreeIterator iterator = EcoreUtil.getAllContents((EObject)eObject, (boolean)true);
        while (iterator.hasNext()) {
            Object child = iterator.next();
            if (!(child instanceof EObject)) continue;
            EObject eobject = (EObject)child;
            destResource.getContents().add((Object)eobject);
        }
    }

    private EObject copyToResource(Resource resource, EObject source, EcoreUtil.Copier copier) {
        EObject copyOfObject = copier.copy(source);
        this.associateToResource(resource, copyOfObject);
        return copyOfObject;
    }

    private void copyReviewData(R4EReview origReview, ReviewRes destReview, EcoreUtil.Copier copier) {
        R4EFormalReview formalRevOrig;
        EList phases;
        Resource res = destReview.eResource();
        if (origReview.getActiveMeeting() != null) {
            R4EMeetingData meetingData = (R4EMeetingData)this.copyToResource(res, (EObject)origReview.getActiveMeeting(), copier);
            destReview.setActiveMeeting(meetingData);
        }
        if (origReview.getAnomalyTemplate() != null) {
            R4EAnomaly anomalyTemplate = (R4EAnomaly)this.copyToResource(res, (EObject)origReview.getAnomalyTemplate(), copier);
            destReview.setAnomalyTemplate(anomalyTemplate);
        }
        if (origReview.getDecision() != null) {
            R4EReviewDecision decision = (R4EReviewDecision)this.copyToResource(res, (EObject)origReview.getDecision(), copier);
            destReview.setDecision(decision);
        }
        if (origReview.getReviewTask() != null) {
            TaskReference taskRef = (TaskReference)this.copyToResource(res, (EObject)origReview.getReviewTask(), copier);
            destReview.setReviewTask(taskRef);
        }
        if (origReview.getState() != null) {
            ReviewState state = (ReviewState)this.copyToResource(res, (EObject)origReview.getState(), copier);
            destReview.setState(state);
        }
        destReview.setType(origReview.getType());
        destReview.setEnabled(origReview.isEnabled());
        destReview.setEndDate(origReview.getEndDate());
        destReview.setDueDate(origReview.getDueDate());
        destReview.setEntryCriteria(origReview.getEntryCriteria());
        destReview.setExtraNotes(origReview.getExtraNotes());
        destReview.setName(origReview.getName());
        destReview.setObjectives(origReview.getObjectives());
        destReview.setProject(origReview.getProject());
        destReview.setReferenceMaterial(origReview.getReferenceMaterial());
        destReview.setStartDate(origReview.getStartDate());
        destReview.setFragmentVersion(origReview.getFragmentVersion());
        EList components = origReview.getComponents();
        for (Object element : components) {
            String component = (String)element;
            destReview.getComponents().add((Object)component);
        }
        if (origReview instanceof R4EFormalReview && (phases = (formalRevOrig = (R4EFormalReview)origReview).getPhases()) != null) {
            R4EReviewPhaseInfo[] movingPhases;
            R4EReviewPhaseInfo currentPhase = formalRevOrig.getCurrent();
            R4EReviewPhaseInfo[] r4EReviewPhaseInfoArray = movingPhases = (R4EReviewPhaseInfo[])phases.toArray((Object[])new R4EReviewPhaseInfo[0]);
            int n = movingPhases.length;
            int n2 = 0;
            while (n2 < n) {
                R4EReviewPhaseInfo phaseInfo = r4EReviewPhaseInfoArray[n2];
                R4EReviewPhaseInfo phaseInfoCopy = (R4EReviewPhaseInfo)this.copyToResource(res, (EObject)phaseInfo, copier);
                destReview.getPhases().add((Object)phaseInfoCopy);
                if (phaseInfo == currentPhase) {
                    destReview.setCurrent(phaseInfoCopy);
                }
                ++n2;
            }
        }
    }
}

