/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.internal.storage;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.storage.GitBlobStorage;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;

public class CommitBlobStorage
extends GitBlobStorage {
    private final RevCommit commit;

    public CommitBlobStorage(Repository repository, String fileName, ObjectId blob, RevCommit commit) {
        super(repository, fileName, blob);
        this.commit = commit;
    }

    @Override
    public IPath getFullPath() {
        RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
        Path repoPath = new Path(repositoryUtil.getRepositoryName(this.db));
        String pathString = String.valueOf(super.getFullPath().toPortableString()) + " " + Utils.getShortObjectId(this.commit.getId());
        return repoPath.append(Path.fromPortableString((String)pathString));
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + (this.commit == null ? 0 : this.commit.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CommitBlobStorage other = (CommitBlobStorage)obj;
        return !(this.commit == null ? other.commit != null : !this.commit.equals((AnyObjectId)other.commit));
    }
}

