/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public abstract class WizardDataTransferPage
extends WizardPage
implements Listener,
IOverwriteQuery {
    protected static final int SIZING_TEXT_FIELD_WIDTH = 250;
    protected static final int COMBO_HISTORY_LENGTH = 20;

    protected WizardDataTransferPage(String pageName) {
        super(pageName);
    }

    protected String[] addToHistory(String[] history, String newEntry) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(history));
        this.addToHistory(l, newEntry);
        String[] r = new String[l.size()];
        l.toArray(r);
        return r;
    }

    protected void addToHistory(List history, String newEntry) {
        history.remove(newEntry);
        history.add(0, newEntry);
        if (history.size() > 20) {
            history.remove(20);
        }
    }

    protected abstract boolean allowNewContainerName();

    protected Label createBoldLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setFont(JFaceResources.getBannerFont());
        label.setText(text);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createOptionsGroupButtons(Group optionsGroup) {
    }

    protected Label createPlainLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setFont(parent.getFont());
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createSpacer(Composite parent) {
        Label spacer = new Label(parent, 0);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        spacer.setLayoutData((Object)data);
    }

    protected boolean determinePageCompletion() {
        boolean complete;
        boolean bl = complete = this.validateSourceGroup() && this.validateDestinationGroup() && this.validateOptionsGroup();
        if (complete) {
            this.setErrorMessage(null);
        }
        return complete;
    }

    protected IPath getPathFromText(Text textField) {
        String text = textField.getText();
        if (text.length() == 0) {
            return new Path(text);
        }
        return new Path(text).makeAbsolute();
    }

    protected IPath queryForContainer(IContainer initialSelection, String msg) {
        return this.queryForContainer(initialSelection, msg, null);
    }

    protected IPath queryForContainer(IContainer initialSelection, String msg, String title) {
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getControl().getShell(), initialSelection, this.allowNewContainerName(), msg);
        if (title != null) {
            dialog.setTitle(title);
        }
        dialog.showClosedProjects(false);
        dialog.open();
        Object[] result = dialog.getResult();
        if (result != null && result.length == 1) {
            return (IPath)result[0];
        }
        return null;
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    protected boolean queryYesNoQuestion(String message) {
        MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, message, 0, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

            protected int getShellStyle() {
                return super.getShellStyle() | 0x10000000;
            }
        };
        return dialog.open() == 0;
    }

    protected void restoreWidgetValues() {
    }

    protected void saveWidgetValues() {
    }

    protected void updatePageCompletion() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setErrorMessage(null);
        }
    }

    protected void updateWidgetEnablements() {
    }

    protected boolean validateDestinationGroup() {
        return true;
    }

    protected boolean validateOptionsGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        return true;
    }

    protected void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(IDEWorkbenchMessages.WizardExportPage_options);
        optionsGroup.setFont(parent.getFont());
        this.createOptionsGroupButtons(optionsGroup);
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message, (int)0x10000000);
    }

    protected void displayErrorDialog(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_exceptionMessage, (Object)exception);
        }
        this.displayErrorDialog(message);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }
}

