/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.contexts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.contexts.DebugContextSourceProvider;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextProvider;
import org.eclipse.debug.ui.contexts.IDebugContextProvider2;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IEvaluationService;

public class DebugWindowContextService
implements IDebugContextService,
IPartListener2,
IDebugContextListener {
    private Map<String, ListenerList<IDebugContextListener>> fListenersByPartId = new HashMap<String, ListenerList<IDebugContextListener>>();
    private Map<String, IDebugContextProvider> fProvidersByPartId = new HashMap<String, IDebugContextProvider>();
    private Map<String, ListenerList<IDebugContextListener>> fPostListenersByPartId = new HashMap<String, ListenerList<IDebugContextListener>>();
    private IWorkbenchWindow fWindow;
    private List<IDebugContextProvider> fProviders = new ArrayList<IDebugContextProvider>();
    private DebugContextSourceProvider fSourceProvider;

    public DebugWindowContextService(IWorkbenchWindow window, final IEvaluationService evaluationService) {
        this.fWindow = window;
        this.fWindow.getPartService().addPartListener((IPartListener2)this);
        window.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (DebugWindowContextService.this.fWindow != null) {
                    DebugWindowContextService.this.fSourceProvider = new DebugContextSourceProvider(DebugWindowContextService.this, evaluationService);
                }
            }
        });
    }

    public void dispose() {
        if (this.fSourceProvider != null) {
            this.fSourceProvider.dispose();
        }
        this.fWindow.getPartService().removePartListener((IPartListener2)this);
        this.fWindow = null;
    }

    @Override
    public synchronized void addDebugContextProvider(IDebugContextProvider provider) {
        if (this.fWindow == null) {
            return;
        }
        IWorkbenchPart part = provider.getPart();
        this.fProvidersByPartId.put(this.getCombinedPartId(part), provider);
        boolean canSetActive = true;
        if (provider instanceof IDebugContextProvider2) {
            canSetActive = ((IDebugContextProvider2)provider).isWindowContextProvider();
        }
        if (canSetActive) {
            IWorkbenchPart activePart = null;
            IWorkbenchPage activePage = this.fWindow.getActivePage();
            if (activePage != null) {
                activePart = activePage.getActivePart();
            }
            boolean bl = canSetActive = activePart == null && part == null || activePart != null && activePart.equals(part);
        }
        if (canSetActive) {
            this.fProviders.add(0, provider);
        } else {
            this.fProviders.add(provider);
        }
        this.notify(provider);
        provider.addDebugContextListener(this);
    }

    @Override
    public synchronized void removeDebugContextProvider(IDebugContextProvider provider) {
        int index = this.fProviders.indexOf(provider);
        if (index >= 0) {
            this.fProvidersByPartId.remove(this.getCombinedPartId(provider.getPart()));
            this.fProviders.remove(index);
            IDebugContextProvider activeProvider = this.getActiveProvider();
            if (index == 0) {
                if (activeProvider != null) {
                    this.notify(activeProvider);
                } else {
                    this.notify(new DebugContextEvent(provider, (ISelection)StructuredSelection.EMPTY, 1));
                }
            } else {
                this.notifyPart(provider.getPart(), new DebugContextEvent(activeProvider, this.getActiveContext(), 1));
            }
        }
        provider.removeDebugContextListener(this);
    }

    @Override
    public void addDebugContextListener(IDebugContextListener listener) {
        this.addDebugContextListener(listener, null);
    }

    @Override
    public void addPostDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = this.fPostListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fPostListenersByPartId.put(partId, (ListenerList<IDebugContextListener>)list);
        }
        list.add((Object)listener);
    }

    @Override
    public void addPostDebugContextListener(IDebugContextListener listener) {
        this.addPostDebugContextListener(listener, null);
    }

    @Override
    public void removePostDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList<IDebugContextListener> list = this.fPostListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
        }
    }

    @Override
    public void removePostDebugContextListener(IDebugContextListener listener) {
        this.removePostDebugContextListener(listener, null);
    }

    @Override
    public void removeDebugContextListener(IDebugContextListener listener) {
        this.removeDebugContextListener(listener, null);
    }

    protected void notify(IDebugContextProvider provdier) {
        ISelection activeContext = provdier.getActiveContext();
        if (activeContext == null) {
            activeContext = new StructuredSelection();
        }
        this.notify(new DebugContextEvent(provdier, activeContext, 1));
    }

    protected void notify(DebugContextEvent event) {
        IDebugContextProvider provider = this.getActiveProvider();
        IWorkbenchPart part = event.getDebugContextProvider().getPart();
        if (provider == null || provider == event.getDebugContextProvider()) {
            this.notify(event, this.getListeners(null));
        }
        if (part != null) {
            this.notify(event, this.getListeners(part));
        }
        if (provider == null || provider == event.getDebugContextProvider()) {
            this.notify(event, this.getPostListeners(null));
        }
        if (part != null) {
            this.notify(event, this.getPostListeners(part));
        }
    }

    protected void notifyPart(IWorkbenchPart part, DebugContextEvent event) {
        if (part != null) {
            this.notify(event, this.getListeners(part));
            this.notify(event, this.getPostListeners(part));
        }
    }

    protected void notify(final DebugContextEvent event, ListenerList<IDebugContextListener> listeners) {
        for (final IDebugContextListener listener : listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.debugContextChanged(event);
                }

                public void handleException(Throwable exception) {
                    DebugUIPlugin.log(exception);
                }
            });
        }
    }

    protected ListenerList<IDebugContextListener> getListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = this.getCombinedPartId(part);
            ListenerList listenerList = this.fListenersByPartId.get(id);
            return listenerList != null ? listenerList : new ListenerList();
        }
        ListenerList<IDebugContextListener> listenerList = this.fListenersByPartId.get(null);
        ListenerList retVal = new ListenerList();
        for (IDebugContextListener iDebugContextListener : listenerList) {
            retVal.add((Object)iDebugContextListener);
        }
        block1: for (String listenerPartId : this.fListenersByPartId.keySet()) {
            int i = 0;
            while (i < this.fProviders.size()) {
                String providerPartId = this.getCombinedPartId(this.fProviders.get(i).getPart());
                if (listenerPartId == null && providerPartId == null || listenerPartId != null && listenerPartId.equals(providerPartId)) continue block1;
                ++i;
            }
            for (IDebugContextListener iDebugContextListener : this.fListenersByPartId.get(listenerPartId)) {
                retVal.add((Object)iDebugContextListener);
            }
        }
        return retVal;
    }

    protected ListenerList<IDebugContextListener> getPostListeners(IWorkbenchPart part) {
        String id = null;
        if (part != null) {
            id = this.getCombinedPartId(part);
            ListenerList listenerList = this.fPostListenersByPartId.get(id);
            return listenerList != null ? listenerList : new ListenerList();
        }
        ListenerList<IDebugContextListener> retVal = this.fPostListenersByPartId.get(null);
        block0: for (String listenerPartId : this.fPostListenersByPartId.keySet()) {
            int i = 0;
            while (i < this.fProviders.size()) {
                String providerPartId = this.getCombinedPartId(this.fProviders.get(i).getPart());
                if (listenerPartId == null && providerPartId == null || listenerPartId != null && listenerPartId.equals(providerPartId)) continue block0;
                ++i;
            }
            for (IDebugContextListener iDebugContextListener : this.fPostListenersByPartId.get(listenerPartId)) {
                retVal.add((Object)iDebugContextListener);
            }
        }
        return retVal;
    }

    @Override
    public synchronized void addDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList list = this.fListenersByPartId.get(partId);
        if (list == null) {
            list = new ListenerList();
            this.fListenersByPartId.put(partId, (ListenerList<IDebugContextListener>)list);
        }
        list.add((Object)listener);
    }

    @Override
    public void removeDebugContextListener(IDebugContextListener listener, String partId) {
        ListenerList<IDebugContextListener> list = this.fListenersByPartId.get(partId);
        if (list != null) {
            list.remove((Object)listener);
            if (list.size() == 0) {
                this.fListenersByPartId.remove(partId);
            }
        }
    }

    @Override
    public ISelection getActiveContext(String partId) {
        IDebugContextProvider provider = this.fProvidersByPartId.get(partId);
        if (provider != null) {
            return provider.getActiveContext();
        }
        return this.getActiveContext();
    }

    @Override
    public ISelection getActiveContext() {
        IDebugContextProvider activeProvider = this.getActiveProvider();
        if (activeProvider != null) {
            return activeProvider.getActiveContext();
        }
        return null;
    }

    private IDebugContextProvider getActiveProvider() {
        if (!this.fProviders.isEmpty()) {
            return this.fProviders.get(0);
        }
        return null;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IDebugContextProvider provider = this.fProvidersByPartId.get(partRef.getId());
        if (provider != null) {
            int index;
            boolean canSetActive = true;
            if (provider instanceof IDebugContextProvider2) {
                canSetActive = ((IDebugContextProvider2)provider).isWindowContextProvider();
            }
            if (canSetActive && (index = this.fProviders.indexOf(provider)) > 0) {
                this.fProviders.remove(index);
                this.fProviders.add(0, provider);
                this.notify(provider);
            }
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public synchronized void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    @Override
    public void debugContextChanged(DebugContextEvent event) {
        this.notify(event);
    }

    private String getCombinedPartId(IWorkbenchPart part) {
        if (part == null) {
            return null;
        }
        if (part.getSite() instanceof IViewSite) {
            IViewSite site = (IViewSite)part.getSite();
            return this.getCombinedPartId(site.getId(), site.getSecondaryId());
        }
        return part.getSite().getId();
    }

    private String getCombinedPartId(String id, String secondaryId) {
        return String.valueOf(id) + (secondaryId != null ? ":" + secondaryId : "");
    }

    @Override
    public void addDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.addDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    @Override
    public void removeDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.removeDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    @Override
    public void addPostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.addPostDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    @Override
    public void removePostDebugContextListener(IDebugContextListener listener, String partId, String partSecondaryId) {
        this.removePostDebugContextListener(listener, this.getCombinedPartId(partId, partSecondaryId));
    }

    @Override
    public ISelection getActiveContext(String partId, String partSecondaryId) {
        return this.getActiveContext(this.getCombinedPartId(partId, partSecondaryId));
    }
}

