/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.rcptt.ui.editors.ecl.EclLangUtil;

abstract class CommandNameRule
implements IPredicateRule {
    private ICharacterScanner scanner;

    CommandNameRule() {
    }

    public IToken evaluate(ICharacterScanner scanner) {
        this.scanner = scanner;
        int startColumn = scanner.getColumn();
        try {
            int ch = this.peek();
            if (!EclLangUtil.isCommandNameStart(ch)) {
                return Token.UNDEFINED;
            }
            if (scanner.getColumn() < 0) {
                return Token.UNDEFINED;
            }
            if (scanner.getColumn() > 0) {
                ch = this.backPeek();
                while (EclLangUtil.isWhiteSpace(ch)) {
                    if (scanner.getColumn() <= 0) break;
                    ch = this.back();
                }
                if (scanner.getColumn() != 0 && !EclLangUtil.isCommandDelimiter(ch)) {
                    this.gotoColumn(startColumn);
                    return Token.UNDEFINED;
                }
            }
            this.gotoColumn(startColumn);
            return this.evaluate(scanner, true);
        }
        catch (Exception exception) {
            this.gotoColumn(startColumn);
            return Token.UNDEFINED;
        }
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        int ch;
        while ((ch = scanner.read()) != -1 && EclLangUtil.isCommandNamePart(ch)) {
        }
        scanner.unread();
        return this.getSuccessToken();
    }

    private int backPeek() {
        this.scanner.unread();
        return this.scanner.read();
    }

    private int peek() {
        int retVal = this.scanner.read();
        this.scanner.unread();
        return retVal;
    }

    private int back() {
        this.scanner.unread();
        this.scanner.unread();
        return this.scanner.read();
    }

    private void gotoColumn(int column) {
        while (column > this.scanner.getColumn()) {
            this.scanner.read();
        }
        while (column < this.scanner.getColumn()) {
            this.scanner.unread();
        }
    }

    public abstract IToken getDefaultReturnToken();
}

