/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.filesystem.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rcptt.ctx.filesystem.FSUtils;
import org.eclipse.rcptt.ctx.filesystem.ui.Activator;
import org.eclipse.rcptt.ctx.filesystem.ui.actions.FSAction;
import org.eclipse.rcptt.filesystem.FSFile;
import org.eclipse.rcptt.filesystem.FSFolder;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddFiles
extends FSAction {
    public AddFiles() {
        super("Add Files...", Images.getImageDescriptor((String)"icons/newFile.gif"));
    }

    @Override
    protected void init() {
        this.setEnabled(this.getFolder() != null);
    }

    public void run() {
        block6: {
            Shell shell = this.viewer.getTree().getShell();
            FileDialog dialog = new FileDialog(shell, 2);
            if (dialog.open() == null) {
                return;
            }
            final FSFolder parent = this.getFolder();
            String[] fileNames = dialog.getFileNames();
            final File[] paths = new File[fileNames.length];
            int i = 0;
            while (i < paths.length) {
                paths[i] = new File(dialog.getFilterPath(), fileNames[i]);
                ++i;
            }
            final AtomicReference result = new AtomicReference();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Adding files...", -1);
                    try {
                        result.set(FSUtils.addFiles((FSFolder)parent, (File[])paths));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
                FSFile[] files = (FSFile[])result.get();
                if (files == null) {
                    return;
                }
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)files[0]));
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                MessageDialog.openError((Shell)shell, (String)"Error adding files", (String)t.getMessage());
                if (t.getCause() == null && t instanceof CoreException) break block6;
                Activator.logErr(t, "Error adding files", new Object[0]);
            }
        }
    }
}

