/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jdt.ui.actions.AbstractOpenWizardAction;
import org.eclipse.jdt.ui.actions.OpenNewClassWizardAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class NewTypeDropDownAction
extends Action
implements IMenuCreator,
IWorkbenchWindowPulldownDelegate2 {
    private static final String TAG_WIZARD = "wizard";
    private static final String ATT_JAVATYPE = "javatype";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_NAME = "name";
    private static final String TAG_VALUE = "value";
    private static final String PL_NEW = "newWizards";
    private static final String TAG_CLASS = "class";
    private Menu fMenu = null;
    private Shell fWizardShell;

    public NewTypeDropDownAction() {
        this.setMenuCreator(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_class_wizard_action");
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu == null) {
            this.fMenu = new Menu(parent);
            OpenTypeWizardAction[] actions = NewTypeDropDownAction.getActionFromDescriptors();
            int i = 0;
            while (i < actions.length) {
                OpenTypeWizardAction curr = actions[i];
                curr.setShell(this.fWizardShell);
                ActionContributionItem item = new ActionContributionItem((IAction)curr);
                item.fill(this.fMenu, -1);
                ++i;
            }
        }
        return this.fMenu;
    }

    public void run() {
        new OpenNewClassWizardAction().run();
    }

    public static OpenTypeWizardAction[] getActionFromDescriptors() {
        ArrayList<OpenTypeWizardAction> containers = new ArrayList<OpenTypeWizardAction>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals(TAG_WIZARD) && NewTypeDropDownAction.isJavaTypeWizard(element)) {
                    containers.add(new OpenTypeWizardAction(element));
                }
                ++i;
            }
        }
        return containers.toArray(new OpenTypeWizardAction[containers.size()]);
    }

    private static boolean isJavaTypeWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    IConfigurationElement curr = paramElements[k];
                    if (ATT_JAVATYPE.equals(curr.getAttribute(TAG_NAME))) {
                        return Boolean.valueOf(curr.getAttribute(TAG_VALUE));
                    }
                    ++k;
                }
                ++i;
            }
        }
        return Boolean.valueOf(element.getAttribute(ATT_JAVATYPE)) != false;
    }

    public void init(IWorkbenchWindow window) {
        this.fWizardShell = window.getShell();
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static class OpenTypeWizardAction
    extends AbstractOpenWizardAction {
        private static final String ATT_NAME = "name";
        private static final String ATT_CLASS = "class";
        private static final String ATT_ICON = "icon";
        private static final String TAG_DESCRIPTION = "description";
        private IConfigurationElement fConfigurationElement;

        public OpenTypeWizardAction(IConfigurationElement element) {
            this.fConfigurationElement = element;
            this.setText(element.getAttribute("name"));
            String description = this.getDescriptionFromConfig(this.fConfigurationElement);
            this.setDescription(description);
            this.setToolTipText(description);
            this.setImageDescriptor(this.getIconFromConfig(this.fConfigurationElement));
        }

        private String getDescriptionFromConfig(IConfigurationElement config) {
            IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
            if (children.length >= 1) {
                return children[0].getValue();
            }
            return "";
        }

        private ImageDescriptor getIconFromConfig(IConfigurationElement config) {
            String iconName = config.getAttribute(ATT_ICON);
            if (iconName != null) {
                Bundle bundle = Platform.getBundle((String)config.getContributor().getName());
                return JavaPluginImages.createImageDescriptor(bundle, (IPath)new Path(iconName), true);
            }
            return null;
        }

        @Override
        protected INewWizard createWizard() throws CoreException {
            return (INewWizard)CoreUtility.createExtension(this.fConfigurationElement, "class");
        }
    }
}

