/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URL;
import java.security.cert.Certificate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.dialogs.TrustCertificateDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.UserValidationDialog;
import org.eclipse.equinox.internal.p2.ui.viewers.CertificateLabelProvider;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.equinox.p2.ui.LoadMetadataRepositoryJob;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ValidationDialogServiceUI
extends UIServices {
    public UIServices.AuthenticationInfo getUsernamePassword(final String location) {
        final UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication() && !this.isHeadless()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    String message;
                    Shell shell = ProvUI.getDefaultParentShell();
                    UserValidationDialog dialog = new UserValidationDialog(shell, ProvUIMessages.ServiceUI_LoginRequired, null, message = NLS.bind((String)ProvUIMessages.ServiceUI_LoginDetails, (Object)location));
                    int dialogCode = dialog.open();
                    if (dialogCode == 0) {
                        result[0] = dialog.getResult();
                    } else if (dialogCode == 1) {
                        result[0] = AUTHENTICATION_PROMPT_CANCELED;
                    }
                }
            });
        }
        return result[0];
    }

    private boolean suppressAuthentication() {
        Job job = Job.getJobManager().currentJob();
        if (job != null) {
            return job.getProperty(LoadMetadataRepositoryJob.SUPPRESS_AUTHENTICATION_JOB_MARKER) != null;
        }
        return false;
    }

    public UIServices.TrustInfo getTrustInfo(Certificate[][] untrustedChains, String[] unsignedDetail) {
        Object[] result;
        boolean trustUnsigned = true;
        boolean persistTrust = false;
        Certificate[] trusted = new Certificate[]{};
        if (!this.isHeadless() && unsignedDetail != null && unsignedDetail.length > 0) {
            result = new boolean[1];
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable((boolean[])result, unsignedDetail){
                private final /* synthetic */ boolean[] val$result;
                private final /* synthetic */ String[] val$unsignedDetail;
                {
                    this.val$result = blArray;
                    this.val$unsignedDetail = stringArray;
                }

                @Override
                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    OkCancelErrorDialog dialog = new OkCancelErrorDialog(shell, ProvUIMessages.ServiceUI_warning_title, null, this.createStatus(), 2);
                    this.val$result[0] = dialog.open() == 0;
                }

                private IStatus createStatus() {
                    MultiStatus parent = new MultiStatus("org.eclipse.equinox.p2.ui", 0, ProvUIMessages.ServiceUI_unsigned_message, null);
                    int i = 0;
                    while (i < this.val$unsignedDetail.length) {
                        parent.add((IStatus)new Status(2, "org.eclipse.equinox.p2.ui", this.val$unsignedDetail[i]));
                        ++i;
                    }
                    return parent;
                }
            });
            trustUnsigned = result[0];
        }
        if (!trustUnsigned) {
            return new UIServices.TrustInfo(trusted, persistTrust, trustUnsigned);
        }
        if (!this.isHeadless() && untrustedChains != null && untrustedChains.length > 0) {
            result = new Object[1];
            final TreeNode[] input = this.createTreeNodes(untrustedChains);
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    CertificateLabelProvider labelProvider = new CertificateLabelProvider();
                    TreeNodeContentProvider contentProvider = new TreeNodeContentProvider();
                    TrustCertificateDialog trustCertificateDialog = new TrustCertificateDialog(shell, input, labelProvider, (ITreeContentProvider)contentProvider);
                    trustCertificateDialog.open();
                    Certificate[] values = new Certificate[trustCertificateDialog.getResult() == null ? 0 : trustCertificateDialog.getResult().length];
                    int i = 0;
                    while (i < values.length) {
                        values[i] = (Certificate)((TreeNode)trustCertificateDialog.getResult()[i]).getValue();
                        ++i;
                    }
                    result[0] = values;
                }
            });
            persistTrust = true;
            trusted = (Certificate[])result[0];
        }
        return new UIServices.TrustInfo(trusted, persistTrust, trustUnsigned);
    }

    private TreeNode[] createTreeNodes(Certificate[][] certificates) {
        TreeNode[] children = new TreeNode[certificates.length];
        int i = 0;
        while (i < certificates.length) {
            TreeNode head;
            TreeNode parent = head = new TreeNode((Object)certificates[i][0]);
            children[i] = head;
            int j = 0;
            while (j < certificates[i].length) {
                TreeNode node = new TreeNode((Object)certificates[i][j]);
                node.setParent(parent);
                parent.setChildren(new TreeNode[]{node});
                parent = node;
                ++j;
            }
            ++i;
        }
        return children;
    }

    public UIServices.AuthenticationInfo getUsernamePassword(final String location, final UIServices.AuthenticationInfo previousInfo) {
        final UIServices.AuthenticationInfo[] result = new UIServices.AuthenticationInfo[1];
        if (!this.suppressAuthentication() && !this.isHeadless()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    String message = null;
                    message = previousInfo.saveResult() ? NLS.bind((String)ProvUIMessages.ProvUIMessages_SavedNotAccepted_EnterFor_0, (Object)location) : NLS.bind((String)ProvUIMessages.ProvUIMessages_NotAccepted_EnterFor_0, (Object)location);
                    UserValidationDialog dialog = new UserValidationDialog(previousInfo, shell, ProvUIMessages.ServiceUI_LoginRequired, null, message);
                    int dialogCode = dialog.open();
                    if (dialogCode == 0) {
                        result[0] = dialog.getResult();
                    } else if (dialogCode == 1) {
                        result[0] = AUTHENTICATION_PROMPT_CANCELED;
                    }
                }
            });
        }
        return result[0];
    }

    public void showInformationMessage(final String title, final String text, final String linkText) {
        if (this.isHeadless()) {
            super.showInformationMessage(title, text, linkText);
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialogWithLink dialog = new MessageDialogWithLink(ProvUI.getDefaultParentShell(), title, null, text, 2, new String[]{IDialogConstants.OK_LABEL}, 0, linkText);
                dialog.open();
            }
        });
    }

    private boolean isHeadless() {
        return !PlatformUI.isWorkbenchRunning();
    }

    static final class MessageDialogWithLink
    extends MessageDialog {
        private final String linkText;

        MessageDialogWithLink(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String linkText) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
            this.linkText = linkText;
        }

        protected Control createCustomArea(Composite parent) {
            if (this.linkText == null) {
                return super.createCustomArea(parent);
            }
            Link link = new Link(parent, 0);
            link.setText(this.linkText);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        URL url = new URL(e.text);
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(url);
                    }
                    catch (Exception x) {
                        ProvUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.equinox.p2.ui", x.getMessage(), (Throwable)x));
                    }
                }
            });
            return link;
        }
    }

    static class OkCancelErrorDialog
    extends ErrorDialog {
        public OkCancelErrorDialog(Shell parentShell, String dialogTitle, String message, IStatus status, int displayMask) {
            super(parentShell, dialogTitle, message, status, displayMask);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, ProvUIMessages.ServiceUI_InstallAnywayAction_Label, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
            this.createDetailsButton(parent);
        }
    }
}

