/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.p2.P2Fetcher;

public class RepositoryCache {
    private static RepositoryCache instance;
    Map<String, List<UnitNode>> cache = new HashMap<String, List<UnitNode>>();

    private RepositoryCache() {
    }

    public static RepositoryCache getDefault() {
        if (instance == null) {
            instance = new RepositoryCache();
        }
        return instance;
    }

    public List<UnitNode> fetchP2UnitsFromRepo(String repo, boolean flush) {
        if (flush || this.cache.get(repo) == null) {
            List<UnitNode> units = P2Fetcher.fetchAvailableUnits(repo);
            this.cache.put(repo, units);
        }
        return this.cache.get(repo);
    }

    public List<UnitNode> getUnitsByPrefix(String repo, String prefix) {
        List<UnitNode> allUnits = this.fetchP2UnitsFromRepo(repo, false);
        ArrayList<UnitNode> result = new ArrayList<UnitNode>();
        for (UnitNode unit : allUnits) {
            if (!unit.getId().startsWith(prefix)) continue;
            result.add(unit);
        }
        return result;
    }

    public boolean isUpToDate(String repo) {
        return this.cache.get(repo) != null;
    }

    public void flush() {
        this.cache.clear();
    }
}

