/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.rcptt.tesla.internal.ui.player.ChildrenCollectingSession;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.WorkbenchUIElement;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.internal.WorkbenchPartReference;

public class ChildrenCollector {
    private final SWTUIPlayer player;

    public ChildrenCollector(SWTUIPlayer player) {
        this.player = player;
    }

    public SWTUIElement[] collectFor(SWTUIElement w, SWTUIElement[] ignores, boolean goIntoComposites, Class<?>[] classes, SWTUIElement after) {
        if (after instanceof WorkbenchUIElement) {
            after = this.player.wrap(((WorkbenchPartReference)((WorkbenchUIElement)after).reference).getPane().getControl());
        }
        if (after == null) {
            return this.collectFor(w, ignores, goIntoComposites, classes);
        }
        Class<?>[] arg = null;
        SWTUIElement[] widgets = this.collectFor(w, null, goIntoComposites, arg);
        ArrayList<SWTUIElement> results = new ArrayList<SWTUIElement>();
        List<SWTUIElement> list = Arrays.asList(widgets);
        int i = list.indexOf(after);
        if (i != -1) {
            List<SWTUIElement> subList = list.subList(i + 1, list.size());
            for (SWTUIElement widget : subList) {
                ChildrenCollector.addItem(results, widget, ignores, classes);
            }
        }
        return results.toArray(new SWTUIElement[results.size()]);
    }

    public SWTUIElement[] collectFor(SWTUIElement w, SWTUIElement[] ignores, boolean goIntoComposites, Class<?> ... classes) {
        boolean recording = TeslaRecorder.getInstance().hasListeners();
        return this.collectFor(w, ignores, goIntoComposites, recording, classes);
    }

    public SWTUIElement[] collectFor(SWTUIElement w, SWTUIElement[] ignores, boolean goIntoComposites, boolean menuIsShown, Class<?> ... classes) {
        ChildrenCollectingSession ccs = new ChildrenCollectingSession(this.player, this, w, ignores, goIntoComposites, menuIsShown, classes);
        return ccs.collect();
    }

    public static void addItem(List<SWTUIElement> results, SWTUIElement control, SWTUIElement[] ignores, Class<?>[] classes) {
        if (ignores != null) {
            SWTUIElement[] sWTUIElementArray = ignores;
            int n = ignores.length;
            int n2 = 0;
            while (n2 < n) {
                SWTUIElement widget = sWTUIElementArray[n2];
                if (widget.equals(control)) {
                    return;
                }
                ++n2;
            }
        }
        if (classes == null || ChildrenCollector.isInstanceOf(control, classes)) {
            results.add(control);
        }
    }

    private static boolean isInstanceOf(SWTUIElement control, Class<?>[] classes) {
        if (classes != null && classes.length == 0) {
            return true;
        }
        if (classes != null) {
            Class<?>[] classArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> class1 = classArray[n2];
                if (!(class1 == null || class1.equals(Canvas.class) && PlayerWrapUtils.unwrapWidget(control) instanceof CLabel || class1.equals(Canvas.class) && PlayerWrapUtils.unwrapWidget(control).getClass().getName().equals("org.eclipse.ui.forms.widgets.ExpandableComposite") || class1 == null || !class1.isInstance(PlayerWrapUtils.unwrapWidget(control)) && !class1.isInstance(PlayerWrapUtils.unwrap(control)))) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

