/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.StringTokenizer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.ui.correction.AbstractPDEMarkerResolution;

public abstract class AbstractXMLMarkerResolution
extends AbstractPDEMarkerResolution {
    public AbstractXMLMarkerResolution(int resolutionType, IMarker marker) {
        super(resolutionType, marker);
    }

    protected abstract void createChange(IPluginModelBase var1);

    @Override
    protected void createChange(IBaseModel model) {
        if (model instanceof IPluginModelBase) {
            this.createChange((IPluginModelBase)model);
        }
    }

    protected Object findNode(IPluginModelBase base) {
        String locationPath = null;
        try {
            locationPath = (String)this.marker.getAttribute("xmlTree.locationPath");
        }
        catch (CoreException coreException) {}
        if (locationPath == null) {
            return null;
        }
        if (locationPath.charAt(0) != '(' && base instanceof IBundlePluginModelBase) {
            IBundle bundle = ((IBundlePluginModelBase)base).getBundleModel().getBundle();
            return bundle.getManifestHeader(locationPath);
        }
        IDocumentElementNode node = null;
        StringTokenizer strtok = new StringTokenizer(locationPath, Character.toString('>'));
        while (strtok.hasMoreTokens()) {
            int attr;
            String token = strtok.nextToken();
            if (node != null) {
                IDocumentElementNode[] children = node.getChildNodes();
                int childIndex = Integer.parseInt(token.substring(1, token.indexOf(41)));
                if (childIndex >= 0 || childIndex < children.length) {
                    node = children[childIndex];
                }
            } else if (base instanceof IBundlePluginModelBase) {
                ISharedExtensionsModel sharedModel = ((IBundlePluginModelBase)base).getExtensionsModel();
                if (sharedModel instanceof IPluginModelBase) {
                    node = (IDocumentElementNode)((IPluginModelBase)sharedModel).getPluginBase();
                }
            } else {
                node = (IDocumentElementNode)base.getPluginBase();
            }
            if ((attr = token.indexOf(64)) == -1) continue;
            int valueIndex = token.indexOf(33);
            if (valueIndex == -1) {
                return node.getDocumentAttribute(token.substring(attr + 1));
            }
            return node.getDocumentAttribute(token.substring(attr + 1, valueIndex));
        }
        return node;
    }

    protected String getNameOfNode() {
        String fLocationPath = null;
        try {
            fLocationPath = (String)this.marker.getAttribute("xmlTree.locationPath");
        }
        catch (CoreException coreException) {}
        int lastChild = fLocationPath.lastIndexOf(41);
        if (lastChild < 0) {
            return fLocationPath;
        }
        String item = fLocationPath.substring(lastChild + 1);
        if ((lastChild = item.indexOf(64)) == -1) {
            return item;
        }
        int valueIndex = item.indexOf(33);
        if (valueIndex == -1) {
            return item.substring(lastChild + 1);
        }
        return item.substring(valueIndex + 1);
    }

    protected boolean isAttrNode() {
        String fLocationPath = null;
        try {
            fLocationPath = (String)this.marker.getAttribute("xmlTree.locationPath");
        }
        catch (CoreException coreException) {}
        return fLocationPath.indexOf(64) != -1;
    }
}

