/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.debug.ui;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.debug.ui.ContentProvider;
import org.eclipse.rcptt.debug.Collection;
import org.eclipse.rcptt.debug.DebugContext;
import org.eclipse.rcptt.debug.DebugFactory;
import org.eclipse.rcptt.debug.DebugPackage;
import org.eclipse.rcptt.debug.MapValue;
import org.eclipse.rcptt.debug.PrimitiveValue;
import org.eclipse.rcptt.ecl.runtime.BoxedValues;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.IEmbeddedComposite;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.controls.SectionWithToolbar;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class DebugContextEditor
extends BaseContextEditor {
    TreeViewer viewer;

    public DebugContext getContextElement() {
        try {
            return (DebugContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public void copyContentFrom(Context context, IProgressMonitor monitor) throws CoreException {
        super.copyContentFrom(context, monitor);
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                DebugContextEditor.this.viewer.refresh(true);
            }
        });
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = new SectionWithComposite("Options", 322).grabVertical(false).create(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)section);
        Composite composite = (Composite)section.getClient();
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(composite);
        Button noLaunches = toolkit.createButton(composite, "Terminate existing launches", 32);
        IObservableValue emfObservable = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)DebugPackage.Literals.DEBUG_CONTEXT__NO_LAUNCHES);
        ISWTObservableValue noLaunchesSelection = WidgetProperties.buttonSelection().observe((Widget)noLaunches);
        this.dbc.bindValue((IObservableValue)noLaunchesSelection, emfObservable);
        toolkit.createLabel(composite, "Do not terminate launches of following configurations:");
        Text exceptionsText = toolkit.createText(composite, "", 2048);
        GridDataFactory.fillDefaults().hint(300, -1).applyTo((Control)exceptionsText);
        IObservableValue launchesToLeaveRunning = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)DebugPackage.Literals.DEBUG_CONTEXT__LAUNCH_EXCEPTIONS);
        ISWTObservableValue launchErrorText = WidgetProperties.text((int)24).observe((Widget)exceptionsText);
        this.dbc.bindValue((IObservableValue)launchErrorText, launchesToLeaveRunning);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)exceptionsText), (IObservableValue)noLaunchesSelection);
        Button noLaunchShortcuts = toolkit.createButton(composite, "Clear launch configurations", 32);
        IObservableValue noLaunchShortcutsValue = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)DebugPackage.Literals.DEBUG_CONTEXT__NO_LAUNCH_SHORTCUTS);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)noLaunchShortcuts), noLaunchShortcutsValue);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        toolkit.createLabel(composite, "Do not delete following configurations:");
        exceptionsText = toolkit.createText(composite, "", 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)exceptionsText);
        IObservableValue launchShortcutToLeave = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)DebugPackage.Literals.DEBUG_CONTEXT__LAUNCH_SHORTCUT_EXCEPTIONS);
        launchErrorText = WidgetProperties.text((int)24).observe((Widget)exceptionsText);
        this.dbc.bindValue((IObservableValue)launchErrorText, launchShortcutToLeave);
        this.dbc.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)exceptionsText), (IObservableValue)WidgetProperties.buttonSelection().observe((Widget)noLaunchShortcuts));
        Button noBreakpoints = toolkit.createButton(composite, "Clear breakpoints", 32);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)noBreakpoints);
        IObservableValue noBreakpointsValue = EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)DebugPackage.Literals.DEBUG_CONTEXT__NO_BREAKPOINTS);
        this.dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)noBreakpoints), noBreakpointsValue);
        Section section5 = new SectionWithToolbar((IEmbeddedComposite)new EditableTree("Launch configurations", new ContentProvider()), 322).create(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section5);
        return section;
    }

    private class EditableTree
    extends AbstractEmbeddedComposite {
        final String name;
        final Image image;
        Tree tree;
        final ContentProvider contentProvider;
        private final Action addTool = new Action(){
            {
                this.setText(Messages.EObjectTable_Add);
                this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_ADD"));
                this.setEnabled(false);
            }

            public void run() {
                Collection expandable = EditableTree.this.getSelectedExpandable();
                if (expandable == null) {
                    return;
                }
                PrimitiveValue value = DebugFactory.eINSTANCE.createPrimitiveValue();
                if (expandable instanceof MapValue) {
                    value.setName("New element");
                }
                value.setValue((EObject)BoxedValues.box((String)""));
                expandable.getEntries().add((Object)value);
                ((EditableTree)EditableTree.this).DebugContextEditor.this.viewer.refresh((Object)expandable, true);
                ((EditableTree)EditableTree.this).DebugContextEditor.this.viewer.editElement((Object)value, 1);
            }
        };
        private final Action removeTool = new Action(){
            {
                this.setText(Messages.EObjectTable_Remove);
                this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE"));
                this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE_DISABLED"));
                this.setEnabled(false);
            }

            public void run() {
                IStructuredSelection selection = (IStructuredSelection)((EditableTree)EditableTree.this).DebugContextEditor.this.viewer.getSelection();
                Object toSelect = null;
                for (Object o : selection.toList()) {
                    Object parent;
                    if (!EditableTree.this.contentProvider.isRemovable(o)) continue;
                    toSelect = parent = EditableTree.this.contentProvider.getParent(o);
                    if (parent != null) {
                        Object[] children = EditableTree.this.contentProvider.getChildren(parent);
                        int position = 0;
                        while (position < children.length) {
                            if (children[position] == o) {
                                if (position - 1 >= 0) {
                                    toSelect = children[position - 1];
                                    break;
                                }
                                if (position + 1 >= children.length) break;
                                toSelect = children[position + 1];
                                break;
                            }
                            ++position;
                        }
                    }
                    EditableTree.this.contentProvider.remove(o);
                    ((EditableTree)EditableTree.this).DebugContextEditor.this.viewer.refresh();
                }
                if (toSelect != null) {
                    ((EditableTree)EditableTree.this).DebugContextEditor.this.viewer.setSelection((ISelection)new StructuredSelection(toSelect));
                }
            }
        };

        public EditableTree(String name, ContentProvider contentProvider) {
            this.name = name;
            this.contentProvider = contentProvider;
            this.image = null;
        }

        public String getName() {
            return this.name;
        }

        private Collection getSelectedExpandable() {
            IStructuredSelection selection = (IStructuredSelection)DebugContextEditor.this.viewer.getSelection();
            Object o = selection.getFirstElement();
            while (o != null) {
                if (o instanceof Collection) {
                    return (Collection)o;
                }
                o = this.contentProvider.getParent(o);
            }
            return null;
        }

        public void createControl(Composite parent) {
            Tree tree = new Tree(parent, 67586);
            tree.setHeaderVisible(true);
            tree.setLinesVisible(true);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
            DebugContextEditor.this.viewer = new TreeViewer(tree);
            this.contentProvider.install(DebugContextEditor.this.viewer);
            DebugContextEditor.this.viewer.setInput((Object)DebugContextEditor.this.getContextElement());
            DebugContextEditor.this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    EditableTree.this.addTool.setEnabled(EditableTree.this.getSelectedExpandable() != null);
                    boolean removable = false;
                    if (event.getSelection() instanceof IStructuredSelection) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        for (Object o : selection.toList()) {
                            if (!EditableTree.this.contentProvider.isRemovable(o)) continue;
                            removable = true;
                            break;
                        }
                    }
                    EditableTree.this.removeTool.setEnabled(removable);
                }
            });
        }

        public Control getControl() {
            return this.tree;
        }

        protected void fillActions(IToolBarManager manager) {
            manager.add((IAction)this.addTool);
            manager.add((IAction)this.removeTool);
        }

        public Image getImage() {
            return this.image;
        }
    }
}

