/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check.ui.dialogs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.emf.check.catalog.Catalog;
import org.eclipse.sphinx.emf.check.catalog.Category;
import org.eclipse.sphinx.emf.check.catalog.CheckCatalogFactory;
import org.eclipse.sphinx.emf.check.ui.internal.messages.Messages;

public class CategorySelectionContentProvider
implements IStructuredContentProvider {
    private Category otherCategory;
    private Category intrinsicChecksCategory;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> elements = new ArrayList<Object>();
        Collection checkCatalogs = CheckValidatorRegistry.INSTANCE.getCheckCatalogs();
        HashMap<String, Category> categories = new HashMap<String, Category>();
        for (Catalog catalog : checkCatalogs) {
            for (Category category : catalog.getCategories()) {
                categories.put(category.getId(), category);
            }
        }
        elements.addAll(categories.values());
        elements.add(this.getIntrinsicChecksCategory());
        elements.add(this.getOtherCategory());
        return elements.toArray(new Category[elements.size()]);
    }

    public void dispose() {
    }

    protected Category getOtherCategory() {
        if (this.otherCategory == null) {
            this.otherCategory = this.createCategory("org.eclipse.sphinx.emf.check.categories.other", Messages.other_category_label, Messages.other_category_desc);
        }
        return this.otherCategory;
    }

    protected Category getIntrinsicChecksCategory() {
        if (this.intrinsicChecksCategory == null) {
            this.intrinsicChecksCategory = this.createCategory("org.eclipse.sphinx.emf.check.categories.intrinsic", Messages.intrinsic_model_integrity_checks_category_label, Messages.intrinsic_model_integrity_checks_category_desc);
        }
        return this.intrinsicChecksCategory;
    }

    private Category createCategory(String id, String label, String desc) {
        Category category = CheckCatalogFactory.eINSTANCE.createCategory();
        category.setId(id);
        category.setLabel(label);
        category.setDescription(desc);
        return category;
    }
}

