/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.ecore.proxymanagement.IProxyResolverService;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelper;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelperAdapterFactory;
import org.eclipse.sphinx.emf.internal.messages.Messages;
import org.eclipse.sphinx.emf.internal.resource.ResourceProblemMarkerService;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.metamodel.services.DefaultMetaModelServiceProvider;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.resource.ContextAwareProxyURIHelper;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSet;
import org.eclipse.sphinx.emf.resource.ProxyURIIntegrityException;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ExtendedResourceSetImpl
extends ResourceSetImpl
implements ExtendedResourceSet {
    protected final ContextAwareProxyURIHelper contextAwareProxyURIHelper;
    protected final ProxyHelper proxyHelper;

    public ExtendedResourceSetImpl() {
        this.uriResourceMap = new WeakHashMap();
        this.contextAwareProxyURIHelper = this.createContextAwareURIHelper();
        this.proxyHelper = this.createProxyHelper();
    }

    protected ContextAwareProxyURIHelper createContextAwareURIHelper() {
        return new ContextAwareProxyURIHelper();
    }

    protected ProxyHelper createProxyHelper() {
        return ProxyHelperAdapterFactory.INSTANCE.adapt((Notifier)this);
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource delegatedResource;
        URI normalizedURI;
        URIConverter uriConverter;
        Assert.isNotNull((Object)uri);
        uri = this.trimProxyContextInfo(uri.trimFragment());
        if (this.resourceLocator != null) {
            return this.resourceLocator.getResource(uri, loadOnDemand);
        }
        Map map = this.getURIResourceMap();
        if (map != null) {
            Resource resource = (Resource)map.get(uri);
            if (resource != null) {
                if (loadOnDemand && !resource.isLoaded()) {
                    this.demandLoadHelper(resource);
                }
                return resource;
            }
            uriConverter = this.getURIConverter();
            normalizedURI = uriConverter.normalize(uri);
            resource = (Resource)map.get(normalizedURI);
            if (resource != null) {
                map.put(uri, resource);
                if (loadOnDemand && !resource.isLoaded()) {
                    this.demandLoadHelper(resource);
                }
                return resource;
            }
        }
        if ((delegatedResource = this.delegatedGetResource(uri, loadOnDemand)) != null) {
            if (map != null) {
                map.put(uri, delegatedResource);
                uriConverter = this.getURIConverter();
                normalizedURI = uriConverter.normalize(uri);
                map.put(normalizedURI, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            Resource resource = this.demandCreateResource(uri);
            if (resource == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource);
            return resource;
        }
        return null;
    }

    protected Resource demandCreateResource(URI uri) {
        String contentTypeId = EcoreResourceUtil.getContentTypeId(uri);
        return this.createResource(uri, contentTypeId);
    }

    protected void demandLoad(Resource resource) throws IOException {
        ArrayList creationErrors = new ArrayList(resource.getErrors());
        ArrayList creationWarnings = new ArrayList(resource.getWarnings());
        super.demandLoad(resource);
        resource.getErrors().addAll(creationErrors);
        resource.getWarnings().addAll(creationWarnings);
    }

    public EList<Resource> getResources() {
        if (this.resources == null) {
            this.resources = new ExtendedResourcesEList();
        }
        return this.resources;
    }

    public int getModCount() {
        return ((ExtendedResourcesEList)this.getResources()).getModCount();
    }

    @Override
    public void augmentToContextAwareProxy(EObject proxy, Resource contextResource) {
        this.contextAwareProxyURIHelper.augmentToContextAwareProxy(proxy, contextResource);
    }

    @Override
    public URI trimProxyContextInfo(URI proxyURI) {
        return this.contextAwareProxyURIHelper.trimProxyContextInfo(proxyURI);
    }

    @Override
    public boolean canResolve(EClass type) {
        return true;
    }

    @Override
    public boolean canResolve(EObject proxy) {
        return true;
    }

    @Override
    public EObject getEObject(URI uri, boolean loadOnDemand) {
        URI contextURI;
        EObject resolvedEObject;
        if (uri == null) {
            return null;
        }
        String targetMMDescriptorId = this.contextAwareProxyURIHelper.getTargetMetaModelDescriptorId(uri);
        IMetaModelDescriptor targetMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(targetMMDescriptorId);
        IProxyResolverService proxyResolverService = this.getProxyResolverService(targetMMDescriptor);
        if (proxyResolverService != null) {
            return proxyResolverService.getEObject(uri, loadOnDemand);
        }
        if (this.proxyHelper != null) {
            if (this.proxyHelper.getBlackList().existsProxyURI(uri)) {
                return null;
            }
            if (uri.segmentCount() == 0) {
                EObject resolvedEObject2;
                if (this.proxyHelper.getLookupResolver().isAvailable() && (resolvedEObject2 = this.proxyHelper.getLookupResolver().get(uri)) != null) {
                    return resolvedEObject2;
                }
                if (this.proxyHelper.isIgnoreFragmentBasedProxies()) {
                    return null;
                }
            }
        }
        if ((resolvedEObject = this.getEObject(uri, targetMMDescriptor, contextURI = this.contextAwareProxyURIHelper.getContextURI(uri), loadOnDemand)) != null) {
            return resolvedEObject;
        }
        ResourceSet otherResourceSet = this.getDelegateResourceSet(targetMMDescriptor, contextURI);
        if (otherResourceSet != null && otherResourceSet != this) {
            if (loadOnDemand) {
                this.loadModels(targetMMDescriptor, contextURI);
            }
            return otherResourceSet.getEObject(uri, true);
        }
        if (this.proxyHelper != null) {
            this.proxyHelper.getBlackList().addProxyURI(uri);
        }
        return null;
    }

    @Override
    public EObject getEObject(EObject proxy, EObject contextObject, boolean loadOnDemand) {
        EObject resolvedEObject;
        if (proxy == null) {
            return null;
        }
        IMetaModelDescriptor targetMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(proxy);
        IProxyResolverService proxyResolverService = this.getProxyResolverService(targetMMDescriptor);
        if (proxyResolverService != null) {
            return proxyResolverService.getEObject(proxy, contextObject, loadOnDemand);
        }
        URI uri = ((InternalEObject)proxy).eProxyURI();
        if (this.proxyHelper != null) {
            if (this.proxyHelper.getBlackList().existsProxyURI(uri)) {
                return null;
            }
            if (uri.segmentCount() == 0) {
                if (this.proxyHelper.getLookupResolver().isAvailable() && (resolvedEObject = this.proxyHelper.getLookupResolver().get(uri)) != null) {
                    return resolvedEObject;
                }
                if (this.proxyHelper.isIgnoreFragmentBasedProxies()) {
                    return null;
                }
            }
        }
        if ((resolvedEObject = this.getEObject(uri, targetMMDescriptor, contextObject, loadOnDemand)) != null) {
            return resolvedEObject;
        }
        ResourceSet otherResourceSet = this.getDelegateResourceSet(targetMMDescriptor, contextObject);
        if (otherResourceSet != null && otherResourceSet != this) {
            if (loadOnDemand) {
                this.loadModels(targetMMDescriptor, contextObject);
            }
            if (otherResourceSet instanceof ExtendedResourceSet) {
                ExtendedResourceSet extendedOtherResourceSet = (ExtendedResourceSet)otherResourceSet;
                return extendedOtherResourceSet.getEObject(proxy, contextObject, true);
            }
            return otherResourceSet.getEObject(((InternalEObject)proxy).eProxyURI(), true);
        }
        if (this.proxyHelper != null) {
            this.proxyHelper.getBlackList().addProxyURI(uri);
        }
        return null;
    }

    protected EObject getEObject(URI uri, IMetaModelDescriptor targetMetaModelDescriptor, Object contextObject, boolean loadOnDemand) {
        Assert.isNotNull((Object)uri);
        if (uri.segmentCount() == 0) {
            List<Resource> resources = this.getResourcesToSearchIn((List<Resource>)this.getResources(), uri, targetMetaModelDescriptor);
            return this.safeFindEObjectInResources(resources, uri, loadOnDemand);
        }
        Resource resource = this.safeGetResource(uri, loadOnDemand);
        if (resource != null) {
            return this.safeGetEObjectFromResource(resource, uri.fragment());
        }
        return null;
    }

    protected List<Resource> getResourcesToSearchIn(List<Resource> allResources, URI uri, final IMetaModelDescriptor targetMetaModelDescriptor) {
        Assert.isNotNull(allResources);
        if (targetMetaModelDescriptor != null) {
            return this.getFilteredResources(allResources, new ResourceFilter(){

                @Override
                public boolean accept(Resource resource) {
                    return targetMetaModelDescriptor.equals(MetaModelDescriptorRegistry.INSTANCE.getDescriptor(resource));
                }
            });
        }
        return allResources;
    }

    protected List<Resource> getFilteredResources(List<Resource> allResources, ResourceFilter resourceFilter) {
        Assert.isNotNull(allResources);
        Assert.isNotNull((Object)resourceFilter);
        ArrayList<Resource> filteredResources = new ArrayList<Resource>();
        for (Resource resource : allResources) {
            if (!resourceFilter.accept(resource)) continue;
            filteredResources.add(resource);
        }
        return filteredResources;
    }

    protected EObject safeFindEObjectInResources(List<Resource> resources, URI uri, boolean loadOnDemand) {
        if (uri == null) {
            return null;
        }
        HashSet<Resource> resourcesWithProblems = new HashSet<Resource>();
        EObject resolvedEObject = null;
        for (Resource resource : resources) {
            try {
                EObject eObject = resource.getEObject(uri.fragment());
                if (eObject == null) continue;
                resolvedEObject = eObject;
                break;
            }
            catch (Exception ex) {
                resource.getErrors().add((Object)new ProxyURIIntegrityException(NLS.bind((String)Messages.error_problemOccurredWhenResolvingProxyURI, (Object)uri), ex));
                resourcesWithProblems.add(resource);
            }
        }
        ResourceProblemMarkerService.INSTANCE.addProblemMarkers(resourcesWithProblems, null);
        return resolvedEObject;
    }

    protected Resource safeGetResource(URI uri, boolean loadOnDemand) {
        Assert.isNotNull((Object)uri);
        Resource resource = this.getResource(uri, false);
        if ((resource == null || !resource.isLoaded()) && loadOnDemand) {
            try {
                resource = this.getResource(uri, true);
            }
            catch (Exception ex) {
                try {
                    resource = this.getResource(uri, false);
                    if (resource != null) {
                        if (resource.getContents().isEmpty()) {
                            EcoreResourceUtil.unloadResource(resource, true);
                        }
                        if (EcoreResourceUtil.exists(resource.getURI())) {
                            Throwable cause = ex.getCause();
                            if (cause instanceof XMIException) {
                                resource.getErrors().add((Object)((XMIException)cause));
                            } else {
                                Exception causeEx = cause instanceof Exception ? (Exception)cause : null;
                                resource.getErrors().add((Object)new XMIException(NLS.bind((String)Messages.error_problemOccurredWhenLoadingResource, (Object)resource.getURI().toString()), causeEx, resource.getURI().toString(), 1, 1));
                            }
                        }
                    } else {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                    }
                }
                catch (Exception exception) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                }
            }
        }
        return resource;
    }

    protected EObject safeGetEObjectFromResource(Resource resource, String uriFragment) {
        Assert.isNotNull((Object)resource);
        if (resource.isLoaded() && uriFragment != null) {
            try {
                return resource.getEObject(uriFragment);
            }
            catch (Exception ex) {
                resource.getErrors().add((Object)new ProxyURIIntegrityException(NLS.bind((String)Messages.error_problemOccurredWhenResolvingProxyURI, (Object)uriFragment), ex));
                ResourceProblemMarkerService.INSTANCE.addProblemMarkers(resource, null);
            }
        }
        return null;
    }

    protected ResourceSet getDelegateResourceSet(IMetaModelDescriptor metaModelDescriptor, Object contextObject) {
        IContainer contextContainer = this.getContextContainer(contextObject);
        TransactionalEditingDomain otherEditingDomain = WorkspaceEditingDomainUtil.getEditingDomain(contextContainer, metaModelDescriptor);
        if (otherEditingDomain != null) {
            return otherEditingDomain.getResourceSet();
        }
        return null;
    }

    protected void loadModels(IMetaModelDescriptor metaModelDescriptor, Object contextObject) {
        IContainer contextContainer = this.getContextContainer(contextObject);
        if (contextContainer != null) {
            Collection<IModelDescriptor> targetModelDescriptors = ModelDescriptorRegistry.INSTANCE.getModels(contextContainer, metaModelDescriptor);
            Iterator<IModelDescriptor> iter = targetModelDescriptors.iterator();
            while (iter.hasNext()) {
                if (!EcorePlatformUtil.isModelLoaded(iter.next())) continue;
                iter.remove();
            }
            EcorePlatformUtil.loadModels(targetModelDescriptors, false, null);
        }
    }

    protected IContainer getContextContainer(Object contextObject) {
        IFile contextFile;
        if (contextObject instanceof URI) {
            URI contextURI = (URI)contextObject;
            if (contextURI.isPlatformResource()) {
                Path contextPath = new Path(contextURI.toPlatformString(true));
                IResource contextResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)contextPath);
                if (contextResource != null) {
                    if (contextResource instanceof IContainer) {
                        return (IContainer)contextResource;
                    }
                    return contextResource.getParent();
                }
            }
        } else if (contextObject instanceof EObject && (contextFile = EcorePlatformUtil.getFile((EObject)contextObject)) != null) {
            return contextFile.getParent();
        }
        return null;
    }

    protected IProxyResolverService getProxyResolverService(IMetaModelDescriptor descriptor) {
        if (descriptor != null) {
            return new DefaultMetaModelServiceProvider().getService(descriptor, IProxyResolverService.class);
        }
        return null;
    }

    protected class ExtendedResourcesEList<E>
    extends ResourceSetImpl.ResourcesEList<E> {
        private static final long serialVersionUID = 1L;

        protected ExtendedResourcesEList() {
            super((ResourceSetImpl)ExtendedResourceSetImpl.this);
        }

        protected int getModCount() {
            return this.modCount;
        }

        protected void didAdd(int index, E newObject) {
            super.didAdd(index, newObject);
            Map map = ExtendedResourceSetImpl.this.getURIResourceMap();
            if (map != null) {
                URI uri = ((Resource)newObject).getURI();
                map.put(uri, newObject);
                URIConverter uriConverter = ExtendedResourceSetImpl.this.getURIConverter();
                URI normalizedURI = uriConverter.normalize(uri);
                map.put(normalizedURI, newObject);
            }
        }

        protected void didRemove(int index, E oldObject) {
            Map map = ExtendedResourceSetImpl.this.getURIResourceMap();
            if (map != null) {
                URI uri = ((Resource)oldObject).getURI();
                map.remove(uri);
                URIConverter uriConverter = ExtendedResourceSetImpl.this.getURIConverter();
                URI normalizedURI = uriConverter.normalize(uri);
                map.remove(normalizedURI);
            }
            super.didRemove(index, oldObject);
        }

        protected void didSet(int index, E newObject, E oldObject) {
            URI normalizedURI;
            URIConverter uriConverter;
            URI uri;
            Map map = ExtendedResourceSetImpl.this.getURIResourceMap();
            if (newObject != null) {
                super.didSet(index, newObject, oldObject);
                if (map != null) {
                    uri = ((Resource)newObject).getURI();
                    map.put(uri, newObject);
                    uriConverter = ExtendedResourceSetImpl.this.getURIConverter();
                    normalizedURI = uriConverter.normalize(uri);
                    map.put(normalizedURI, newObject);
                }
            }
            if (oldObject != null) {
                if (map != null) {
                    uri = ((Resource)oldObject).getURI();
                    map.remove(uri);
                    uriConverter = ExtendedResourceSetImpl.this.getURIConverter();
                    normalizedURI = uriConverter.normalize(uri);
                    map.remove(normalizedURI);
                }
                super.didSet(index, newObject, oldObject);
            }
        }

        protected void didClear(int size, Object[] oldObjects) {
            Map map = ExtendedResourceSetImpl.this.getURIResourceMap();
            if (map != null) {
                map.clear();
            }
            super.didClear(size, oldObjects);
        }
    }

    protected static interface ResourceFilter {
        public boolean accept(Resource var1);
    }
}

