/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.editor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.configuration.EMFCompareConfiguration;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeEditorInput;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.compare.domain.DelegatingEMFCompareEditingDomain;
import org.eclipse.sphinx.emf.compare.scope.IModelComparisonScope;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelCompareEditor;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.compare.util.ModelCompareUtil;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.loading.ModelLoadManager;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.navigator.SaveablesProvider;

public class ModelComparisonScopeEditorInput
extends ComparisonScopeEditorInput
implements ISaveablesSource {
    protected SaveablesProvider modelSaveablesProvider;
    private final IComparisonScope scope;
    private Object leftObject;
    private Object rightObject;
    private Resource leftResource;
    private Resource rightResource;

    public ModelComparisonScopeEditorInput(EMFCompareConfiguration configuration, ICompareEditingDomain editingDomain, AdapterFactory adapterFactory, EMFCompare comparator, IComparisonScope scope) {
        super(configuration, editingDomain, adapterFactory, comparator, scope);
        this.scope = scope;
    }

    public IComparisonScope getScope() {
        return this.scope;
    }

    public Resource getLeftResource() {
        return this.leftResource;
    }

    public Resource getRightResource() {
        return this.rightResource;
    }

    public boolean isDirty() {
        boolean isDirty = false;
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(this.getLeftObject());
        selectedObjects.add(this.getRightObject());
        int i = 0;
        while (i < selectedObjects.size()) {
            Object object = selectedObjects.get(i);
            Resource resource = null;
            if (object instanceof EObject) {
                resource = ((EObject)object).eResource();
            } else if (object instanceof Resource) {
                resource = (Resource)object;
            } else if (object instanceof IFile) {
                Resource resource2 = resource = i == 0 ? this.leftResource : this.rightResource;
            }
            if (resource != null) {
                isDirty = isDirty || ModelSaveManager.INSTANCE.isDirty(resource);
            }
            ++i;
        }
        return isDirty;
    }

    protected void init() {
        if (this.modelSaveablesProvider == null) {
            this.modelSaveablesProvider = this.createModelSaveablesProvider();
            if (this.getWorkbenchPart() instanceof ModelCompareEditor) {
                ISaveablesLifecycleListener modelSaveablesLifecycleListener = ((ModelCompareEditor)this.getWorkbenchPart()).createModelSaveablesLifecycleListener();
                this.modelSaveablesProvider.init(modelSaveablesLifecycleListener);
            } else if (this.getWorkbenchPart() == null) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new NullPointerException(Messages.warning_workbenchPartNull));
            } else {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)new RuntimeException(Messages.warning_workbenchPartInstanceofModelCompareEditor));
            }
        }
    }

    public Object getLeftObject() {
        if (this.scope instanceof IModelComparisonScope) {
            if (((IModelComparisonScope)this.scope).isFileBasedComparison()) {
                if (this.leftObject == null) {
                    this.leftObject = ((IModelComparisonScope)this.scope).getLeftFile();
                }
            } else if (this.leftObject == null || this.leftObject instanceof EObject && (((EObject)this.leftObject).eIsProxy() || ((EObject)this.leftObject).eResource() == null || !((EObject)this.leftObject).eResource().isLoaded())) {
                this.leftObject = this.scope.getLeft();
            }
        }
        return this.leftObject;
    }

    public Object getRightObject() {
        if (this.scope instanceof IModelComparisonScope) {
            if (((IModelComparisonScope)this.scope).isFileBasedComparison()) {
                if (this.rightObject == null) {
                    this.rightObject = ((IModelComparisonScope)this.scope).getRightFile();
                }
            } else if (this.rightObject == null || this.rightObject instanceof EObject && (((EObject)this.rightObject).eIsProxy() || ((EObject)this.rightObject).eResource() == null || !((EObject)this.rightObject).eResource().isLoaded())) {
                this.rightObject = this.scope.getRight();
            }
        }
        return this.rightObject;
    }

    protected SaveablesProvider createModelSaveablesProvider() {
        return new BasicModelSaveablesProvider();
    }

    protected Object doPrepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.init();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.scope instanceof IModelComparisonScope && ((IModelComparisonScope)this.scope).isFileBasedComparison()) {
            this.loadModel((IModelComparisonScope)this.scope, (IProgressMonitor)progress.newChild(50));
            ((IModelComparisonScope)this.scope).setDelegate((IComparisonScope)new DefaultComparisonScope((Notifier)this.leftResource, (Notifier)this.rightResource, null));
            EMFCompareConfiguration compareConfiguration = this.getCompareConfiguration();
            ICompareEditingDomain editingDomain = compareConfiguration.getEditingDomain();
            if (editingDomain instanceof DelegatingEMFCompareEditingDomain) {
                ICompareEditingDomain delegatingEditingDomain = ModelCompareUtil.createEMFCompareEditingDomain((Object)this.leftResource, (Object)this.rightResource, null);
                ((DelegatingEMFCompareEditingDomain)editingDomain).setDelegate(delegatingEditingDomain);
            }
        } else {
            progress.worked(50);
        }
        Object input = super.doPrepareInput((IProgressMonitor)progress.newChild(50));
        String leftLabel = this.getLabel(this.getLeftObject());
        String rightLabel = this.getLabel(this.getRightObject());
        String ancestorLabel = this.getAncestorLabel();
        String title = ancestorLabel == null ? NLS.bind((String)Messages.twoWay_title, (Object)leftLabel, (Object)rightLabel) : NLS.bind((String)Messages.threeWay_title, (Object[])new String[]{ancestorLabel, leftLabel, rightLabel});
        this.setTitle(title);
        return input;
    }

    protected void loadModel(IModelComparisonScope comparisonScope, IProgressMonitor monitor) {
        if (comparisonScope != null && comparisonScope.isFileBasedComparison()) {
            IFile rightFile;
            HashSet<IFile> sphinxModelFiles = new HashSet<IFile>();
            ResourceSetImpl nonSphinxModelResouceSet = new ResourceSetImpl();
            IFile leftFile = comparisonScope.getLeftFile();
            if (leftFile != null) {
                if (ModelDescriptorRegistry.INSTANCE.isModelFile(leftFile)) {
                    sphinxModelFiles.add(leftFile);
                } else {
                    this.leftResource = EcoreResourceUtil.loadResource((ResourceSet)nonSphinxModelResouceSet, (URI)EcorePlatformUtil.createURI((IPath)leftFile.getFullPath()), this.getLoadOptions());
                }
            }
            if ((rightFile = comparisonScope.getRightFile()) != null) {
                if (ModelDescriptorRegistry.INSTANCE.isModelFile(rightFile)) {
                    sphinxModelFiles.add(rightFile);
                } else {
                    this.rightResource = EcoreResourceUtil.loadResource((ResourceSet)nonSphinxModelResouceSet, (URI)EcorePlatformUtil.createURI((IPath)rightFile.getFullPath()), this.getLoadOptions());
                }
            }
            ModelLoadManager.INSTANCE.loadFiles(sphinxModelFiles, false, monitor);
            if (this.leftResource == null) {
                this.leftResource = EcorePlatformUtil.getResource((IFile)leftFile);
            }
            if (this.rightResource == null) {
                this.rightResource = EcorePlatformUtil.getResource((IFile)rightFile);
            }
        }
    }

    protected String getLabel(Object object) {
        String label = "";
        if (object instanceof EObject) {
            URI uri = EcoreResourceUtil.getURI((EObject)((EObject)object), (boolean)true);
            label = uri.trimQuery().toString();
        } else if (object instanceof IFile) {
            label = ((IFile)object).getName();
        }
        return label;
    }

    protected String getAncestorLabel() {
        return null;
    }

    public void saveChanges(IProgressMonitor monitor) {
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        selectedObjects.add(this.getLeftObject());
        selectedObjects.add(this.getRightObject());
        int i = 0;
        while (i < selectedObjects.size()) {
            Resource resource = null;
            Object object = selectedObjects.get(i);
            if (object instanceof EObject) {
                resource = ((EObject)object).eResource();
            } else if (object instanceof IFile) {
                Resource resource2 = resource = i == 0 ? this.leftResource : this.rightResource;
            }
            if (resource != null) {
                ModelSaveManager.INSTANCE.saveModel(resource, this.getSaveOptions(), false, monitor);
            }
            ++i;
        }
    }

    protected Map<?, ?> getLoadOptions() {
        return EcoreResourceUtil.getDefaultLoadOptions();
    }

    protected Map<?, ?> getSaveOptions() {
        return EcoreResourceUtil.getDefaultSaveOptions();
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public Saveable[] getSaveables() {
        HashSet<Saveable> saveables = new HashSet<Saveable>();
        if (this.modelSaveablesProvider != null) {
            Saveable rightSaveable;
            Saveable leftSaveable;
            if (this.getLeftObject() != null && (leftSaveable = this.modelSaveablesProvider.getSaveable(this.getLeftObject())) != null) {
                saveables.add(leftSaveable);
            }
            if (this.getRightObject() != null && (rightSaveable = this.modelSaveablesProvider.getSaveable(this.getRightObject())) != null) {
                saveables.add(rightSaveable);
            }
        }
        return saveables.toArray(new Saveable[saveables.size()]);
    }

    protected void finalize() throws Throwable {
        if (this.modelSaveablesProvider != null) {
            this.modelSaveablesProvider.dispose();
            this.modelSaveablesProvider = null;
        }
        super.finalize();
    }

    protected void handleDispose() {
        super.handleDispose();
        ICompareEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain instanceof IDisposable) {
            ((IDisposable)editingDomain).dispose();
        }
    }
}

