/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractLoadOperation;

public abstract class AbstractFileLoadOperation
extends AbstractLoadOperation {
    private Set<IFile> files = Collections.synchronizedSet(new HashSet());

    public AbstractFileLoadOperation(String label, Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        super(label, mmDescriptor);
        this.addFiles(files);
    }

    public ISchedulingRule getRule() {
        return this.getSchedulingRuleFactory().createLoadSchedulingRule(this.getFiles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IFile> getFiles() {
        Set<IFile> set = this.files;
        synchronized (set) {
            return Collections.unmodifiableSet(new HashSet<IFile>(this.files));
        }
    }

    @Override
    public boolean covers(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        return false;
    }

    @Override
    public boolean covers(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        int filesComparison = this.compare(this.getFiles(), files);
        int mmDescriptorsComparison = this.compare(this.getMetaModelDescriptor(), mmDescriptor);
        return filesComparison == EQUAL ? mmDescriptorsComparison == EQUAL || mmDescriptorsComparison == GREATER_THAN : filesComparison == GREATER_THAN && (mmDescriptorsComparison == EQUAL || mmDescriptorsComparison == GREATER_THAN);
    }

    public void addFiles(Collection<IFile> files) {
        this.files.addAll(files);
    }
}

