/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
import { Schemas } from '../../../common/network';
export var NO_KEY_MODS = { ctrlCmd: false, alt: false };
export var ItemActivation;
(function (ItemActivation) {
    ItemActivation[ItemActivation["NONE"] = 0] = "NONE";
    ItemActivation[ItemActivation["FIRST"] = 1] = "FIRST";
    ItemActivation[ItemActivation["SECOND"] = 2] = "SECOND";
    ItemActivation[ItemActivation["LAST"] = 3] = "LAST";
})(ItemActivation || (ItemActivation = {}));
var QuickPickItemScorerAccessor = /** @class */ (function () {
    function QuickPickItemScorerAccessor(options) {
        this.options = options;
    }
    QuickPickItemScorerAccessor.prototype.getItemLabel = function (entry) {
        return entry.label;
    };
    QuickPickItemScorerAccessor.prototype.getItemDescription = function (entry) {
        var _a;
        if ((_a = this.options) === null || _a === void 0 ? void 0 : _a.skipDescription) {
            return undefined;
        }
        return entry.description;
    };
    QuickPickItemScorerAccessor.prototype.getItemPath = function (entry) {
        var _a, _b, _c;
        if ((_a = this.options) === null || _a === void 0 ? void 0 : _a.skipPath) {
            return undefined;
        }
        if (((_b = entry.resource) === null || _b === void 0 ? void 0 : _b.scheme) === Schemas.file) {
            return entry.resource.fsPath;
        }
        return (_c = entry.resource) === null || _c === void 0 ? void 0 : _c.path;
    };
    return QuickPickItemScorerAccessor;
}());
export { QuickPickItemScorerAccessor };
export var quickPickItemScorerAccessor = new QuickPickItemScorerAccessor();
//#endregion
