/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
import * as dom from '../../../base/browser/dom';
import { CancellationToken } from '../../../base/common/cancellation';
import { Color, RGBA } from '../../../base/common/color';
import { DisposableStore, combinedDisposable } from '../../../base/common/lifecycle';
import { Position } from '../../common/core/position';
import { Range } from '../../common/core/range';
import { ModelDecorationOptions } from '../../common/model/textModel';
import { TokenizationRegistry } from '../../common/modes';
import { getColorPresentations } from '../colorPicker/color';
import { ColorDetector } from '../colorPicker/colorDetector';
import { ColorPickerModel } from '../colorPicker/colorPickerModel';
import { ColorPickerWidget } from '../colorPicker/colorPickerWidget';
import { HoverOperation } from './hoverOperation';
import { registerThemingParticipant } from '../../../platform/theme/common/themeService';
import { coalesce } from '../../../base/common/arrays';
import { textLinkForeground } from '../../../platform/theme/common/colorRegistry';
import { Widget } from '../../../base/browser/ui/widget';
import { HoverWidget } from '../../../base/browser/ui/hover/hoverWidget';
import { MarkerHover, MarkerHoverParticipant } from './markerHoverParticipant';
import { MarkdownHover, MarkdownHoverParticipant } from './markdownHoverParticipant';
var ColorHover = /** @class */ (function () {
    function ColorHover(range, color, provider) {
        this.range = range;
        this.color = color;
        this.provider = provider;
    }
    ColorHover.prototype.equals = function (other) {
        return false;
    };
    return ColorHover;
}());
var HoverPartInfo = /** @class */ (function () {
    function HoverPartInfo(owner, data) {
        this.owner = owner;
        this.data = data;
    }
    return HoverPartInfo;
}());
var ModesContentComputer = /** @class */ (function () {
    function ModesContentComputer(editor, _markerHoverParticipant, _markdownHoverParticipant) {
        this._markerHoverParticipant = _markerHoverParticipant;
        this._markdownHoverParticipant = _markdownHoverParticipant;
        this._editor = editor;
        this._result = [];
        this._range = null;
    }
    ModesContentComputer.prototype.setRange = function (range) {
        this._range = range;
        this._result = [];
    };
    ModesContentComputer.prototype.clearResult = function () {
        this._result = [];
    };
    ModesContentComputer.prototype.computeAsync = function (token) {
        return __awaiter(this, void 0, void 0, function () {
            var markdownHovers;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this._editor.hasModel() || !this._range) {
                            return [2 /*return*/, Promise.resolve([])];
                        }
                        return [4 /*yield*/, this._markdownHoverParticipant.computeAsync(this._range, token)];
                    case 1:
                        markdownHovers = _a.sent();
                        return [2 /*return*/, markdownHovers.map(function (h) { return new HoverPartInfo(_this._markdownHoverParticipant, h); })];
                }
            });
        });
    };
    ModesContentComputer.prototype.computeSync = function () {
        var e_1, _a;
        var _this = this;
        if (!this._editor.hasModel() || !this._range) {
            return [];
        }
        var model = this._editor.getModel();
        var hoverRange = this._range;
        var lineNumber = hoverRange.startLineNumber;
        if (lineNumber > this._editor.getModel().getLineCount()) {
            // Illegal line number => no results
            return [];
        }
        var maxColumn = model.getLineMaxColumn(lineNumber);
        var lineDecorations = this._editor.getLineDecorations(lineNumber).filter(function (d) {
            if (d.options.isWholeLine) {
                return true;
            }
            var startColumn = (d.range.startLineNumber === lineNumber) ? d.range.startColumn : 1;
            var endColumn = (d.range.endLineNumber === lineNumber) ? d.range.endColumn : maxColumn;
            if (startColumn > hoverRange.startColumn || hoverRange.endColumn > endColumn) {
                return false;
            }
            return true;
        });
        var result = [];
        var colorDetector = ColorDetector.get(this._editor);
        try {
            for (var lineDecorations_1 = __values(lineDecorations), lineDecorations_1_1 = lineDecorations_1.next(); !lineDecorations_1_1.done; lineDecorations_1_1 = lineDecorations_1.next()) {
                var d = lineDecorations_1_1.value;
                var colorData = colorDetector.getColorData(d.range.getStartPosition());
                if (colorData) {
                    var _b = colorData.colorInfo, color = _b.color, range = _b.range;
                    result.push(new HoverPartInfo(null, new ColorHover(Range.lift(range), color, colorData.provider)));
                    break;
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (lineDecorations_1_1 && !lineDecorations_1_1.done && (_a = lineDecorations_1.return)) _a.call(lineDecorations_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
        var markdownHovers = this._markdownHoverParticipant.computeSync(this._range, lineDecorations);
        result = result.concat(markdownHovers.map(function (h) { return new HoverPartInfo(_this._markdownHoverParticipant, h); }));
        var markerHovers = this._markerHoverParticipant.computeSync(this._range, lineDecorations);
        result = result.concat(markerHovers.map(function (h) { return new HoverPartInfo(_this._markerHoverParticipant, h); }));
        return coalesce(result);
    };
    ModesContentComputer.prototype.onResult = function (result, isFromSynchronousComputation) {
        // Always put synchronous messages before asynchronous ones
        if (isFromSynchronousComputation) {
            this._result = result.concat(this._result);
        }
        else {
            this._result = this._result.concat(result);
        }
    };
    ModesContentComputer.prototype.getResult = function () {
        return this._result.slice(0);
    };
    ModesContentComputer.prototype.getResultWithLoadingMessage = function () {
        if (this._range) {
            var loadingMessage = new HoverPartInfo(this._markdownHoverParticipant, this._markdownHoverParticipant.createLoadingMessage(this._range));
            return this._result.slice(0).concat([loadingMessage]);
        }
        return this._result.slice(0);
    };
    return ModesContentComputer;
}());
var ModesContentHoverWidget = /** @class */ (function (_super) {
    __extends(ModesContentHoverWidget, _super);
    function ModesContentHoverWidget(editor, _hoverVisibleKey, instantiationService, _themeService) {
        var _this = _super.call(this) || this;
        _this._hoverVisibleKey = _hoverVisibleKey;
        _this._themeService = _themeService;
        // IContentWidget.allowEditorOverflow
        _this.allowEditorOverflow = true;
        _this._markerHoverParticipant = instantiationService.createInstance(MarkerHoverParticipant, editor, _this);
        _this._markdownHoverParticipant = instantiationService.createInstance(MarkdownHoverParticipant, editor, _this);
        _this._hover = _this._register(new HoverWidget());
        _this._id = ModesContentHoverWidget.ID;
        _this._editor = editor;
        _this._isVisible = false;
        _this._stoleFocus = false;
        _this._renderDisposable = null;
        _this.onkeydown(_this._hover.containerDomNode, function (e) {
            if (e.equals(9 /* Escape */)) {
                _this.hide();
            }
        });
        _this._register(_this._editor.onDidChangeConfiguration(function (e) {
            if (e.hasChanged(38 /* fontInfo */)) {
                _this._updateFont();
            }
        }));
        _this._editor.onDidLayoutChange(function () { return _this.layout(); });
        _this.layout();
        _this._editor.addContentWidget(_this);
        _this._showAtPosition = null;
        _this._showAtRange = null;
        _this._stoleFocus = false;
        _this._messages = [];
        _this._lastRange = null;
        _this._computer = new ModesContentComputer(_this._editor, _this._markerHoverParticipant, _this._markdownHoverParticipant);
        _this._highlightDecorations = [];
        _this._isChangingDecorations = false;
        _this._shouldFocus = false;
        _this._colorPicker = null;
        _this._hoverOperation = new HoverOperation(_this._computer, function (result) { return _this._withResult(result, true); }, null, function (result) { return _this._withResult(result, false); }, _this._editor.getOption(48 /* hover */).delay);
        _this._register(dom.addStandardDisposableListener(_this.getDomNode(), dom.EventType.FOCUS, function () {
            if (_this._colorPicker) {
                _this.getDomNode().classList.add('colorpicker-hover');
            }
        }));
        _this._register(dom.addStandardDisposableListener(_this.getDomNode(), dom.EventType.BLUR, function () {
            _this.getDomNode().classList.remove('colorpicker-hover');
        }));
        _this._register(editor.onDidChangeConfiguration(function () {
            _this._hoverOperation.setHoverTime(_this._editor.getOption(48 /* hover */).delay);
        }));
        _this._register(TokenizationRegistry.onDidChange(function () {
            if (_this._isVisible && _this._lastRange && _this._messages.length > 0) {
                _this._messages = _this._messages.map(function (msg) {
                    var _a, _b;
                    // If a color hover is visible, we need to update the message that
                    // created it so that the color matches the last chosen color
                    if (msg.data instanceof ColorHover && !!((_a = _this._lastRange) === null || _a === void 0 ? void 0 : _a.intersectRanges(msg.data.range)) && ((_b = _this._colorPicker) === null || _b === void 0 ? void 0 : _b.model.color)) {
                        var color = _this._colorPicker.model.color;
                        var newColor = {
                            red: color.rgba.r / 255,
                            green: color.rgba.g / 255,
                            blue: color.rgba.b / 255,
                            alpha: color.rgba.a
                        };
                        return new HoverPartInfo(msg.owner, new ColorHover(msg.data.range, newColor, msg.data.provider));
                    }
                    else {
                        return msg;
                    }
                });
                _this._hover.contentsDomNode.textContent = '';
                _this._renderMessages(_this._lastRange, _this._messages);
            }
        }));
        return _this;
    }
    ModesContentHoverWidget.prototype.dispose = function () {
        this._hoverOperation.cancel();
        this._editor.removeContentWidget(this);
        _super.prototype.dispose.call(this);
    };
    ModesContentHoverWidget.prototype.getId = function () {
        return this._id;
    };
    ModesContentHoverWidget.prototype.getDomNode = function () {
        return this._hover.containerDomNode;
    };
    ModesContentHoverWidget.prototype.showAt = function (position, range, focus) {
        // Position has changed
        this._showAtPosition = position;
        this._showAtRange = range;
        this._hoverVisibleKey.set(true);
        this._isVisible = true;
        this._hover.containerDomNode.classList.toggle('hidden', !this._isVisible);
        this._editor.layoutContentWidget(this);
        // Simply force a synchronous render on the editor
        // such that the widget does not really render with left = '0px'
        this._editor.render();
        this._stoleFocus = focus;
        if (focus) {
            this._hover.containerDomNode.focus();
        }
    };
    ModesContentHoverWidget.prototype.getPosition = function () {
        if (this._isVisible) {
            return {
                position: this._showAtPosition,
                range: this._showAtRange,
                preference: [
                    1 /* ABOVE */,
                    2 /* BELOW */
                ]
            };
        }
        return null;
    };
    ModesContentHoverWidget.prototype._updateFont = function () {
        var _this = this;
        var codeClasses = Array.prototype.slice.call(this._hover.contentsDomNode.getElementsByClassName('code'));
        codeClasses.forEach(function (node) { return _this._editor.applyFontInfo(node); });
    };
    ModesContentHoverWidget.prototype._updateContents = function (node) {
        this._hover.contentsDomNode.textContent = '';
        this._hover.contentsDomNode.appendChild(node);
        this._updateFont();
        this._editor.layoutContentWidget(this);
        this._hover.onContentsChanged();
    };
    ModesContentHoverWidget.prototype.layout = function () {
        var height = Math.max(this._editor.getLayoutInfo().height / 4, 250);
        var _a = this._editor.getOption(38 /* fontInfo */), fontSize = _a.fontSize, lineHeight = _a.lineHeight;
        this._hover.contentsDomNode.style.fontSize = fontSize + "px";
        this._hover.contentsDomNode.style.lineHeight = lineHeight + "px";
        this._hover.contentsDomNode.style.maxHeight = height + "px";
        this._hover.contentsDomNode.style.maxWidth = Math.max(this._editor.getLayoutInfo().width * 0.66, 500) + "px";
    };
    ModesContentHoverWidget.prototype.onModelDecorationsChanged = function () {
        if (this._isChangingDecorations) {
            return;
        }
        if (this._isVisible) {
            // The decorations have changed and the hover is visible,
            // we need to recompute the displayed text
            this._hoverOperation.cancel();
            this._computer.clearResult();
            if (!this._colorPicker) { // TODO@Michel ensure that displayed text for other decorations is computed even if color picker is in place
                this._hoverOperation.start(0 /* Delayed */);
            }
        }
    };
    ModesContentHoverWidget.prototype.startShowingAt = function (range, mode, focus) {
        if (this._lastRange && this._lastRange.equalsRange(range)) {
            // We have to show the widget at the exact same range as before, so no work is needed
            return;
        }
        this._hoverOperation.cancel();
        if (this._isVisible) {
            // The range might have changed, but the hover is visible
            // Instead of hiding it completely, filter out messages that are still in the new range and
            // kick off a new computation
            if (!this._showAtPosition || this._showAtPosition.lineNumber !== range.startLineNumber) {
                this.hide();
            }
            else {
                var filteredMessages = [];
                for (var i = 0, len = this._messages.length; i < len; i++) {
                    var msg = this._messages[i];
                    var rng = msg.data.range;
                    if (rng && rng.startColumn <= range.startColumn && rng.endColumn >= range.endColumn) {
                        filteredMessages.push(msg);
                    }
                }
                if (filteredMessages.length > 0) {
                    if (hoverContentsEquals(filteredMessages, this._messages)) {
                        return;
                    }
                    this._renderMessages(range, filteredMessages);
                }
                else {
                    this.hide();
                }
            }
        }
        this._lastRange = range;
        this._computer.setRange(range);
        this._shouldFocus = focus;
        this._hoverOperation.start(mode);
    };
    ModesContentHoverWidget.prototype.hide = function () {
        var _this = this;
        this._lastRange = null;
        this._hoverOperation.cancel();
        if (this._isVisible) {
            setTimeout(function () {
                // Give commands a chance to see the key
                if (!_this._isVisible) {
                    _this._hoverVisibleKey.set(false);
                }
            }, 0);
            this._isVisible = false;
            this._hover.containerDomNode.classList.toggle('hidden', !this._isVisible);
            this._editor.layoutContentWidget(this);
            if (this._stoleFocus) {
                this._editor.focus();
            }
        }
        this._isChangingDecorations = true;
        this._highlightDecorations = this._editor.deltaDecorations(this._highlightDecorations, []);
        this._isChangingDecorations = false;
        if (this._renderDisposable) {
            this._renderDisposable.dispose();
            this._renderDisposable = null;
        }
        this._colorPicker = null;
    };
    ModesContentHoverWidget.prototype.isColorPickerVisible = function () {
        return !!this._colorPicker;
    };
    ModesContentHoverWidget.prototype.onContentsChanged = function () {
        this._hover.onContentsChanged();
    };
    ModesContentHoverWidget.prototype._withResult = function (result, complete) {
        this._messages = result;
        if (this._lastRange && this._messages.length > 0) {
            this._renderMessages(this._lastRange, this._messages);
        }
        else if (complete) {
            this.hide();
        }
    };
    ModesContentHoverWidget.prototype._renderMessages = function (renderRange, messages) {
        var _this = this;
        if (this._renderDisposable) {
            this._renderDisposable.dispose();
            this._renderDisposable = null;
        }
        this._colorPicker = null;
        // update column from which to show
        var renderColumn = 1073741824 /* MAX_SAFE_SMALL_INTEGER */;
        var highlightRange = messages[0].data.range ? Range.lift(messages[0].data.range) : null;
        var fragment = document.createDocumentFragment();
        var containColorPicker = false;
        var disposables = new DisposableStore();
        var markerMessages = [];
        var markdownParts = [];
        messages.forEach(function (_msg) {
            var msg = _msg.data;
            if (!msg.range) {
                return;
            }
            renderColumn = Math.min(renderColumn, msg.range.startColumn);
            highlightRange = highlightRange ? Range.plusRange(highlightRange, msg.range) : Range.lift(msg.range);
            if (msg instanceof ColorHover) {
                containColorPicker = true;
                var _a = msg.color, red = _a.red, green = _a.green, blue = _a.blue, alpha = _a.alpha;
                var rgba = new RGBA(Math.round(red * 255), Math.round(green * 255), Math.round(blue * 255), alpha);
                var color_1 = new Color(rgba);
                if (!_this._editor.hasModel()) {
                    return;
                }
                var editorModel_1 = _this._editor.getModel();
                var range_1 = new Range(msg.range.startLineNumber, msg.range.startColumn, msg.range.endLineNumber, msg.range.endColumn);
                var colorInfo = { range: msg.range, color: msg.color };
                // create blank olor picker model and widget first to ensure it's positioned correctly.
                var model_1 = new ColorPickerModel(color_1, [], 0);
                var widget_1 = new ColorPickerWidget(fragment, model_1, _this._editor.getOption(122 /* pixelRatio */), _this._themeService);
                getColorPresentations(editorModel_1, colorInfo, msg.provider, CancellationToken.None).then(function (colorPresentations) {
                    model_1.colorPresentations = colorPresentations || [];
                    if (!_this._editor.hasModel()) {
                        // gone...
                        return;
                    }
                    var originalText = _this._editor.getModel().getValueInRange(msg.range);
                    model_1.guessColorPresentation(color_1, originalText);
                    var updateEditorModel = function () {
                        var textEdits;
                        var newRange;
                        if (model_1.presentation.textEdit) {
                            textEdits = [model_1.presentation.textEdit];
                            newRange = new Range(model_1.presentation.textEdit.range.startLineNumber, model_1.presentation.textEdit.range.startColumn, model_1.presentation.textEdit.range.endLineNumber, model_1.presentation.textEdit.range.endColumn);
                            var trackedRange = _this._editor.getModel()._setTrackedRange(null, newRange, 3 /* GrowsOnlyWhenTypingAfter */);
                            _this._editor.pushUndoStop();
                            _this._editor.executeEdits('colorpicker', textEdits);
                            newRange = _this._editor.getModel()._getTrackedRange(trackedRange) || newRange;
                        }
                        else {
                            textEdits = [{ identifier: null, range: range_1, text: model_1.presentation.label, forceMoveMarkers: false }];
                            newRange = range_1.setEndPosition(range_1.endLineNumber, range_1.startColumn + model_1.presentation.label.length);
                            _this._editor.pushUndoStop();
                            _this._editor.executeEdits('colorpicker', textEdits);
                        }
                        if (model_1.presentation.additionalTextEdits) {
                            textEdits = __spreadArray([], __read(model_1.presentation.additionalTextEdits));
                            _this._editor.executeEdits('colorpicker', textEdits);
                            _this.hide();
                        }
                        _this._editor.pushUndoStop();
                        range_1 = newRange;
                    };
                    var updateColorPresentations = function (color) {
                        return getColorPresentations(editorModel_1, {
                            range: range_1,
                            color: {
                                red: color.rgba.r / 255,
                                green: color.rgba.g / 255,
                                blue: color.rgba.b / 255,
                                alpha: color.rgba.a
                            }
                        }, msg.provider, CancellationToken.None).then(function (colorPresentations) {
                            model_1.colorPresentations = colorPresentations || [];
                        });
                    };
                    var colorListener = model_1.onColorFlushed(function (color) {
                        updateColorPresentations(color).then(updateEditorModel);
                    });
                    var colorChangeListener = model_1.onDidChangeColor(updateColorPresentations);
                    _this._colorPicker = widget_1;
                    _this.showAt(range_1.getStartPosition(), range_1, _this._shouldFocus);
                    _this._updateContents(fragment);
                    _this._colorPicker.layout();
                    _this._renderDisposable = combinedDisposable(colorListener, colorChangeListener, widget_1, disposables);
                });
            }
            else {
                if (msg instanceof MarkerHover) {
                    markerMessages.push(msg);
                }
                else {
                    if (msg instanceof MarkdownHover) {
                        markdownParts.push(msg);
                    }
                }
            }
        });
        if (markdownParts.length > 0) {
            disposables.add(this._markdownHoverParticipant.renderHoverParts(markdownParts, fragment));
        }
        if (markerMessages.length) {
            disposables.add(this._markerHoverParticipant.renderHoverParts(markerMessages, fragment));
        }
        this._renderDisposable = disposables;
        // show
        if (!containColorPicker && fragment.hasChildNodes()) {
            this.showAt(new Position(renderRange.startLineNumber, renderColumn), highlightRange, this._shouldFocus);
            this._updateContents(fragment);
        }
        this._isChangingDecorations = true;
        this._highlightDecorations = this._editor.deltaDecorations(this._highlightDecorations, highlightRange ? [{
                range: highlightRange,
                options: ModesContentHoverWidget._DECORATION_OPTIONS
            }] : []);
        this._isChangingDecorations = false;
    };
    ModesContentHoverWidget.ID = 'editor.contrib.modesContentHoverWidget';
    ModesContentHoverWidget._DECORATION_OPTIONS = ModelDecorationOptions.register({
        className: 'hoverHighlight'
    });
    return ModesContentHoverWidget;
}(Widget));
export { ModesContentHoverWidget };
function hoverContentsEquals(first, second) {
    if (first.length !== second.length) {
        return false;
    }
    for (var i = 0; i < first.length; i++) {
        if (!first[i].data.equals(second[i].data)) {
            return false;
        }
    }
    return true;
}
registerThemingParticipant(function (theme, collector) {
    var linkFg = theme.getColor(textLinkForeground);
    if (linkFg) {
        collector.addRule(".monaco-hover .hover-contents a.code-link span:hover { color: " + linkFg + "; }");
    }
});
