/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
import * as objects from '../../../base/common/objects';
import * as types from '../../../base/common/types';
import { URI } from '../../../base/common/uri';
import { Registry } from '../../registry/common/platform';
import { createDecorator } from '../../instantiation/common/instantiation';
import { Extensions, OVERRIDE_PROPERTY_PATTERN, overrideIdentifierFromKey } from './configurationRegistry';
export var IConfigurationService = createDecorator('configurationService');
export function isConfigurationOverrides(thing) {
    return thing
        && typeof thing === 'object'
        && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === 'string')
        && (!thing.resource || thing.resource instanceof URI);
}
export function ConfigurationTargetToString(configurationTarget) {
    switch (configurationTarget) {
        case 1 /* USER */: return 'USER';
        case 2 /* USER_LOCAL */: return 'USER_LOCAL';
        case 3 /* USER_REMOTE */: return 'USER_REMOTE';
        case 4 /* WORKSPACE */: return 'WORKSPACE';
        case 5 /* WORKSPACE_FOLDER */: return 'WORKSPACE_FOLDER';
        case 6 /* DEFAULT */: return 'DEFAULT';
        case 7 /* MEMORY */: return 'MEMORY';
    }
}
export function compare(from, to) {
    var e_1, _a, e_2, _b, e_3, _c, e_4, _d;
    var added = to
        ? from ? to.keys.filter(function (key) { return from.keys.indexOf(key) === -1; }) : __spreadArray([], __read(to.keys))
        : [];
    var removed = from
        ? to ? from.keys.filter(function (key) { return to.keys.indexOf(key) === -1; }) : __spreadArray([], __read(from.keys))
        : [];
    var updated = [];
    if (to && from) {
        try {
            for (var _e = __values(from.keys), _f = _e.next(); !_f.done; _f = _e.next()) {
                var key = _f.value;
                if (to.keys.indexOf(key) !== -1) {
                    var value1 = getConfigurationValue(from.contents, key);
                    var value2 = getConfigurationValue(to.contents, key);
                    if (!objects.equals(value1, value2)) {
                        updated.push(key);
                    }
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_f && !_f.done && (_a = _e.return)) _a.call(_e);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    var overrides = [];
    var byOverrideIdentifier = function (overrides) {
        var e_5, _a, e_6, _b;
        var result = {};
        try {
            for (var overrides_1 = __values(overrides), overrides_1_1 = overrides_1.next(); !overrides_1_1.done; overrides_1_1 = overrides_1.next()) {
                var override = overrides_1_1.value;
                try {
                    for (var _c = (e_6 = void 0, __values(override.identifiers)), _d = _c.next(); !_d.done; _d = _c.next()) {
                        var identifier = _d.value;
                        result[keyFromOverrideIdentifier(identifier)] = override;
                    }
                }
                catch (e_6_1) { e_6 = { error: e_6_1 }; }
                finally {
                    try {
                        if (_d && !_d.done && (_b = _c.return)) _b.call(_c);
                    }
                    finally { if (e_6) throw e_6.error; }
                }
            }
        }
        catch (e_5_1) { e_5 = { error: e_5_1 }; }
        finally {
            try {
                if (overrides_1_1 && !overrides_1_1.done && (_a = overrides_1.return)) _a.call(overrides_1);
            }
            finally { if (e_5) throw e_5.error; }
        }
        return result;
    };
    var toOverridesByIdentifier = to ? byOverrideIdentifier(to.overrides) : {};
    var fromOverridesByIdentifier = from ? byOverrideIdentifier(from.overrides) : {};
    if (Object.keys(toOverridesByIdentifier).length) {
        try {
            for (var added_1 = __values(added), added_1_1 = added_1.next(); !added_1_1.done; added_1_1 = added_1.next()) {
                var key = added_1_1.value;
                var override = toOverridesByIdentifier[key];
                if (override) {
                    overrides.push([overrideIdentifierFromKey(key), override.keys]);
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (added_1_1 && !added_1_1.done && (_b = added_1.return)) _b.call(added_1);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    if (Object.keys(fromOverridesByIdentifier).length) {
        try {
            for (var removed_1 = __values(removed), removed_1_1 = removed_1.next(); !removed_1_1.done; removed_1_1 = removed_1.next()) {
                var key = removed_1_1.value;
                var override = fromOverridesByIdentifier[key];
                if (override) {
                    overrides.push([overrideIdentifierFromKey(key), override.keys]);
                }
            }
        }
        catch (e_3_1) { e_3 = { error: e_3_1 }; }
        finally {
            try {
                if (removed_1_1 && !removed_1_1.done && (_c = removed_1.return)) _c.call(removed_1);
            }
            finally { if (e_3) throw e_3.error; }
        }
    }
    if (Object.keys(toOverridesByIdentifier).length && Object.keys(fromOverridesByIdentifier).length) {
        try {
            for (var updated_1 = __values(updated), updated_1_1 = updated_1.next(); !updated_1_1.done; updated_1_1 = updated_1.next()) {
                var key = updated_1_1.value;
                var fromOverride = fromOverridesByIdentifier[key];
                var toOverride = toOverridesByIdentifier[key];
                if (fromOverride && toOverride) {
                    var result = compare({ contents: fromOverride.contents, keys: fromOverride.keys, overrides: [] }, { contents: toOverride.contents, keys: toOverride.keys, overrides: [] });
                    overrides.push([overrideIdentifierFromKey(key), __spreadArray(__spreadArray(__spreadArray([], __read(result.added)), __read(result.removed)), __read(result.updated))]);
                }
            }
        }
        catch (e_4_1) { e_4 = { error: e_4_1 }; }
        finally {
            try {
                if (updated_1_1 && !updated_1_1.done && (_d = updated_1.return)) _d.call(updated_1);
            }
            finally { if (e_4) throw e_4.error; }
        }
    }
    return { added: added, removed: removed, updated: updated, overrides: overrides };
}
export function toOverrides(raw, conflictReporter) {
    var e_7, _a;
    var overrides = [];
    try {
        for (var _b = __values(Object.keys(raw)), _c = _b.next(); !_c.done; _c = _b.next()) {
            var key = _c.value;
            if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
                var overrideRaw = {};
                for (var keyInOverrideRaw in raw[key]) {
                    overrideRaw[keyInOverrideRaw] = raw[key][keyInOverrideRaw];
                }
                overrides.push({
                    identifiers: [overrideIdentifierFromKey(key).trim()],
                    keys: Object.keys(overrideRaw),
                    contents: toValuesTree(overrideRaw, conflictReporter)
                });
            }
        }
    }
    catch (e_7_1) { e_7 = { error: e_7_1 }; }
    finally {
        try {
            if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
        }
        finally { if (e_7) throw e_7.error; }
    }
    return overrides;
}
export function toValuesTree(properties, conflictReporter) {
    var root = Object.create(null);
    for (var key in properties) {
        addToValueTree(root, key, properties[key], conflictReporter);
    }
    return root;
}
export function addToValueTree(settingsTreeRoot, key, value, conflictReporter) {
    var segments = key.split('.');
    var last = segments.pop();
    var curr = settingsTreeRoot;
    for (var i = 0; i < segments.length; i++) {
        var s = segments[i];
        var obj = curr[s];
        switch (typeof obj) {
            case 'undefined':
                obj = curr[s] = Object.create(null);
                break;
            case 'object':
                break;
            default:
                conflictReporter("Ignoring " + key + " as " + segments.slice(0, i + 1).join('.') + " is " + JSON.stringify(obj));
                return;
        }
        curr = obj;
    }
    if (typeof curr === 'object' && curr !== null) {
        try {
            curr[last] = value; // workaround https://github.com/microsoft/vscode/issues/13606
        }
        catch (e) {
            conflictReporter("Ignoring " + key + " as " + segments.join('.') + " is " + JSON.stringify(curr));
        }
    }
    else {
        conflictReporter("Ignoring " + key + " as " + segments.join('.') + " is " + JSON.stringify(curr));
    }
}
export function removeFromValueTree(valueTree, key) {
    var segments = key.split('.');
    doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
    var first = segments.shift();
    if (segments.length === 0) {
        // Reached last segment
        delete valueTree[first];
        return;
    }
    if (Object.keys(valueTree).indexOf(first) !== -1) {
        var value = valueTree[first];
        if (typeof value === 'object' && !Array.isArray(value)) {
            doRemoveFromValueTree(value, segments);
            if (Object.keys(value).length === 0) {
                delete valueTree[first];
            }
        }
    }
}
/**
 * A helper function to get the configuration value with a specific settings path (e.g. config.some.setting)
 */
export function getConfigurationValue(config, settingPath, defaultValue) {
    function accessSetting(config, path) {
        var e_8, _a;
        var current = config;
        try {
            for (var path_1 = __values(path), path_1_1 = path_1.next(); !path_1_1.done; path_1_1 = path_1.next()) {
                var component = path_1_1.value;
                if (typeof current !== 'object' || current === null) {
                    return undefined;
                }
                current = current[component];
            }
        }
        catch (e_8_1) { e_8 = { error: e_8_1 }; }
        finally {
            try {
                if (path_1_1 && !path_1_1.done && (_a = path_1.return)) _a.call(path_1);
            }
            finally { if (e_8) throw e_8.error; }
        }
        return current;
    }
    var path = settingPath.split('.');
    var result = accessSetting(config, path);
    return typeof result === 'undefined' ? defaultValue : result;
}
export function merge(base, add, overwrite) {
    Object.keys(add).forEach(function (key) {
        if (key !== '__proto__') {
            if (key in base) {
                if (types.isObject(base[key]) && types.isObject(add[key])) {
                    merge(base[key], add[key], overwrite);
                }
                else if (overwrite) {
                    base[key] = add[key];
                }
            }
            else {
                base[key] = add[key];
            }
        }
    });
}
export function getConfigurationKeys() {
    var properties = Registry.as(Extensions.Configuration).getConfigurationProperties();
    return Object.keys(properties);
}
export function getDefaultValues() {
    var valueTreeRoot = Object.create(null);
    var properties = Registry.as(Extensions.Configuration).getConfigurationProperties();
    for (var key in properties) {
        var value = properties[key].default;
        addToValueTree(valueTreeRoot, key, value, function (message) { return console.error("Conflict in default settings: " + message); });
    }
    return valueTreeRoot;
}
export function keyFromOverrideIdentifier(overrideIdentifier) {
    return "[" + overrideIdentifier + "]";
}
export function getMigratedSettingValue(configurationService, currentSettingName, legacySettingName) {
    var setting = configurationService.inspect(currentSettingName);
    var legacySetting = configurationService.inspect(legacySettingName);
    if (typeof setting.userValue !== 'undefined' || typeof setting.workspaceValue !== 'undefined' || typeof setting.workspaceFolderValue !== 'undefined') {
        return setting.value;
    }
    else if (typeof legacySetting.userValue !== 'undefined' || typeof legacySetting.workspaceValue !== 'undefined' || typeof legacySetting.workspaceFolderValue !== 'undefined') {
        return legacySetting.value;
    }
    else {
        return setting.defaultValue;
    }
}
