"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var DefaultSecondaryWindowService_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultSecondaryWindowService = void 0;
// *****************************************************************************
// Copyright (C) 2022 STMicroelectronics, Ericsson, ARM, EclipseSource and others.
//
// This program and the accompanying materials are made available under the
// terms of the Eclipse Public License v. 2.0 which is available at
// http://www.eclipse.org/legal/epl-2.0.
//
// This Source Code may also be made available under the following Secondary
// Licenses when the conditions for such availability set forth in the Eclipse
// Public License v. 2.0 are satisfied: GNU General Public License, version 2
// with the GNU Classpath Exception which is available at
// https://www.gnu.org/software/classpath/license.html.
//
// SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
// *****************************************************************************
const inversify_1 = require("inversify");
const window_service_1 = require("./window-service");
let DefaultSecondaryWindowService = DefaultSecondaryWindowService_1 = class DefaultSecondaryWindowService {
    constructor() {
        /**
         * Randomized prefix to be included in opened windows' ids.
         * This avoids conflicts when creating sub-windows from multiple theia instances (e.g. by opening Theia multiple times in the same browser)
         */
        this.prefix = crypto.getRandomValues(new Uint32Array(1))[0];
        /** Unique id. Increase after every access. */
        this.nextId = 0;
        this.secondaryWindows = [];
    }
    init() {
        // Close all open windows when the main window is closed.
        this.windowService.onUnload(() => {
            // Iterate backwards because calling window.close might remove the window from the array
            for (let i = this.secondaryWindows.length - 1; i >= 0; i--) {
                this.secondaryWindows[i].close();
            }
        });
    }
    createSecondaryWindow(onClose) {
        const win = this.doCreateSecondaryWindow(onClose);
        if (win) {
            this.secondaryWindows.push(win);
        }
        return win;
    }
    doCreateSecondaryWindow(onClose) {
        const win = window.open(DefaultSecondaryWindowService_1.SECONDARY_WINDOW_URL, this.nextWindowId(), 'popup');
        if (win) {
            // Add the unload listener after the dom content was loaded because otherwise the unload listener is called already on open in some browsers (e.g. Chrome).
            win.addEventListener('DOMContentLoaded', () => {
                win.addEventListener('unload', () => {
                    this.handleWindowClosed(win, onClose);
                });
            });
        }
        return win !== null && win !== void 0 ? win : undefined;
    }
    handleWindowClosed(win, onClose) {
        const extIndex = this.secondaryWindows.indexOf(win);
        if (extIndex > -1) {
            this.secondaryWindows.splice(extIndex, 1);
        }
        ;
        onClose === null || onClose === void 0 ? void 0 : onClose(win);
    }
    focus(win) {
        win.focus();
    }
    nextWindowId() {
        return `${this.prefix}-secondaryWindow-${this.nextId++}`;
    }
};
// secondary-window.html is part of Theia's generated code. It is generated by dev-packages/application-manager/src/generator/frontend-generator.ts
DefaultSecondaryWindowService.SECONDARY_WINDOW_URL = 'secondary-window.html';
__decorate([
    (0, inversify_1.inject)(window_service_1.WindowService),
    __metadata("design:type", Object)
], DefaultSecondaryWindowService.prototype, "windowService", void 0);
__decorate([
    (0, inversify_1.postConstruct)(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], DefaultSecondaryWindowService.prototype, "init", null);
DefaultSecondaryWindowService = DefaultSecondaryWindowService_1 = __decorate([
    (0, inversify_1.injectable)()
], DefaultSecondaryWindowService);
exports.DefaultSecondaryWindowService = DefaultSecondaryWindowService;
//# sourceMappingURL=default-secondary-window-service.js.map