/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.corext.refactoring.delegates;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildPropertyDescriptor;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.ls.core.internal.corext.refactoring.delegates.DelegateCreator;

public class DelegateMethodCreator
extends DelegateCreator {
    private ASTNode fDelegateInvocation;
    private MethodRef fDocMethodReference;

    @Override
    protected void initialize() {
        Assert.isTrue((boolean)(this.getDeclaration() instanceof MethodDeclaration));
        if (this.getNewElementName() == null) {
            this.setNewElementName(((MethodDeclaration)this.getDeclaration()).getName().getIdentifier());
        }
        this.setInsertBefore(true);
    }

    @Override
    protected ASTNode createBody(BodyDeclaration bd) throws JavaModelException {
        MethodDeclaration methodDeclaration = (MethodDeclaration)bd;
        if (methodDeclaration.getBody() == null) {
            return null;
        }
        return this.createDelegateMethodBody(methodDeclaration);
    }

    @Override
    protected ASTNode createDocReference(BodyDeclaration declaration) throws JavaModelException {
        this.fDocMethodReference = this.getAst().newMethodRef();
        this.fDocMethodReference.setName(this.getAst().newSimpleName(this.getNewElementName()));
        if (this.isMoveToAnotherFile()) {
            this.fDocMethodReference.setQualifier(this.createDestinationTypeName());
        }
        this.createArguments((MethodDeclaration)declaration, this.fDocMethodReference.parameters(), false);
        return this.fDocMethodReference;
    }

    @Override
    protected ASTNode getBodyHead(BodyDeclaration result) {
        return result;
    }

    @Override
    protected ChildPropertyDescriptor getJavaDocProperty() {
        return MethodDeclaration.JAVADOC_PROPERTY;
    }

    @Override
    protected ChildPropertyDescriptor getBodyProperty() {
        return MethodDeclaration.BODY_PROPERTY;
    }

    public ASTNode getDelegateInvocation() {
        return this.fDelegateInvocation;
    }

    public MethodRef getJavadocReference() {
        return this.fDocMethodReference;
    }

    protected Statement createMethodInvocation(MethodDeclaration declaration, MethodInvocation invocation) {
        PrimitiveType primitive;
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)invocation);
        Object statement = null;
        Type type = declaration.getReturnType2();
        statement = type == null ? this.createExpressionStatement(invocation) : (type instanceof PrimitiveType ? ((primitive = (PrimitiveType)type).getPrimitiveTypeCode().equals(PrimitiveType.VOID) ? this.createExpressionStatement(invocation) : this.createReturnStatement(invocation)) : this.createReturnStatement(invocation));
        return statement;
    }

    @Override
    protected IBinding getDeclarationBinding() {
        MethodDeclaration declaration = (MethodDeclaration)this.getDeclaration();
        return declaration.resolveBinding();
    }

    private void createArguments(MethodDeclaration declaration, List<? extends ASTNode> arguments, boolean methodInvocation) {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull(arguments);
        SingleVariableDeclaration variable = null;
        int size = declaration.parameters().size();
        int index = 0;
        while (index < size) {
            variable = (SingleVariableDeclaration)declaration.parameters().get(index);
            if (methodInvocation) {
                SimpleName expression = this.getAst().newSimpleName(variable.getName().getIdentifier());
                arguments.add((ASTNode)expression);
            } else {
                MethodRefParameter parameter = this.getAst().newMethodRefParameter();
                parameter.setType(ASTNodeFactory.newType((AST)this.getAst(), (VariableDeclaration)variable));
                if (index == size - 1 && declaration.isVarargs()) {
                    parameter.setVarargs(true);
                }
                arguments.add((ASTNode)parameter);
            }
            ++index;
        }
    }

    private Block createDelegateMethodBody(MethodDeclaration declaration) {
        ConstructorInvocation call;
        List arguments;
        ConstructorInvocation invocation;
        Assert.isNotNull((Object)declaration);
        MethodDeclaration old = (MethodDeclaration)this.getDeclaration();
        if (old.isConstructor()) {
            invocation = this.getAst().newConstructorInvocation();
            arguments = invocation.arguments();
            call = invocation;
            this.fDelegateInvocation = invocation;
        } else {
            invocation = this.getAst().newMethodInvocation();
            invocation.setName(this.getAst().newSimpleName(this.getNewElementName()));
            invocation.setExpression(this.getAccess());
            arguments = invocation.arguments();
            call = this.createMethodInvocation(declaration, (MethodInvocation)invocation);
            this.fDelegateInvocation = invocation;
        }
        this.createArguments(declaration, arguments, true);
        Block body = this.getAst().newBlock();
        body.statements().add(call);
        return body;
    }

    private ExpressionStatement createExpressionStatement(MethodInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        return invocation.getAST().newExpressionStatement((Expression)invocation);
    }

    private ReturnStatement createReturnStatement(MethodInvocation invocation) {
        Assert.isNotNull((Object)invocation);
        ReturnStatement statement = invocation.getAST().newReturnStatement();
        statement.setExpression((Expression)invocation);
        return statement;
    }

    @Override
    protected String getTextEditGroupLabel() {
        return RefactoringCoreMessages.DelegateMethodCreator_text_edit_group_field;
    }
}

