/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.ui.javaeditor.HighlightedPositionCore;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDocumentLifeCycleHandler;
import org.eclipse.jdt.ls.core.internal.handlers.DiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.highlighting.SemanticHighlightingService;
import org.eclipse.jdt.ls.core.internal.managers.InvisibleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public class DocumentLifeCycleHandler
extends BaseDocumentLifeCycleHandler {
    private JavaClientConnection connection;
    private PreferenceManager preferenceManager;
    private CoreASTProvider sharedASTProvider;
    private SemanticHighlightingService semanticHighlightingService;

    public DocumentLifeCycleHandler(JavaClientConnection connection, PreferenceManager preferenceManager, ProjectsManager projectsManager, boolean delayValidation) {
        super(delayValidation);
        this.connection = connection;
        this.preferenceManager = preferenceManager;
        this.sharedASTProvider = CoreASTProvider.getInstance();
        this.semanticHighlightingService = new SemanticHighlightingService(this.connection, this.sharedASTProvider, this.preferenceManager);
    }

    @Override
    public BaseDiagnosticsHandler createDiagnosticsHandler(ICompilationUnit unit) {
        return new DiagnosticsHandler(this.connection, unit);
    }

    @Override
    public boolean isSyntaxMode(ICompilationUnit unit) {
        return JDTUtils.isDefaultProject(unit) || !JDTUtils.isOnClassPath(unit);
    }

    @Override
    public ICompilationUnit resolveCompilationUnit(String uri) {
        ICompilationUnit unit = null;
        IFile resource = JDTUtils.findFile(uri);
        if (resource != null) {
            unit = JDTUtils.resolveCompilationUnit(resource);
        } else {
            IPath filePath = ResourceUtils.canonicalFilePathFromURI(uri);
            if (filePath != null) {
                IPath rootPath2;
                Collection<IPath> rootPaths = this.preferenceManager.getPreferences().getRootPaths();
                Optional<IPath> belongedRootPath = rootPaths.stream().filter(rootPath -> rootPath.isPrefixOf(filePath)).findFirst();
                boolean invisibleProjectEnabled = false;
                if (belongedRootPath.isPresent() && (invisibleProjectEnabled = InvisibleProjectImporter.loadInvisibleProject(filePath, rootPath2 = belongedRootPath.get(), false))) {
                    unit = JDTUtils.resolveCompilationUnit(uri);
                }
                if (!invisibleProjectEnabled) {
                    unit = JDTUtils.getFakeCompilationUnit(uri);
                }
            }
        }
        return unit;
    }

    @Override
    public ICompilationUnit handleOpen(DidOpenTextDocumentParams params) {
        ICompilationUnit unit = super.handleOpen(params);
        if (unit == null || unit.getResource() == null || unit.getResource().isDerived()) {
            return unit;
        }
        try {
            this.installSemanticHighlightings(unit);
        }
        catch (JavaModelException | BadPositionCategoryException e) {
            JavaLanguageServerPlugin.logException("Error while opening document. URI: " + params.getTextDocument().getUri(), e);
        }
        return unit;
    }

    @Override
    public ICompilationUnit handleChanged(DidChangeTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null || !unit.isWorkingCopy() || params.getContentChanges().isEmpty() || unit.getResource().isDerived()) {
            return unit;
        }
        try {
            if (unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
                this.sharedASTProvider.disposeAST();
            }
            List contentChanges = params.getContentChanges();
            ArrayList diffContexts = Lists.newArrayList();
            for (TextDocumentContentChangeEvent changeEvent : contentChanges) {
                int length;
                Range range = changeEvent.getRange();
                if (range != null) {
                    length = changeEvent.getRangeLength();
                } else {
                    length = unit.getSource().length();
                    range = JDTUtils.toRange((IOpenable)unit, 0, length);
                }
                int startOffset = JsonRpcHelpers.toOffset(unit.getBuffer(), range.getStart().getLine(), range.getStart().getCharacter());
                Object edit = null;
                String text = changeEvent.getText();
                edit = length == 0 ? new InsertEdit(startOffset, text) : (text.isEmpty() ? new DeleteEdit(startOffset, length) : new ReplaceEdit(startOffset, length, text));
                if (this.semanticHighlightingService.isEnabled()) {
                    Document oldState = new Document(unit.getBuffer().getContents());
                    IDocument newState = JsonRpcHelpers.toDocument(unit.getBuffer());
                    List<HighlightedPositionCore> oldPositions = diffContexts.isEmpty() ? this.semanticHighlightingService.getHighlightedPositions(uri) : ((SemanticHighlightingService.HighlightedPositionDiffContext)Iterables.getLast((Iterable)diffContexts)).newPositions;
                    edit.apply(newState, 0);
                    newState = new Document(newState.get());
                    List<HighlightedPositionCore> newPositions = this.semanticHighlightingService.calculateHighlightedPositions(unit, true);
                    DocumentEvent event = new DocumentEvent(newState, startOffset, length, text);
                    diffContexts.add(new SemanticHighlightingService.HighlightedPositionDiffContext((IDocument)oldState, event, oldPositions, newPositions));
                    continue;
                }
                IDocument document = JsonRpcHelpers.toDocument(unit.getBuffer());
                edit.apply(document, 0);
            }
            this.triggerValidation(unit);
            this.updateSemanticHighlightings(params.getTextDocument(), diffContexts);
        }
        catch (JavaModelException | BadLocationException | BadPositionCategoryException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException("Error while handling document change. URI: " + uri, e);
        }
        return unit;
    }

    @Override
    public ICompilationUnit handleClosed(DidCloseTextDocumentParams params) {
        ICompilationUnit unit = super.handleClosed(params);
        this.uninstallSemanticHighlightings(params.getTextDocument().getUri());
        return unit;
    }

    protected void installSemanticHighlightings(ICompilationUnit unit) throws JavaModelException, BadPositionCategoryException {
        this.semanticHighlightingService.install(unit);
    }

    protected void uninstallSemanticHighlightings(String uri) {
        this.semanticHighlightingService.uninstall(uri);
    }

    protected void updateSemanticHighlightings(VersionedTextDocumentIdentifier textDocument, List<SemanticHighlightingService.HighlightedPositionDiffContext> diffContexts) throws BadLocationException, BadPositionCategoryException, JavaModelException {
        this.semanticHighlightingService.update(textDocument, diffContexts);
    }
}

