"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var temp = require("temp");
var test_helper_1 = require("./test-helper");
var stash_1 = require("./stash");
var status_1 = require("./status");
var chai_1 = require("chai");
var assert_1 = require("assert");
var track = temp.track();
describe('stash', function () { return __awaiter(void 0, void 0, void 0, function () {
    var repositoryPath, testText, testText2;
    return __generator(this, function (_a) {
        testText = 'A modified';
        testText2 = 'This is a completely different text.';
        afterEach(function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                track.cleanupSync();
                return [2 /*return*/];
            });
        }); });
        beforeEach(function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, (0, test_helper_1.createTestRepository)(track.mkdirSync())];
                    case 1:
                        repositoryPath = _a.sent();
                        return [2 /*return*/];
                }
            });
        }); });
        describe('stash', function () { return __awaiter(void 0, void 0, void 0, function () {
            return __generator(this, function (_a) {
                it('push', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var files, beforeStatus, afterStatus;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 1:
                                beforeStatus = _a.sent();
                                files = beforeStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(1);
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 3:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(0);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('list', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                stashes = [];
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 2:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(1);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('apply latest', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var afterStatus, files;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText2 });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.apply(repositoryPath)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 4:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(1);
                                (0, chai_1.expect)((0, test_helper_1.contentIsEqual)(repositoryPath, files[0].path, testText)).to.equal(true);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('stash with a message', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var afterStatus, files, stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 3:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(0);
                                stashes = [];
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 4:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(2);
                                (0, chai_1.expect)(stashes[0]).contains('This is a stash message.');
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('apply by id', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var afterStatus, files;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.apply(repositoryPath, 'stash@{1}')];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 4:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(1);
                                (0, chai_1.expect)((0, test_helper_1.contentIsEqual)(repositoryPath, files[0].path, testText)).to.equal(true);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('pop latest', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var error_1, afterStatus, files, stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText2 });
                                _a.label = 3;
                            case 3:
                                _a.trys.push([3, 5, 6, 11]);
                                return [4 /*yield*/, stash_1.stash.pop(repositoryPath)];
                            case 4:
                                _a.sent();
                                (0, assert_1.fail)();
                                return [3 /*break*/, 11];
                            case 5:
                                error_1 = _a.sent();
                                (0, chai_1.expect)(error_1.message).contains('Your local changes to the following files would be overwritten');
                                return [3 /*break*/, 11];
                            case 6: return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 7:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.pop(repositoryPath)];
                            case 8:
                                _a.sent();
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 9:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(1);
                                (0, chai_1.expect)((0, test_helper_1.contentIsEqual)(repositoryPath, files[0].path, testText2)).to.equal(true);
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 10:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(2);
                                return [7 /*endfinally*/];
                            case 11: return [2 /*return*/];
                        }
                    });
                }); });
                it('pop by id', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var error_2, afterStatus, files, stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText2 });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                _a.label = 3;
                            case 3:
                                _a.trys.push([3, 5, 6, 11]);
                                return [4 /*yield*/, stash_1.stash.pop(repositoryPath, 'stash@{0}')];
                            case 4:
                                _a.sent();
                                (0, assert_1.fail)();
                                return [3 /*break*/, 11];
                            case 5:
                                error_2 = _a.sent();
                                (0, chai_1.expect)(error_2.message).contains('Your local changes to the following files would be overwritten');
                                return [3 /*break*/, 11];
                            case 6: return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 7:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.pop(repositoryPath, 'stash@{1}')];
                            case 8:
                                _a.sent();
                                return [4 /*yield*/, (0, status_1.getStatus)(repositoryPath)];
                            case 9:
                                afterStatus = _a.sent();
                                files = afterStatus.workingDirectory.files;
                                (0, chai_1.expect)(files).to.have.lengthOf(1);
                                (0, chai_1.expect)((0, test_helper_1.contentIsEqual)(repositoryPath, files[0].path, testText2)).to.equal(true);
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 10:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(2);
                                return [7 /*endfinally*/];
                            case 11: return [2 /*return*/];
                        }
                    });
                }); });
                it('drop latest', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText2 });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.drop(repositoryPath)];
                            case 4:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 5:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(2);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('drop by id', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText2 });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.drop(repositoryPath, 'stash@{1}')];
                            case 4:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 5:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(2);
                                return [2 /*return*/];
                        }
                    });
                }); });
                it('clear', function () { return __awaiter(void 0, void 0, void 0, function () {
                    var stashes;
                    return __generator(this, function (_a) {
                        switch (_a.label) {
                            case 0:
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 1:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: testText2 });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath, 'This is a stash message.')];
                            case 2:
                                _a.sent();
                                (0, test_helper_1.modify)(repositoryPath, { path: 'A.txt', data: 'B' });
                                return [4 /*yield*/, stash_1.stash.push(repositoryPath)];
                            case 3:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 4:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(3);
                                return [4 /*yield*/, stash_1.stash.clear(repositoryPath)];
                            case 5:
                                _a.sent();
                                return [4 /*yield*/, stash_1.stash.list(repositoryPath)];
                            case 6:
                                stashes = _a.sent();
                                (0, chai_1.expect)(stashes).to.have.lengthOf(0);
                                return [2 /*return*/];
                        }
                    });
                }); });
                return [2 /*return*/];
            });
        }); });
        return [2 /*return*/];
    });
}); });
//# sourceMappingURL=stash.spec.js.map