/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.builder.plexusbuildapi;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.internal.builder.IIncrementalBuildFramework;

public final class EclipseResourceBuildDelta
implements IIncrementalBuildFramework.BuildDelta,
IAdaptable {
    private final IResource resource;
    private final IResourceDelta delta;

    public EclipseResourceBuildDelta(IResourceDelta delta) {
        this.resource = delta != null ? delta.getResource() : null;
        this.delta = delta;
    }

    @Override
    public boolean hasDelta(File file) {
        return this.hasDelta(this.getRelativePath(file));
    }

    private boolean hasDelta(IPath path) {
        return path == null || this.delta.findMember(path) != null;
    }

    private IPath getRelativePath(File file) {
        IPath path;
        IPath basepath = this.resource.getLocation();
        if (!basepath.isPrefixOf(path = IPath.fromOSString((String)file.getAbsolutePath()))) {
            return null;
        }
        return path.removeFirstSegments(basepath.segmentCount());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.delta)) {
            return adapter.cast(this.delta);
        }
        if (adapter.isInstance(this.resource)) {
            return adapter.cast(this.resource);
        }
        return null;
    }
}

