/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.definition;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.TITANPathUtilities;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.TITANNature;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titanium.refactoring.definition.ExtractDefinitionWizardMainPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class ExtractDefinitionWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private static final String WIZ_WINDOWTITLE = "Extract definition `{0}'' into a new project";
    private static final String WIZ_TITLE = "Create a new project to extract definition into";
    private static final String WIZ_DESCRIPTION = "Extract definition and its dependencies into a new project";
    private static final String WORKING_DIR = "bin";
    private static final String SOURCE_DIR = "src";
    private static final String CREATING_PROJECT = "creating project";
    private static final String CREATION_FAILED = "Project creation failed";
    private final String windowTitle;
    private IProject newProject;
    private final boolean wasAutoBuilding;
    private boolean isCreated;
    private IConfigurationElement config;
    private ExtractDefinitionWizardMainPage mainPage;

    public ExtractDefinitionWizard(String selectionName) {
        this.windowTitle = MessageFormat.format(WIZ_WINDOWTITLE, selectionName);
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        this.wasAutoBuilding = description.isAutoBuilding();
        description.setAutoBuilding(false);
        try {
            ResourcesPlugin.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        Activator.getDefault().pauseHandlingResourceChanges();
        this.isCreated = false;
    }

    public boolean performFinish() {
        if (!this.isCreated) {
            this.createNewProject();
        }
        if (this.newProject == null) {
            this.resetAutobuildOption();
            Activator.getDefault().resumeHandlingResourceChanges();
            return false;
        }
        try {
            TITANNature.addTITANBuilderToProject((IProject)this.newProject);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        try {
            String executable;
            this.newProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "workingDir"), WORKING_DIR);
            String tempExecutableName = this.newProject.getName();
            tempExecutableName = tempExecutableName.replace(' ', '_');
            if (this.newProject.getLocation() == null) {
                URI projectURI = this.newProject.getLocationURI();
                URI uri = TITANPathUtilities.resolvePath((String)WORKING_DIR, (URI)projectURI);
                executable = org.eclipse.core.runtime.URIUtil.append((URI)uri, (String)tempExecutableName).toString();
            } else {
                URI uri = TITANPathUtilities.resolvePathURI((String)WORKING_DIR, (String)this.newProject.getLocation().toOSString());
                IPath workingDir = URIUtil.toPath((URI)uri);
                executable = workingDir.append(tempExecutableName).toOSString();
                if ("win32".equals(Platform.getOS())) {
                    executable = executable + ".exe";
                }
            }
            this.newProject.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "targetExecutable"), executable);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        ProjectDocumentHandlingUtility.createDocument((IProject)this.newProject);
        ProjectFileHandler pfHandler = new ProjectFileHandler(this.newProject);
        WorkspaceJob job = pfHandler.saveProjectSettingsJob();
        try {
            job.join();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        try {
            this.newProject.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ExtractDefinitionWizard.this.resetAutobuildOption();
                Activator.getDefault().resumeHandlingResourceChanges();
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)ExtractDefinitionWizard.this.config);
                ExtractDefinitionWizard.this.selectAndReveal((IResource)ExtractDefinitionWizard.this.newProject);
            }
        });
        return true;
    }

    public void addPages() {
        super.addPages();
        this.mainPage = new ExtractDefinitionWizardMainPage(this.windowTitle);
        this.mainPage.setTitle(WIZ_TITLE);
        this.mainPage.setDescription(WIZ_DESCRIPTION);
        this.addPage((IWizardPage)this.mainPage);
    }

    public IProject getProject() {
        return this.newProject;
    }

    public IPath getProjectPath() {
        IPath path = this.mainPage.getLocationPath();
        String name = this.mainPage.getProjectName();
        return path.append(name);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.windowTitle);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException {
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        try {
            internalMonitor.beginTask(CREATING_PROJECT, 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(internalMonitor, 1000));
            if (internalMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(internalMonitor, 1000));
            projectHandle.refreshLocal(1, internalMonitor);
            this.isCreated = true;
        }
        finally {
            internalMonitor.done();
        }
    }

    private IProject createNewProject() {
        IProject tempProjectHandle = this.mainPage.getProjectHandle();
        URI location = null;
        if (!this.mainPage.useDefaults()) {
            location = this.mainPage.getLocationURI();
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        String tempExecutableName = tempProjectHandle.getName();
        final IProject newProjectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(tempExecutableName);
        final IProjectDescription description = workspace.newProjectDescription(tempExecutableName);
        description.setLocationURI(location);
        TITANNature.addTITANNatureToProject((IProjectDescription)description);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                ExtractDefinitionWizard.this.createProject(description, newProjectHandle, monitor);
                String sourceFolder = ExtractDefinitionWizard.SOURCE_DIR;
                IFolder folder = newProjectHandle.getFolder(sourceFolder);
                if (!folder.exists()) {
                    try {
                        folder.create(true, true, null);
                    }
                    catch (CoreException e) {
                        ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                    }
                }
                newProjectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "generateMakefile"), "true");
                newProjectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "TTCN3preprocessor"), "cpp");
                newProjectHandle.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "C/C++ compiler"), "g++");
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            final Throwable t = e.getTargetException();
            if (t != null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)new Shell(Display.getDefault()), (String)ExtractDefinitionWizard.CREATION_FAILED, (String)t.getMessage());
                    }
                });
            }
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    private void resetAutobuildOption() {
        IWorkspaceDescription description = ResourcesPlugin.getWorkspace().getDescription();
        if (description.isAutoBuilding() != this.wasAutoBuilding) {
            description.setAutoBuilding(this.wasAutoBuilding);
            try {
                ResourcesPlugin.getWorkspace().setDescription(description);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            }
        }
    }
}

