/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.common.path.PathConverter;
import org.eclipse.titan.designer.commonFilters.ResourceExclusionHelper;
import org.eclipse.titan.designer.consoles.TITANDebugConsole;
import org.eclipse.titan.designer.core.LoadBalancingUtilities;
import org.eclipse.titan.designer.core.ProjectBasedBuilder;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.core.TITANBuilderResourceVisitor;
import org.eclipse.titan.designer.core.TITANJob;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;

public final class SymbolicLinkHandler {
    static final String LINK_EXTENSION = ".lnk";
    static final String EMPTY_STRING = "";
    static final String LINK_CREATION = "ln";
    static final String FORCE_LINK_CREATION = "-sf";
    static final String APOSTROPHE = "'";
    static final String GENERATING_SYMBOLIC_LINKS = "Generating symbolic links";
    static final String TRUE = "true";
    static final String SYMBOLIC_LINK_CREATION_PROCESS = "Symbolic link creation";
    static final String REMOVE = "rm";
    static final String CREATING_OUTDATED_LINK_REMOVAL = "Creating command for removing possibly outdated symbolic links";
    static final String REMOVING_OUTDATED_LINK = "Removing possibly outdated symbolic link";
    static final String FORCE_EXECUTION = "-f";

    private SymbolicLinkHandler() {
    }

    public static void addSymlinkCreationCommand(Map<String, IFile> files, final String workingDirectory, final TITANJob buildJob, final Map<String, IFile> lastTimeRemovedFiles, IProgressMonitor monitor, boolean automaticMakefileManagement) {
        final ConcurrentHashMap symlinkFiles = new ConcurrentHashMap(files.size());
        final boolean win32 = "win32".equals(Platform.getOS());
        final String extension = win32 ? LINK_EXTENSION : EMPTY_STRING;
        final IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        internalMonitor.beginTask("Checking the symbolic links of files", files.size());
        final boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        final CountDownLatch latch = new CountDownLatch(files.size());
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
        boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        for (final IFile file : files.values()) {
            if (automaticMakefileManagement && (file.getName().contentEquals("Makefile") || file.getName().contentEquals("makefile"))) {
                latch.countDown();
                internalMonitor.worked(1);
                continue;
            }
            final IPath path = file.getLocation();
            if (path == null) {
                try {
                    file.copy((IPath)new Path(workingDirectory + file.getName()), 1, monitor);
                }
                catch (CoreException e) {
                    ErrorReporter.logExceptionStackTrace((String)("While copying the file `" + file.getLocationURI() + "' to the working directory"), (Throwable)e);
                }
                latch.countDown();
                internalMonitor.worked(1);
                continue;
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    String lastSegment = path.lastSegment();
                    boolean tempFileRemoved = lastTimeRemovedFiles.containsKey(lastSegment);
                    File tempFile = new File(workingDirectory + File.separatorChar + lastSegment + extension);
                    if (tempFile.exists() && !tempFileRemoved) {
                        if (win32) {
                            symlinkFiles.put(lastSegment, lastSegment);
                            latch.countDown();
                            internalMonitor.worked(1);
                            return;
                        }
                        try {
                            String canonicalPath = tempFile.getCanonicalPath();
                            String absolutePath = tempFile.getAbsolutePath();
                            if (!absolutePath.equals(canonicalPath) && path.toString().equals(canonicalPath)) {
                                symlinkFiles.put(lastSegment, lastSegment);
                                latch.countDown();
                                internalMonitor.worked(1);
                                return;
                            }
                        }
                        catch (IOException e) {
                            ErrorReporter.logExceptionStackTrace((String)("While getting the canonical path of `" + tempFile.getName() + SymbolicLinkHandler.APOSTROPHE), (Throwable)e);
                        }
                    }
                    if (tempFile.getAbsolutePath().equals(file.getLocation().toOSString())) {
                        symlinkFiles.put(lastSegment, lastSegment);
                        latch.countDown();
                        internalMonitor.worked(1);
                        return;
                    }
                    if (!symlinkFiles.contains(lastSegment)) {
                        symlinkFiles.put(lastSegment, lastSegment);
                        StringBuilder output = new StringBuilder();
                        ArrayList<String> command = new ArrayList<String>();
                        command.add(SymbolicLinkHandler.LINK_CREATION);
                        command.add(SymbolicLinkHandler.FORCE_LINK_CREATION);
                        command.add(SymbolicLinkHandler.APOSTROPHE + PathConverter.convert((String)file.getLocation().toOSString(), (boolean)reportDebugInformation, (StringBuilder)output) + SymbolicLinkHandler.APOSTROPHE);
                        command.add(SymbolicLinkHandler.APOSTROPHE + lastSegment + SymbolicLinkHandler.APOSTROPHE);
                        TITANDebugConsole.println(output);
                        buildJob.addCommand(command, SymbolicLinkHandler.GENERATING_SYMBOLIC_LINKS);
                    }
                    latch.countDown();
                    internalMonitor.worked(1);
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        internalMonitor.done();
    }

    public static void copyExternalFileToWorkingDirectory(Map<String, IFile> files, String workingDirectory, IProgressMonitor monitor) {
        IProgressMonitor internalMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        internalMonitor.beginTask("Checking the symbolic links of external files", files.size());
        for (IFile file : files.values()) {
            IPath path = file.getLocation();
            if (path != null) continue;
            try {
                URI uri = file.getLocationURI();
                IFileStore source = EFS.getFileSystem((String)uri.getScheme()).getStore(uri);
                Path destinationPath = new Path(workingDirectory + File.separator + file.getName());
                if (!destinationPath.toFile().exists()) {
                    IFileStore destination = EFS.getLocalFileSystem().getStore((IPath)destinationPath);
                    source.copy(destination, 2, internalMonitor);
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While processing file `" + file.getName() + APOSTROPHE), (Throwable)e);
            }
            internalMonitor.worked(1);
        }
        internalMonitor.done();
    }

    public static boolean createSymlinks(IResource resource) {
        IProject rProject = resource.getProject();
        if (!TITANBuilder.isBuilderEnabled(rProject)) {
            return true;
        }
        if (!ProjectBuildPropertyData.useSymbolicLinks(rProject)) {
            return true;
        }
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(rProject).getWorkingDirectoryPath(true);
        if (workingDir == null) {
            ErrorReporter.logError((String)"The working directory could not be created because it hasn't been defined yet");
            return false;
        }
        File wd = workingDir.toFile();
        if (!wd.exists() && !wd.mkdirs()) {
            ErrorReporter.logError((String)"The working folder could not be created");
            return false;
        }
        if (ResourceExclusionHelper.isExcluded(resource) || SymbolicLinkHandler.isInCentralStorage(resource)) {
            return true;
        }
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(rProject).getResourceVisitor();
        if (visitor.getFiles().isEmpty()) {
            return true;
        }
        TITANJob buildJob = new TITANJob(SYMBOLIC_LINK_CREATION_PROCESS, visitor.getFiles(), workingDir.toFile(), rProject);
        buildJob.setPriority(50);
        buildJob.setUser(true);
        buildJob.setRule((ISchedulingRule)rProject);
        SymbolicLinkHandler.addSymlinkCreationCommand(visitor.getFiles(), workingDir.toOSString(), buildJob, new HashMap<String, IFile>(), null, ProjectBuildPropertyData.useAutomaticMakefilegeneration(rProject));
        buildJob.schedule();
        return true;
    }

    public static boolean removeSymlinksForExcluded(IProject project) {
        if (!TITANBuilder.isBuilderEnabled(project)) {
            return true;
        }
        IPath workingDir = ProjectBasedBuilder.getProjectBasedBuilder(project).getWorkingDirectoryPath(true);
        if (workingDir == null) {
            return false;
        }
        TITANBuilderResourceVisitor visitor = ProjectBasedBuilder.getProjectBasedBuilder(project).getResourceVisitor();
        Map<String, IFile> excludedFiles = visitor.getExcludedFiles();
        TITANJob buildJob = new TITANJob("symbolic link removal", excludedFiles, workingDir.toFile(), project);
        buildJob.setPriority(50);
        buildJob.setUser(true);
        buildJob.setRule((ISchedulingRule)project);
        SymbolicLinkHandler.addSymlinkRemovingCommandForExcludedFiles(workingDir.toOSString(), buildJob, excludedFiles, (IProgressMonitor)new NullProgressMonitor());
        buildJob.schedule();
        return true;
    }

    public static void addSymlinkRemovingCommandForRemovedFiles(final String workingDirectory, final TITANJob job, Map<String, IFile> files, final IProgressMonitor monitor) {
        if (files.isEmpty()) {
            return;
        }
        final boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        final String extension = "win32".equals(Platform.getOS()) ? LINK_EXTENSION : EMPTY_STRING;
        monitor.beginTask(CREATING_OUTDATED_LINK_REMOVAL, files.size());
        final CountDownLatch latch = new CountDownLatch(files.size());
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
        boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        for (final String key : files.keySet()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    File tempFile = new File(workingDirectory + File.separatorChar + key + extension);
                    StringBuilder output = new StringBuilder();
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(SymbolicLinkHandler.REMOVE);
                    command.add(SymbolicLinkHandler.FORCE_EXECUTION);
                    command.add(SymbolicLinkHandler.APOSTROPHE + PathConverter.convert((String)tempFile.getAbsolutePath(), (boolean)reportDebugInformation, (StringBuilder)output) + SymbolicLinkHandler.APOSTROPHE);
                    job.addCommand(command, SymbolicLinkHandler.REMOVING_OUTDATED_LINK);
                    TITANDebugConsole.println(output);
                    latch.countDown();
                    monitor.worked(1);
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        monitor.done();
    }

    public static void addSymlinkRemovingCommandForExcludedFiles(final String workingDirectory, final TITANJob job, Map<String, IFile> files, final IProgressMonitor monitor) {
        if (files.isEmpty()) {
            return;
        }
        final boolean reportDebugInformation = Platform.getPreferencesService().getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.displayDebugInformation", false, null);
        final boolean isWindows = "win32".equals(Platform.getOS());
        final String extension = isWindows ? LINK_EXTENSION : EMPTY_STRING;
        monitor.beginTask(CREATING_OUTDATED_LINK_REMOVAL, files.size());
        final CountDownLatch latch = new CountDownLatch(files.size());
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        IPreferencesService prefs = Platform.getPreferencesService();
        int processingUnitsToUse = prefs.getInt("org.eclipse.titan.designer", "org.eclipse.titan.designer.processingUnitsToUse", availableProcessors, null);
        boolean limitAllThreadCreation = prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.limitAllThreadCreation", false, null);
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setPriority(LoadBalancingUtilities.getThreadPriority());
                return t;
            }
        };
        ExecutorService executor = limitAllThreadCreation ? Executors.newFixedThreadPool(processingUnitsToUse, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        for (final Map.Entry<String, IFile> entry : files.entrySet()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    File tempFile = new File(workingDirectory + File.separatorChar + (String)entry.getKey() + extension);
                    IPath location = ((IFile)entry.getValue()).getLocation();
                    if (location == null) {
                        latch.countDown();
                        monitor.worked(1);
                        return;
                    }
                    String originalLocation = location.toOSString();
                    try {
                        if (tempFile.exists() && (isWindows || originalLocation.equals(tempFile.getCanonicalPath()))) {
                            StringBuilder output = new StringBuilder();
                            ArrayList<String> command = new ArrayList<String>();
                            command.add(SymbolicLinkHandler.REMOVE);
                            command.add(SymbolicLinkHandler.FORCE_EXECUTION);
                            command.add(SymbolicLinkHandler.APOSTROPHE + PathConverter.convert((String)tempFile.getAbsolutePath(), (boolean)reportDebugInformation, (StringBuilder)output) + SymbolicLinkHandler.APOSTROPHE);
                            TITANDebugConsole.println(output);
                            job.addCommand(command, SymbolicLinkHandler.REMOVING_OUTDATED_LINK);
                        }
                    }
                    catch (IOException e) {
                        ErrorReporter.logExceptionStackTrace((String)("While removing symlink for `" + tempFile.getName() + SymbolicLinkHandler.APOSTROPHE), (Throwable)e);
                    }
                    latch.countDown();
                    monitor.worked(1);
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdown();
        try {
            executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ErrorReporter.logExceptionStackTrace((Exception)e);
        }
        executor.shutdownNow();
        monitor.done();
    }

    public static boolean isInCentralStorage(IResource resource) {
        IResource temp = resource;
        while (temp.getType() != 4) {
            if (temp.getType() == 2) {
                try {
                    if (TRUE.equals(temp.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Folder", "centralStorage")))) {
                        return true;
                    }
                }
                catch (CoreException e) {
                    return true;
                }
            }
            temp = temp.getParent();
        }
        return false;
    }
}

