/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigurationManagerControl {
    private final IProject project;
    private String actualConfiguration;
    private final Combo configurations;
    private final Button manageButton;

    public ConfigurationManagerControl(Composite parent, IProject project) {
        this.project = project;
        Group group = new Group(parent, 0);
        group.setText("Build Configurations");
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, false);
        group.setLayoutData((Object)gridData);
        Label label = new Label((Composite)group, 0);
        label.setText("The actual build configuration:");
        this.configurations = new Combo((Composite)group, 8);
        this.configurations.setEnabled(true);
        this.manageButton = new Button((Composite)group, 8);
        this.manageButton.setText("Manage Configurations");
        this.manageButton.setFont(parent.getFont());
        this.manageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ConfigurationListDialog dialog = new ConfigurationListDialog(null);
                if (dialog.open() == 0) {
                    ConfigurationManagerControl.this.loadConfigurations();
                }
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 128;
        this.manageButton.setLayoutData((Object)gd);
        this.loadConfigurations();
    }

    public boolean hasConfigurationChanged() {
        return this.actualConfiguration != null && this.configurations != null && !this.configurations.isDisposed() && !this.actualConfiguration.equals(this.configurations.getText());
    }

    private void loadConfigurations() {
        this.configurations.removeAll();
        Document document = ProjectDocumentHandlingUtility.getDocument(this.project);
        if (document == null) {
            ErrorReporter.logWarning((String)("No property file was found for project `" + this.project.getName() + "'"));
            document = ProjectDocumentHandlingUtility.createDocument(this.project);
        }
        List<String> configurationNames = ProjectFileHandler.getConfigurations(document);
        for (String name : configurationNames) {
            this.configurations.add(name);
        }
        if (this.actualConfiguration == null) {
            this.actualConfiguration = ProjectFileHandler.getActiveConfigurationName(this.project);
        }
        this.configurations.setText(this.actualConfiguration);
    }

    public String getActualSelection() {
        return this.actualConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeActualConfiguration() {
        IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
        ISchedulingRule rule = ruleFactory.createRule((IResource)this.project);
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)new NullProgressMonitor());
            this.actualConfiguration = this.configurations.getText();
            HashSet<IResource> changedResources = new HashSet<IResource>();
            Document document = ProjectDocumentHandlingUtility.getDocument(this.project);
            Node configurationNode = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), this.actualConfiguration);
            if (this.actualConfiguration == null) {
                ErrorReporter.logError((String)("The configuration `" + this.actualConfiguration + "' for project `" + this.project.getName() + "' does not exist."));
            } else {
                ProjectFileHandler fileHandler = new ProjectFileHandler(this.project);
                fileHandler.loadProjectInfoFromNode(configurationNode, changedResources);
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    public void saveActualConfiguration() {
        String configuration = this.configurations.getText();
        try {
            this.project.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "org.eclipse.titan.designer.activeConfiguration"), configuration);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        Document document = ProjectDocumentHandlingUtility.getDocument(this.project);
        if (document == null) {
            return;
        }
        Node configurationNode = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), this.getActualSelection());
        if (configurationNode == null) {
            configurationNode = ProjectFileHandler.createConfigurationNode(document, this.getActualSelection());
        }
        ProjectFileHandler.saveProjectInfoToNode(this.project, configurationNode, document, (IProgressMonitor)new NullProgressMonitor());
        ProjectFileHandler.saveActualConfigurationInfoToNode(this.project, document);
    }

    public void clearActualConfiguration() {
        this.actualConfiguration = null;
        ProjectDocumentHandlingUtility.clearDocument(this.project);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.configurations.addSelectionListener(listener);
    }

    public void refresh() {
        if (this.configurations == null) {
            return;
        }
        String temp = this.configurations.getText();
        if (!this.actualConfiguration.equals(temp)) {
            this.configurations.setText(this.actualConfiguration);
        }
    }

    static class ConfigurationDialog
    extends Dialog {
        private String name;
        private Text nameText;
        private final String windowHeader;

        public ConfigurationDialog(Shell shell, String name, String windowHeader) {
            super(shell);
            this.name = name;
            this.windowHeader = windowHeader;
            int style = this.getShellStyle();
            this.setShellStyle(style | 0x10);
        }

        public String getName() {
            return this.name;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(this.windowHeader);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            Button ok = this.getButton(0);
            if (ok != null) {
                ok.setEnabled(this.name.length() > 0);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            composite.setLayout((Layout)layout);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            composite.setLayoutData((Object)data);
            Label label = new Label(composite, 0);
            label.setText("The name of the configuration: ");
            label.setLayoutData((Object)new GridData(32));
            this.nameText = new Text(composite, 2052);
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.setText(this.name);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String tempName = nameText.getText();
                    Button ok = this.getButton(0);
                    ok.setEnabled(tempName.length() > 0);
                }
            });
            Control result = super.createDialogArea(parent);
            return result;
        }

        protected void okPressed() {
            this.name = this.nameText.getText();
            super.okPressed();
        }
    }

    class ConfigurationListDialog
    extends Dialog {
        private TableViewer hostViewer;
        private final String[] hostTableColumnHeaders;
        private final ColumnLayoutData[] hostTableColumnLayouts;
        private Text errorText;

        public ConfigurationListDialog(Shell shell) {
            super(shell);
            this.hostTableColumnHeaders = new String[]{"Configuration", "Status"};
            this.hostTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(60), new ColumnWeightData(40)};
        }

        protected int getShellStyle() {
            return super.getShellStyle() | 0x10;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText("Manage Configurations");
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            this.hostViewer = new TableViewer(container, 67588);
            Table table = this.hostViewer.getTable();
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            table.setFont(container.getFont());
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            this.hostViewer.getControl().setLayoutData((Object)data);
            this.hostViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider(ProjectFileHandler.getActiveConfigurationName(ConfigurationManagerControl.this.project)));
            this.hostViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
            for (int i = 0; i < this.hostTableColumnHeaders.length; ++i) {
                tableLayout.addColumnData(this.hostTableColumnLayouts[i]);
                TableColumn tc = new TableColumn(table, 0, i);
                tc.setResizable(true);
                tc.setMoveable(true);
                tc.setText(this.hostTableColumnHeaders[i]);
            }
            List<String> tempConfigurations = ProjectFileHandler.getConfigurations(ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project));
            this.hostViewer.setInput((Object)tempConfigurations.toArray(new String[tempConfigurations.size()]));
            Composite composite = new Composite(container, 0);
            GridLayout layout = new GridLayout(3, true);
            composite.setLayout((Layout)layout);
            data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalAlignment = 4;
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            composite.setLayoutData((Object)data);
            Button addButton = new Button(composite, 8);
            addButton.setText("New...");
            addButton.setFont(parent.getFont());
            addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ConfigurationDialog dialog = new ConfigurationDialog(ConfigurationListDialog.this.getShell(), "", "Create new configuration");
                    if (dialog.open() == 0) {
                        Node configurationRoot;
                        String newName = dialog.getName();
                        Document document = ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project);
                        List<String> configurations = ProjectFileHandler.getConfigurations(document);
                        if (configurations.contains(newName)) {
                            ConfigurationListDialog.this.errorText.setText("It is not possible to create a new configuration with name `" + newName + "' as there is already one with that name.");
                            ConfigurationListDialog.this.errorText.setEnabled(true);
                            return;
                        }
                        ConfigurationListDialog.this.errorText.setEnabled(false);
                        Node configurationsRoot = ProjectFileHandler.getNodebyName(document.getDocumentElement().getChildNodes(), "Configurations");
                        if (configurationsRoot == null) {
                            configurationsRoot = document.createElement("Configurations");
                            document.getDocumentElement().appendChild(configurationsRoot);
                        }
                        if ((configurationRoot = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), newName)) == null) {
                            Element newConfiguration = document.createElement("Configuration");
                            newConfiguration.setAttribute("name", newName);
                            configurationsRoot.appendChild(newConfiguration);
                            configurationRoot = newConfiguration;
                        }
                        ProjectFileHandler.saveProjectInfoToNode(ConfigurationManagerControl.this.project, configurationRoot, document, (IProgressMonitor)new NullProgressMonitor());
                        configurations = ProjectFileHandler.getConfigurations(ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project));
                        ConfigurationListDialog.this.hostViewer.setInput((Object)configurations.toArray(new String[configurations.size()]));
                    }
                }
            });
            Button deleteButton = new Button(composite, 8);
            deleteButton.setText("Delete");
            deleteButton.setFont(parent.getFont());
            deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    IStructuredSelection sel = (IStructuredSelection)ConfigurationListDialog.this.hostViewer.getSelection();
                    String configuration = (String)sel.getFirstElement();
                    if ("Default".equals(configuration)) {
                        ConfigurationListDialog.this.errorText.setText("The `Default' configuration can not be deleted.");
                        ConfigurationListDialog.this.errorText.setEnabled(true);
                        return;
                    }
                    ConfigurationListDialog.this.errorText.setEnabled(false);
                    Document document = ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project);
                    ProjectFileHandler fileHandler = new ProjectFileHandler(ConfigurationManagerControl.this.project);
                    fileHandler.removeConfigurationNode(document.getDocumentElement(), configuration);
                    List<String> tempConfigurations = ProjectFileHandler.getConfigurations(ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project));
                    ConfigurationListDialog.this.hostViewer.setInput((Object)tempConfigurations.toArray(new String[tempConfigurations.size()]));
                    String tempActualConfiguration = ConfigurationManagerControl.this.getActualSelection();
                    if (configuration.equals(tempActualConfiguration)) {
                        ConfigurationManagerControl.this.configurations.setText("Default");
                        ConfigurationManagerControl.this.changeActualConfiguration();
                    }
                }
            });
            Button renameButton = new Button(composite, 8);
            renameButton.setText("Rename");
            renameButton.setFont(parent.getFont());
            renameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    IStructuredSelection sel = (IStructuredSelection)ConfigurationListDialog.this.hostViewer.getSelection();
                    String configuration = (String)sel.getFirstElement();
                    if ("Default".equals(configuration)) {
                        ConfigurationListDialog.this.errorText.setText("The `Default' configuration can not be renamed.");
                        ConfigurationListDialog.this.errorText.setEnabled(true);
                        return;
                    }
                    ConfigurationDialog dialog = new ConfigurationDialog(ConfigurationListDialog.this.getShell(), configuration, "Rename configuration");
                    if (dialog.open() == 0) {
                        String newName = dialog.getName();
                        List<String> newConfigurations = ProjectFileHandler.getConfigurations(ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project));
                        if (newConfigurations.contains(newName)) {
                            ConfigurationListDialog.this.errorText.setText("It is not possible to create a new configuration with name `" + newName + "' as there is already one with that name.");
                            ConfigurationListDialog.this.errorText.setEnabled(true);
                            return;
                        }
                        Document document = ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project);
                        Node configurationsRoot = ProjectFileHandler.getNodebyName(document.getDocumentElement().getChildNodes(), "Configurations");
                        if (configurationsRoot == null) {
                            configurationsRoot = document.createElement("Configurations");
                            document.getDocumentElement().appendChild(configurationsRoot);
                        }
                        Node configurationRoot = ProjectFileHandler.findConfigurationNode(document.getDocumentElement(), configuration);
                        ((Element)configurationRoot).setAttribute("name", newName);
                        newConfigurations = ProjectFileHandler.getConfigurations(ProjectDocumentHandlingUtility.getDocument(ConfigurationManagerControl.this.project));
                        ConfigurationListDialog.this.hostViewer.setInput((Object)newConfigurations.toArray(new String[newConfigurations.size()]));
                        ConfigurationManagerControl.this.configurations.setText(newName);
                        ConfigurationManagerControl.this.saveActualConfiguration();
                    }
                    ConfigurationListDialog.this.errorText.setEnabled(false);
                }
            });
            this.errorText = new Text(container, 74);
            this.errorText.setLayoutData((Object)new GridData(4, 4, true, true));
            this.errorText.setEditable(false);
            this.errorText.setEnabled(false);
            return container;
        }

        class ConfigurationLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private final String activeConfigurationName;

            ConfigurationLabelProvider(String activeConfigurationName) {
                this.activeConfigurationName = activeConfigurationName;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof String) {
                    String temp = (String)element;
                    switch (columnIndex) {
                        case 0: {
                            return temp;
                        }
                        case 1: {
                            return this.activeConfigurationName.equals(temp) ? "Active" : "";
                        }
                    }
                }
                return null;
            }
        }

        class ConfigurationContentProvider
        implements IStructuredContentProvider {
            ConfigurationContentProvider() {
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof String[]) {
                    return (String[])inputElement;
                }
                return new String[0];
            }
        }
    }
}

