/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.designer.graphics.ImageCache;

public final class RemoteHostDialog
extends Dialog {
    private static final String TITLE = "Remote build host";
    private static final String ACTIVE_TEXT = "Active";
    private static final String ACTIVE_TOOLTIP = "The host only takes part in the build if it is active";
    private static final String NAME_TEXT = "Name:";
    private static final String DEFAULT_NAME = "temporary name";
    private static final String NAME_TOOLTIP = "The name of the host (used to identify the running process)";
    private static final String COMMAND_TEXT = "Command:";
    private static final String DEFAULT_COMMAND = "rsh <[user@]hostname> -n 'cd <working directory>; make dep; make'";
    private static final String COMMAND_TOOLTIP = "The command to execute" + System.getProperty("line.separator") + "For example: rsh <[user@]hostname> -n 'cd <working directory>; make dep; make'";
    private String name = "temporary name";
    private String command = "rsh <[user@]hostname> -n 'cd <working directory>; make dep; make'";
    private Label nameLabel;
    private Label commandLabel;
    private Text nameText;
    private Text commandText;
    private Button activeButton;
    private boolean active = false;
    private final String title;
    private final Image[] images = new Image[]{ImageCache.getImageDescriptor("question.gif").createImage(), ImageCache.getImageDescriptor("host.gif").createImage(), ImageCache.getImageDescriptor("command.gif").createImage()};

    public RemoteHostDialog(Shell shell) {
        super(shell);
        this.title = TITLE;
    }

    protected int getShellStyle() {
        return super.getShellStyle() | 0x10;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getName() {
        return this.name;
    }

    public void setCommand(String value) {
        this.command = value;
    }

    public String getCommand() {
        return this.command;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                for (int i = 0; i < RemoteHostDialog.this.images.length; ++i) {
                    RemoteHostDialog.this.images[i].dispose();
                }
            }
        });
    }

    private void validate() {
        if (null != this.getButton(0)) {
            this.getButton(0).setEnabled(this.commandText.getText().length() != 0);
        }
    }

    protected void okPressed() {
        this.active = this.activeButton.getSelection();
        this.name = this.nameText.getText();
        this.command = this.commandText.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createActiveArea(container);
        Composite panel = new Composite(container, 0);
        GridLayout layout = new GridLayout(3, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        this.createNameArea(panel);
        this.createCommandArea(panel);
        Dialog.applyDialogFont((Control)container);
        this.validate();
        return container;
    }

    protected void createActiveArea(Composite parent) {
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(768));
        Label label = new Label(panel, 0);
        label.setLayoutData((Object)new GridData(32));
        label.setImage(this.images[0]);
        label.setToolTipText(ACTIVE_TOOLTIP);
        this.activeButton = new Button(panel, 32);
        this.activeButton.setText(ACTIVE_TEXT);
        this.activeButton.setToolTipText(ACTIVE_TOOLTIP);
        this.activeButton.setSelection(this.active);
    }

    protected void createNameArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(32));
        label.setImage(this.images[1]);
        label.setToolTipText(NAME_TOOLTIP);
        this.nameLabel = new Label(parent, 0);
        this.nameLabel.setText(NAME_TEXT);
        this.nameLabel.setLayoutData((Object)new GridData(32));
        this.nameLabel.setToolTipText(NAME_TOOLTIP);
        this.nameText = new Text(parent, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(this.name);
        this.nameLabel.setSize(this.nameLabel.getSize().x, this.nameText.getSize().y);
    }

    protected void createCommandArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(32));
        label.setImage(this.images[2]);
        label.setToolTipText(COMMAND_TOOLTIP);
        this.commandLabel = new Label(parent, 0);
        this.commandLabel.setText(COMMAND_TEXT);
        this.commandLabel.setLayoutData((Object)new GridData(32));
        this.commandLabel.setToolTipText(COMMAND_TOOLTIP);
        this.commandText = new Text(parent, 2052);
        this.commandText.setLayoutData((Object)new GridData(768));
        this.commandText.setText(this.command);
        this.commandLabel.setSize(this.commandLabel.getSize().x, this.commandText.getSize().y);
    }
}

