/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.refactoring;

import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.refactoring.RenameRefactoring;

public class RenameRefactoringInputPage
extends UserInputWizardPage {
    private Text newNameText;

    public RenameRefactoringInputPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.initializeDialogUnits((Control)top);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(top, 0);
        label.setText("New name:");
        this.newNameText = new Text(top, 2048);
        this.newNameText.setLayoutData((Object)new GridData(768));
        this.newNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (RenameRefactoringInputPage.this.checkNewNameValidity()) {
                    ((RenameRefactoring)RenameRefactoringInputPage.this.getRefactoring()).setNewIdentifierName(RenameRefactoringInputPage.this.newNameText.getText());
                }
            }
        });
        String oldName = "";
        switch (((RenameRefactoring)this.getRefactoring()).getModule().getModuletype()) {
            case TTCN3_MODULE: {
                oldName = ((RenameRefactoring)this.getRefactoring()).getRefdIdentifier().getTtcnName();
                break;
            }
            case ASN_MODULE: {
                oldName = ((RenameRefactoring)this.getRefactoring()).getRefdIdentifier().getAsnName();
                break;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
            }
        }
        this.newNameText.setText(oldName);
        this.newNameText.setFocus();
        this.newNameText.selectAll();
        this.checkNewNameValidity();
    }

    boolean checkNewNameValidity() {
        String newName = this.newNameText.getText();
        if (newName.length() == 0) {
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return false;
        }
        switch (((RenameRefactoring)this.getRefactoring()).getModule().getModuletype()) {
            case TTCN3_MODULE: {
                if (Identifier.isValidInTtcn(newName)) break;
                this.setErrorMessage("Not a valid TTCN-3 identifier!");
                this.setPageComplete(false);
                return false;
            }
            case ASN_MODULE: {
                if (Identifier.isValidInAsn(newName)) break;
                this.setErrorMessage("Not a valid ASN.1 identifier!");
                this.setPageComplete(false);
                return false;
            }
            default: {
                ErrorReporter.INTERNAL_ERROR();
            }
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
        return true;
    }
}

