/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.actions.ModuleGraphFromEditor;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class ModuleGraphFromBrowser
extends AbstractHandler
implements IObjectActionDelegate {
    private ISelection selection;

    public void run(IAction action) {
        this.doModuleGraphFromBrowser();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.selection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        this.doModuleGraphFromBrowser();
        return null;
    }

    private void doModuleGraphFromBrowser() {
        if (!(this.selection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection structSelection = (IStructuredSelection)this.selection;
        for (Object selectedFile : structSelection.toList()) {
            IProject project = ((IResource)selectedFile).getProject();
            ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)((IResource)selectedFile).getProject());
            Module actualModule = projectSourceParser.containedModule((IFile)selectedFile);
            ModuleGraphFromEditor.Generator generator = new ModuleGraphFromEditor.Generator(project, actualModule);
            generator.schedule();
        }
    }
}

