/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.metrics.risk;

import org.eclipse.titanium.metrics.IMetricEnum;
import org.eclipse.titanium.metrics.preferences.PreferenceManager;
import org.eclipse.titanium.metrics.preferences.RiskMethod;
import org.eclipse.titanium.metrics.risk.IRisk;
import org.eclipse.titanium.metrics.utils.RiskLevel;

public abstract class BaseRisk
implements IRisk {
    protected final RiskMethod method;
    protected final Number[] limits;

    public BaseRisk(IMetricEnum metric) {
        this.method = PreferenceManager.getRiskMethod(metric, false);
        this.limits = PreferenceManager.getLimits(metric, false);
    }

    @Override
    public RiskLevel getRiskLevel(Number value) {
        double v = this.getRiskValue(value);
        return BaseRisk.risk(v);
    }

    public static RiskLevel risk(double v) {
        RiskLevel color = v < 1.0 ? RiskLevel.NO : (v < 2.0 ? RiskLevel.LOW : RiskLevel.HIGH);
        return color;
    }
}

