/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.actions;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.console.ConsoleWriter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.TitanLogExceptionHandler;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;
import org.eclipse.titan.log.viewer.models.LogRecordIndex;
import org.eclipse.titan.log.viewer.parsers.Parser;
import org.eclipse.titan.log.viewer.parsers.data.TestCase;
import org.eclipse.titan.log.viewer.preferences.PreferencesHandler;
import org.eclipse.titan.log.viewer.preferences.PreferencesHolder;
import org.eclipse.titan.log.viewer.utils.ActionUtils;
import org.eclipse.titan.log.viewer.utils.LogFileCacheHandler;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.views.MSCView;
import org.eclipse.titan.log.viewer.views.msc.model.ExecutionModel;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class OpenMSCViewMenuAction
extends AbstractHandler
implements IActionDelegate,
ISelectionChangedListener {
    private IStructuredSelection selection;
    private LogFileMetaData logFileMetaData;
    private int recordToSelect = -1;

    public void run(IAction action) {
        this.run(this.selection);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection tempSelection = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getActivePage().getSelection();
        if (!(tempSelection instanceof IStructuredSelection)) {
            return null;
        }
        this.selection = (IStructuredSelection)tempSelection;
        this.run(this.selection);
        return null;
    }

    public void run(IStructuredSelection selection) {
        if (!this.isEnabled()) {
            return;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof TestCase)) {
            return;
        }
        final TestCase tc = (TestCase)element;
        IFile logFile = tc.getLogFile();
        try {
            this.logFileMetaData = LogFileCacheHandler.logFileMetaDataReader(LogFileCacheHandler.getPropertyFileForLogFile(logFile));
        }
        catch (IOException e1) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        catch (ClassNotFoundException e1) {
            LogFileCacheHandler.handleLogFileChange(logFile);
            return;
        }
        try {
            if (!PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName()).getVisualOrderComponents().isEmpty()) {
                final long start = new Date().getTime();
                if (!logFile.exists()) {
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IViewReference[] viewReferences = activePage.getViewReferences();
                    ActionUtils.closeAssociatedViews(activePage, viewReferences, (IResource)logFile);
                    TitanLogExceptionHandler.handleException(new UserException(Messages.getString("OpenMSCViewMenuAction.4")));
                    return;
                }
                if (LogFileCacheHandler.hasLogFileChanged(logFile)) {
                    LogFileCacheHandler.handleLogFileChange(logFile);
                    return;
                }
                File logRecordIndexFile = LogFileCacheHandler.getLogRecordIndexFileForLogFile(logFile);
                final LogRecordIndex[] logRecordIndexes = LogFileCacheHandler.readLogRecordIndexFile(logRecordIndexFile, tc.getStartRecordNumber(), tc.getNumberOfRecords());
                final PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName());
                WorkspaceJob job = new WorkspaceJob("Loading log information"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        ExecutionModel model;
                        Parser parser;
                        if (OpenMSCViewMenuAction.this.logFileMetaData == null || OpenMSCViewMenuAction.this.logFileMetaData.getExecutionMode() == null) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            parser = new Parser(OpenMSCViewMenuAction.this.logFileMetaData);
                            parser.setStart(start);
                            model = parser.preParse(tc, logRecordIndexes, preferences, null, monitor);
                        }
                        catch (TechnicalException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenMSCViewMenuAction.3") + e.getMessage()));
                            return Status.CANCEL_STATUS;
                        }
                        catch (ParseException e) {
                            ErrorReporter.logExceptionStackTrace((Exception)e);
                            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenMSCViewMenuAction.2") + e.getMessage()));
                            return Status.CANCEL_STATUS;
                        }
                        catch (IOException e) {
                            ErrorReporter.logExceptionStackTrace((String)"Error while parsing of the log file", (Throwable)e);
                            TitanLogExceptionHandler.handleException(new TechnicalException(e.getMessage()));
                            return Status.CANCEL_STATUS;
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                OpenMSCViewMenuAction.this.showView(model, parser, tc);
                                long end = new Date().getTime();
                                parser.setEnd(end);
                                ConsoleWriter.getInstance().writeModelData(OpenMSCViewMenuAction.this.logFileMetaData.getProjectName(), parser, model, OpenMSCViewMenuAction.this.logFileMetaData.getFilePath().toString());
                            }
                        });
                        return Status.OK_STATUS;
                    }
                };
                job.schedule();
            } else {
                String userE = Messages.getString("OpenMSCViewMenuAction.1");
                TitanLogExceptionHandler.handleException(new UserException(userE));
            }
        }
        catch (IOException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while parsing of the log file", (Throwable)e);
            TitanLogExceptionHandler.handleException(new TechnicalException(e.getMessage()));
        }
    }

    private static String generateSecondaryViewId(TestCase testCase, LogFileMetaData metaData) {
        String secondId = testCase.getTestCaseName() + testCase.getTestCaseNumber() + metaData.getFilePath().toString().replaceAll(":", "_") + metaData.getProjectRelativePath();
        return secondId;
    }

    private int getFirstRowToSelect(PreferencesHolder preferences, ExecutionModel model) {
        int firstRow;
        if (this.recordToSelect == -1) {
            switch (preferences.getMscViewOpen()) {
                case 0: {
                    firstRow = 0;
                    break;
                }
                case 1: {
                    firstRow = model.getNumberOfEvents() - 1;
                    break;
                }
                case 2: {
                    if (model.getSetverdict().length > 0) {
                        firstRow = model.getSetverdict()[0];
                        break;
                    }
                    firstRow = 0;
                    break;
                }
                default: {
                    firstRow = 0;
                    break;
                }
            }
        } else {
            firstRow = model.getRecordsPosition(this.recordToSelect) + 2;
        }
        return firstRow;
    }

    private void showView(ExecutionModel model, Parser parser, TestCase tc) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        String viewId = "org.eclipse.titan.log.viewer.views.MSCView";
        String secondId = OpenMSCViewMenuAction.generateSecondaryViewId(tc, this.logFileMetaData);
        IViewReference reference = activePage.findViewReference("org.eclipse.titan.log.viewer.views.MSCView", secondId);
        MSCView part = null;
        if (reference != null) {
            part = (MSCView)reference.getView(false);
        }
        if (part != null) {
            activePage.hideView((IViewPart)part);
        }
        try {
            part = (MSCView)activePage.showView("org.eclipse.titan.log.viewer.views.MSCView", secondId, 1);
        }
        catch (PartInitException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            TitanLogExceptionHandler.handleException(new TechnicalException(Messages.getString("OpenMSCViewMenuAction.3") + e.getMessage()));
            return;
        }
        part.setLogFileMetaData(this.logFileMetaData);
        PreferencesHolder preferences = PreferencesHandler.getInstance().getPreferences(this.logFileMetaData.getProjectName());
        part.setModel(model, this.getFirstRowToSelect(preferences, model));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            this.setEnabled(false);
            return;
        }
        this.selection = (IStructuredSelection)selection;
        if (this.selection.size() != 1 || !(this.selection.getFirstElement() instanceof TestCase)) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(null, event.getSelection());
    }

    public void setFirstRow(int recordNumber) {
        this.recordToSelect = recordNumber;
    }
}

